#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#

# Aggregation
{"sql":"SELECT AVG(ActualElapsedTime), COUNT(DivDistance), MIN(DepDelay) FROM mytable"}
{"sql":"SELECT AVG(ArrDelayMinutes) FROM mytable"}
{"sql":"SELECT AVG(ArrTime), AVG(DivDistance), MIN(NASDelay) FROM mytable"}
{"sql":"SELECT AVG(CRSDepTime), AVG(ArrDel15), MAX(DepartureDelayGroups) FROM mytable"}
{"sql":"SELECT AVG(CarrierDelay), MIN(DivReachedDest), MIN(FirstDepTime) FROM mytable"}
{"sql":"SELECT AVG(DayOfWeek), AVG(DestAirportID), AVG(DepTime) FROM mytable"}
{"sql":"SELECT AVG(DepDel15), MAX(LateAircraftDelay) FROM mytable"}
{"sql":"SELECT AVG(DestAirportSeqID), SUM(DestCityMarketID) FROM mytable"}
{"sql":"SELECT AVG(LateAircraftDelay), SUM(DaysSinceEpoch), MAX(\"Month\") FROM mytable","hsqls":["SELECT AVG(LateAircraftDelay), SUM(DaysSinceEpoch), MAX(`Month`) FROM mytable"]}
{"sql":"SELECT AVG(Quarter), MIN(DayOfWeek), SUM(TaxiIn) FROM mytable"}
{"sql":"SELECT AVG(TotalAddGTime), COUNT(DivAirportLandings) FROM mytable"}
{"sql":"SELECT AVG(\"Month\"), AVG(LateAircraftDelay), MAX(\"Month\") FROM mytable LIMIT 4","hsqls":["SELECT AVG(`Month`), AVG(LateAircraftDelay), MAX(`Month`) FROM mytable"]}
{"sql":"SELECT AVG(\"Month\"), MIN(DepartureDelayGroups) FROM mytable LIMIT 16","hsqls":["SELECT AVG(`Month`), MIN(DepartureDelayGroups) FROM mytable"]}
{"sql":"SELECT AVG(\"Year\"), AVG(DivReachedDest), MIN(ArrDel15) FROM mytable LIMIT 22","hsqls":["SELECT AVG(`Year`), AVG(DivReachedDest), MIN(ArrDel15) FROM mytable"]}
{"sql":"SELECT COUNT(*) FROM mytable"}
{"sql":"SELECT COUNT(ArrDelayMinutes), MAX(ArrDelayMinutes), SUM(TaxiIn) FROM mytable"}
{"sql":"SELECT COUNT(Carrier), AVG(DivDistance), SUM(DistanceGroup) FROM mytable"}
{"sql":"SELECT COUNT(CarrierDelay), SUM(DepartureDelayGroups) FROM mytable"}
{"sql":"SELECT COUNT(DepDel15), COUNT(DepDelay), SUM(DepartureDelayGroups) FROM mytable LIMIT 13"}
{"sql":"SELECT COUNT(DestCityName), MIN(\"Month\") FROM mytable LIMIT 20","hsqls":["SELECT COUNT(DestCityName), MIN(`Month`) FROM mytable"]}
{"sql":"SELECT COUNT(Origin), MIN(ArrDel15), MIN(ArrivalDelayGroups) FROM mytable"}
{"sql":"SELECT COUNT(OriginCityMarketID), MIN(SecurityDelay), MAX(DepTime) FROM mytable"}
{"sql":"SELECT MAX(DestAirportID), AVG(CRSElapsedTime), MAX(DivActualElapsedTime) FROM mytable"}
{"sql":"SELECT MAX(DestAirportID), MAX(DestStateFips), MIN(DestAirportID) FROM mytable"}
{"sql":"SELECT MAX(WheelsOff), MIN(LateAircraftDelay), COUNT(FlightDate) FROM mytable"}
{"sql":"SELECT MAX(\"Year\"), MIN(Distance) FROM mytable","hsqls":["SELECT MAX(`Year`), MIN(Distance) FROM mytable"]}
{"sql":"SELECT MAX(\"Year\"), SUM(OriginAirportSeqID) FROM mytable","hsqls":["SELECT MAX(`Year`), SUM(OriginAirportSeqID) FROM mytable"]}
{"sql":"SELECT MIN(SecurityDelay), MIN(DivArrDelay), MIN(DestAirportSeqID) FROM mytable"}
{"sql":"SELECT MIN(WheelsOn), MIN(ActualElapsedTime), AVG(OriginAirportID) FROM mytable"}
{"sql":"SELECT MIN(\"Year\") FROM mytable","hsqls":["SELECT MIN(`Year`) FROM mytable"]}
{"sql":"SELECT SUM(CarrierDelay), SUM(DivActualElapsedTime), AVG(DepDelayMinutes) FROM mytable"}
{"sql":"SELECT SUM(DepDelayMinutes), COUNT(OriginCityName), COUNT(DivAirportLandings) FROM mytable"}
{"sql":"SELECT SUM(DestAirportSeqID), MIN(\"Month\"), MAX(DayOfWeek) FROM mytable","hsqls":["SELECT SUM(DestAirportSeqID), MIN(`Month`), MAX(DayOfWeek) FROM mytable"]}
{"sql":"SELECT SUM(\"Year\"), AVG(OriginStateFips) FROM mytable","hsqls":["SELECT SUM(`Year`), AVG(OriginStateFips) FROM mytable"]}
{"sql":"SELECT SUM(\"Year\"), MIN(OriginCityMarketID) FROM mytable","hsqls":["SELECT SUM(`Year`), MIN(OriginCityMarketID) FROM mytable"]}

# Grouping on Aggregation
{"sql":"SELECT ActualElapsedTime, COUNT(DayofMonth), AVG(Cancelled), MIN(OriginCityMarketID) FROM mytable GROUP BY ActualElapsedTime  ORDER BY ActualElapsedTime LIMIT 22","hsqls":["SELECT ActualElapsedTime, COUNT(DayofMonth), AVG(Cancelled), MIN(OriginCityMarketID) FROM mytable GROUP BY ActualElapsedTime  ORDER BY ActualElapsedTime LIMIT 22"]}
{"sql":"SELECT ActualElapsedTime, DestStateName, DivAirportLandings, SUM(DivReachedDest), COUNT(WheelsOff) FROM mytable GROUP BY ActualElapsedTime, DestStateName, DivAirportLandings  ORDER BY ActualElapsedTime, DestStateName, DivAirportLandings LIMIT 24","hsqls":["SELECT ActualElapsedTime, DestStateName, DivAirportLandings, SUM(DivReachedDest), COUNT(WheelsOff) FROM mytable GROUP BY ActualElapsedTime, DestStateName, DivAirportLandings  ORDER BY ActualElapsedTime, DestStateName, DivAirportLandings LIMIT 24"]}
{"sql":"SELECT AirlineID, WheelsOn, AVG(LateAircraftDelay) FROM mytable GROUP BY AirlineID, WheelsOn  ORDER BY AirlineID, WheelsOn LIMIT 11","hsqls":["SELECT AirlineID, WheelsOn, AVG(LateAircraftDelay) FROM mytable GROUP BY AirlineID, WheelsOn  ORDER BY AirlineID, WheelsOn LIMIT 11"]}
{"sql":"SELECT ArrDel15, DestStateName, DayofMonth, COUNT(SecurityDelay), AVG(CarrierDelay), COUNT(FirstDepTime) FROM mytable GROUP BY ArrDel15, DestStateName, DayofMonth  ORDER BY ArrDel15, DestStateName, DayofMonth LIMIT 23","hsqls":["SELECT ArrDel15, DestStateName, DayofMonth, COUNT(SecurityDelay), AVG(CarrierDelay), COUNT(FirstDepTime) FROM mytable GROUP BY ArrDel15, DestStateName, DayofMonth  ORDER BY ArrDel15, DestStateName, DayofMonth LIMIT 23"]}
{"sql":"SELECT ArrDel15, OriginStateName, MAX(AirTime) FROM mytable GROUP BY ArrDel15, OriginStateName  ORDER BY ArrDel15, OriginStateName LIMIT 2","hsqls":["SELECT ArrDel15, OriginStateName, MAX(AirTime) FROM mytable GROUP BY ArrDel15, OriginStateName  ORDER BY ArrDel15, OriginStateName LIMIT 2"]}
{"sql":"SELECT ArrDelay, COUNT(*) FROM mytable GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 10","hsqls":["SELECT ArrDelay, COUNT(*) FROM mytable GROUP BY ArrDelay  ORDER BY ArrDelay LIMIT 10"]}
{"sql":"SELECT ArrDelay, CRSElapsedTime, OriginAirportID, COUNT(DivAirportLandings) FROM mytable GROUP BY ArrDelay, CRSElapsedTime, OriginAirportID  ORDER BY ArrDelay, CRSElapsedTime, OriginAirportID LIMIT 19","hsqls":["SELECT ArrDelay, CRSElapsedTime, OriginAirportID, COUNT(DivAirportLandings) FROM mytable GROUP BY ArrDelay, CRSElapsedTime, OriginAirportID  ORDER BY ArrDelay, CRSElapsedTime, OriginAirportID LIMIT 19"]}
{"sql":"SELECT ArrDelayMinutes, AVG(CRSDepTime), MAX(SecurityDelay) FROM mytable GROUP BY ArrDelayMinutes  ORDER BY ArrDelayMinutes LIMIT 15","hsqls":["SELECT ArrDelayMinutes, AVG(CRSDepTime), MAX(SecurityDelay) FROM mytable GROUP BY ArrDelayMinutes  ORDER BY ArrDelayMinutes LIMIT 15"]}
{"sql":"SELECT ArrDelayMinutes, ArrDel15, COUNT(*) FROM mytable GROUP BY ArrDelayMinutes, ArrDel15  ORDER BY ArrDelayMinutes, ArrDel15 LIMIT 3","hsqls":["SELECT ArrDelayMinutes, ArrDel15, COUNT(*) FROM mytable GROUP BY ArrDelayMinutes, ArrDel15  ORDER BY ArrDelayMinutes, ArrDel15 LIMIT 3"]}
{"sql":"SELECT ArrDelayMinutes, ArrivalDelayGroups, MAX(DestAirportSeqID), MIN(TotalAddGTime), COUNT(LateAircraftDelay) FROM mytable GROUP BY ArrDelayMinutes, ArrivalDelayGroups  ORDER BY ArrDelayMinutes, ArrivalDelayGroups LIMIT 19","hsqls":["SELECT ArrDelayMinutes, ArrivalDelayGroups, MAX(DestAirportSeqID), MIN(TotalAddGTime), COUNT(LateAircraftDelay) FROM mytable GROUP BY ArrDelayMinutes, ArrivalDelayGroups  ORDER BY ArrDelayMinutes, ArrivalDelayGroups LIMIT 19"]}
{"sql":"SELECT ArrDelayMinutes, Dest, AirlineID, MAX(DepTime), SUM(DistanceGroup) FROM mytable GROUP BY ArrDelayMinutes, Dest, AirlineID  ORDER BY ArrDelayMinutes, Dest, AirlineID LIMIT 13","hsqls":["SELECT ArrDelayMinutes, Dest, AirlineID, MAX(DepTime), SUM(DistanceGroup) FROM mytable GROUP BY ArrDelayMinutes, Dest, AirlineID  ORDER BY ArrDelayMinutes, Dest, AirlineID LIMIT 13"]}
{"sql":"SELECT ArrTime, CRSElapsedTime, MIN(DestAirportID), AVG(CRSArrTime) FROM mytable GROUP BY ArrTime, CRSElapsedTime  ORDER BY ArrTime, CRSElapsedTime LIMIT 29","hsqls":["SELECT ArrTime, CRSElapsedTime, MIN(DestAirportID), AVG(CRSArrTime) FROM mytable GROUP BY ArrTime, CRSElapsedTime  ORDER BY ArrTime, CRSElapsedTime LIMIT 29"]}
{"sql":"SELECT ArrTime, DayofMonth, WheelsOn, MIN(ArrDelay), MAX(DestWac) FROM mytable GROUP BY ArrTime, DayofMonth, WheelsOn  ORDER BY ArrTime, DayofMonth, WheelsOn LIMIT 17","hsqls":["SELECT ArrTime, DayofMonth, WheelsOn, MIN(ArrDelay), MAX(DestWac) FROM mytable GROUP BY ArrTime, DayofMonth, WheelsOn  ORDER BY ArrTime, DayofMonth, WheelsOn LIMIT 17"]}
{"sql":"SELECT ArrTime, NASDelay, WheelsOn, COUNT(ArrDel15), MIN(OriginCityMarketID) FROM mytable GROUP BY ArrTime, NASDelay, WheelsOn  ORDER BY ArrTime, NASDelay, WheelsOn LIMIT 27","hsqls":["SELECT ArrTime, NASDelay, WheelsOn, COUNT(ArrDel15), MIN(OriginCityMarketID) FROM mytable GROUP BY ArrTime, NASDelay, WheelsOn  ORDER BY ArrTime, NASDelay, WheelsOn LIMIT 27"]}
{"sql":"SELECT ArrTimeBlk, AirlineID, DaysSinceEpoch, MIN(DestCityMarketID), AVG(DivArrDelay) FROM mytable GROUP BY ArrTimeBlk, AirlineID, DaysSinceEpoch  ORDER BY ArrTimeBlk, AirlineID, DaysSinceEpoch LIMIT 6","hsqls":["SELECT ArrTimeBlk, AirlineID, DaysSinceEpoch, MIN(DestCityMarketID), AVG(DivArrDelay) FROM mytable GROUP BY ArrTimeBlk, AirlineID, DaysSinceEpoch  ORDER BY ArrTimeBlk, AirlineID, DaysSinceEpoch LIMIT 6"]}
{"sql":"SELECT ArrTimeBlk, TailNum, COUNT(*) FROM mytable GROUP BY ArrTimeBlk, TailNum  ORDER BY ArrTimeBlk, TailNum LIMIT 10","hsqls":["SELECT ArrTimeBlk, TailNum, COUNT(*) FROM mytable GROUP BY ArrTimeBlk, TailNum  ORDER BY ArrTimeBlk, TailNum LIMIT 10"]}
{"sql":"SELECT ArrivalDelayGroups, AVG(DestCityMarketID), COUNT(Diverted), AVG(LateAircraftDelay) FROM mytable GROUP BY ArrivalDelayGroups  ORDER BY ArrivalDelayGroups LIMIT 19","hsqls":["SELECT ArrivalDelayGroups, AVG(DestCityMarketID), COUNT(Diverted), AVG(LateAircraftDelay) FROM mytable GROUP BY ArrivalDelayGroups  ORDER BY ArrivalDelayGroups LIMIT 19"]}
{"sql":"SELECT ArrivalDelayGroups, COUNT(Flights), COUNT(DepTime) FROM mytable GROUP BY ArrivalDelayGroups  ORDER BY ArrivalDelayGroups LIMIT 12","hsqls":["SELECT ArrivalDelayGroups, COUNT(Flights), COUNT(DepTime) FROM mytable GROUP BY ArrivalDelayGroups  ORDER BY ArrivalDelayGroups LIMIT 12"]}
{"sql":"SELECT ArrivalDelayGroups, MIN(LateAircraftDelay), MIN(NASDelay), SUM(Quarter) FROM mytable GROUP BY ArrivalDelayGroups  ORDER BY ArrivalDelayGroups LIMIT 20","hsqls":["SELECT ArrivalDelayGroups, MIN(LateAircraftDelay), MIN(NASDelay), SUM(Quarter) FROM mytable GROUP BY ArrivalDelayGroups  ORDER BY ArrivalDelayGroups LIMIT 20"]}
{"sql":"SELECT CancellationCode, MAX(SecurityDelay), COUNT(CarrierDelay) FROM mytable GROUP BY CancellationCode  ORDER BY CancellationCode LIMIT 10","hsqls":["SELECT CancellationCode, MAX(SecurityDelay), COUNT(CarrierDelay) FROM mytable GROUP BY CancellationCode  ORDER BY CancellationCode LIMIT 10"]}
{"sql":"SELECT Cancelled, DepDel15, AVG(DepDelay), AVG(DivArrDelay), AVG(DepartureDelayGroups) FROM mytable GROUP BY Cancelled, DepDel15  ORDER BY Cancelled, DepDel15 LIMIT 26","hsqls":["SELECT Cancelled, DepDel15, AVG(DepDelay), AVG(DivArrDelay), AVG(DepartureDelayGroups) FROM mytable GROUP BY Cancelled, DepDel15  ORDER BY Cancelled, DepDel15 LIMIT 26"]}
{"sql":"SELECT Carrier, ArrDel15, ArrivalDelayGroups, COUNT(NASDelay), MAX(DivActualElapsedTime), MAX(CRSDepTime) FROM mytable GROUP BY Carrier, ArrDel15, ArrivalDelayGroups  ORDER BY Carrier, ArrDel15, ArrivalDelayGroups LIMIT 4","hsqls":["SELECT Carrier, ArrDel15, ArrivalDelayGroups, COUNT(NASDelay), MAX(DivActualElapsedTime), MAX(CRSDepTime) FROM mytable GROUP BY Carrier, ArrDel15, ArrivalDelayGroups  ORDER BY Carrier, ArrDel15, ArrivalDelayGroups LIMIT 4"]}
{"sql":"SELECT Carrier, MAX(DestStateFips), MIN(NASDelay), AVG(DivAirportLandings) FROM mytable GROUP BY Carrier  ORDER BY Carrier LIMIT 5","hsqls":["SELECT Carrier, MAX(DestStateFips), MIN(NASDelay), AVG(DivAirportLandings) FROM mytable GROUP BY Carrier  ORDER BY Carrier LIMIT 5"]}
{"sql":"SELECT Carrier, UniqueCarrier, MAX(DivDistance), AVG(CarrierDelay), AVG(SecurityDelay) FROM mytable GROUP BY Carrier, UniqueCarrier  ORDER BY Carrier, UniqueCarrier LIMIT 10","hsqls":["SELECT Carrier, UniqueCarrier, MAX(DivDistance), AVG(CarrierDelay), AVG(SecurityDelay) FROM mytable GROUP BY Carrier, UniqueCarrier  ORDER BY Carrier, UniqueCarrier LIMIT 10"]}
{"sql":"SELECT CarrierDelay, AVG(DayofMonth), MIN(DepDel15), SUM(Quarter) FROM mytable GROUP BY CarrierDelay  ORDER BY CarrierDelay LIMIT 26","hsqls":["SELECT CarrierDelay, AVG(DayofMonth), MIN(DepDel15), SUM(Quarter) FROM mytable GROUP BY CarrierDelay  ORDER BY CarrierDelay LIMIT 26"]}
{"sql":"SELECT DayofMonth, MAX(DestStateFips), MIN(DivDistance), MAX(LateAircraftDelay) FROM mytable GROUP BY DayofMonth  ORDER BY DayofMonth LIMIT 21","hsqls":["SELECT DayofMonth, MAX(DestStateFips), MIN(DivDistance), MAX(LateAircraftDelay) FROM mytable GROUP BY DayofMonth  ORDER BY DayofMonth LIMIT 21"]}
{"sql":"SELECT DaysSinceEpoch, COUNT(DivDistance), AVG(Cancelled), COUNT(LongestAddGTime) FROM mytable GROUP BY DaysSinceEpoch  ORDER BY DaysSinceEpoch LIMIT 24","hsqls":["SELECT DaysSinceEpoch, COUNT(DivDistance), AVG(Cancelled), COUNT(LongestAddGTime) FROM mytable GROUP BY DaysSinceEpoch  ORDER BY DaysSinceEpoch LIMIT 24"]}
{"sql":"SELECT DepDelay, DivArrDelay, COUNT(*) FROM mytable GROUP BY DepDelay, DivArrDelay  ORDER BY DepDelay, DivArrDelay LIMIT 19","hsqls":["SELECT DepDelay, DivArrDelay, COUNT(*) FROM mytable GROUP BY DepDelay, DivArrDelay  ORDER BY DepDelay, DivArrDelay LIMIT 19"]}
{"sql":"SELECT DepDelay, DivDistance, DaysSinceEpoch, MIN(DepartureDelayGroups), MIN(DepDel15), MAX(DestCityMarketID) FROM mytable GROUP BY DepDelay, DivDistance, DaysSinceEpoch  ORDER BY DepDelay, DivDistance, DaysSinceEpoch LIMIT 14","hsqls":["SELECT DepDelay, DivDistance, DaysSinceEpoch, MIN(DepartureDelayGroups), MIN(DepDel15), MAX(DestCityMarketID) FROM mytable GROUP BY DepDelay, DivDistance, DaysSinceEpoch  ORDER BY DepDelay, DivDistance, DaysSinceEpoch LIMIT 14"]}
{"sql":"SELECT DepDelayMinutes, TaxiIn, DestAirportSeqID, MAX(DepDelayMinutes) FROM mytable GROUP BY DepDelayMinutes, TaxiIn, DestAirportSeqID  ORDER BY DepDelayMinutes, TaxiIn, DestAirportSeqID LIMIT 11","hsqls":["SELECT DepDelayMinutes, TaxiIn, DestAirportSeqID, MAX(DepDelayMinutes) FROM mytable GROUP BY DepDelayMinutes, TaxiIn, DestAirportSeqID  ORDER BY DepDelayMinutes, TaxiIn, DestAirportSeqID LIMIT 11"]}
{"sql":"SELECT DepTime, AirTime, AirlineID, MIN(WheelsOn), MAX(Diverted), MIN(ArrivalDelayGroups) FROM mytable GROUP BY DepTime, AirTime, AirlineID  ORDER BY DepTime, AirTime, AirlineID LIMIT 7","hsqls":["SELECT DepTime, AirTime, AirlineID, MIN(WheelsOn), MAX(Diverted), MIN(ArrivalDelayGroups) FROM mytable GROUP BY DepTime, AirTime, AirlineID  ORDER BY DepTime, AirTime, AirlineID LIMIT 7"]}
{"sql":"SELECT DestStateFips, ArrTime, DaysSinceEpoch, COUNT(*) FROM mytable GROUP BY DestStateFips, ArrTime, DaysSinceEpoch  ORDER BY DestStateFips, ArrTime, DaysSinceEpoch LIMIT 7","hsqls":["SELECT DestStateFips, ArrTime, DaysSinceEpoch, COUNT(*) FROM mytable GROUP BY DestStateFips, ArrTime, DaysSinceEpoch  ORDER BY DestStateFips, ArrTime, DaysSinceEpoch LIMIT 7"]}
{"sql":"SELECT DestStateName, DestCityMarketID, DaysSinceEpoch, MIN(NASDelay), MIN(DistanceGroup), MAX(DivAirportLandings) FROM mytable GROUP BY DestStateName, DestCityMarketID, DaysSinceEpoch  ORDER BY DestStateName, DestCityMarketID, DaysSinceEpoch LIMIT 7","hsqls":["SELECT DestStateName, DestCityMarketID, DaysSinceEpoch, MIN(NASDelay), MIN(DistanceGroup), MAX(DivAirportLandings) FROM mytable GROUP BY DestStateName, DestCityMarketID, DaysSinceEpoch  ORDER BY DestStateName, DestCityMarketID, DaysSinceEpoch LIMIT 7"]}
{"sql":"SELECT DestWac, DayofMonth, SUM(DestAirportSeqID), MIN(DivDistance) FROM mytable GROUP BY DestWac, DayofMonth  ORDER BY DestWac, DayofMonth LIMIT 8","hsqls":["SELECT DestWac, DayofMonth, SUM(DestAirportSeqID), MIN(DivDistance) FROM mytable GROUP BY DestWac, DayofMonth  ORDER BY DestWac, DayofMonth LIMIT 8"]}
{"sql":"SELECT DistanceGroup, OriginCityMarketID, ArrDel15, COUNT(*) FROM mytable GROUP BY DistanceGroup, OriginCityMarketID, ArrDel15  ORDER BY DistanceGroup, OriginCityMarketID, ArrDel15 LIMIT 1","hsqls":["SELECT DistanceGroup, OriginCityMarketID, ArrDel15, COUNT(*) FROM mytable GROUP BY DistanceGroup, OriginCityMarketID, ArrDel15  ORDER BY DistanceGroup, OriginCityMarketID, ArrDel15 LIMIT 1"]}
{"sql":"SELECT DivDistance, DestAirportSeqID, Origin, COUNT(DestAirportSeqID), COUNT(Diverted), MIN(CRSArrTime) FROM mytable GROUP BY DivDistance, DestAirportSeqID, Origin  ORDER BY DivDistance, DestAirportSeqID, Origin LIMIT 18","hsqls":["SELECT DivDistance, DestAirportSeqID, Origin, COUNT(DestAirportSeqID), COUNT(Diverted), MIN(CRSArrTime) FROM mytable GROUP BY DivDistance, DestAirportSeqID, Origin  ORDER BY DivDistance, DestAirportSeqID, Origin LIMIT 18"]}
{"sql":"SELECT DivReachedDest, ArrivalDelayGroups, MAX(TaxiIn), AVG(OriginStateFips) FROM mytable GROUP BY DivReachedDest, ArrivalDelayGroups  ORDER BY DivReachedDest, ArrivalDelayGroups LIMIT 15","hsqls":["SELECT DivReachedDest, ArrivalDelayGroups, MAX(TaxiIn), AVG(OriginStateFips) FROM mytable GROUP BY DivReachedDest, ArrivalDelayGroups  ORDER BY DivReachedDest, ArrivalDelayGroups LIMIT 15"]}
{"sql":"SELECT DivReachedDest, Quarter, DivArrDelay, SUM(FirstDepTime) FROM mytable GROUP BY DivReachedDest, Quarter, DivArrDelay  ORDER BY DivReachedDest, Quarter, DivArrDelay LIMIT 10","hsqls":["SELECT DivReachedDest, Quarter, DivArrDelay, SUM(FirstDepTime) FROM mytable GROUP BY DivReachedDest, Quarter, DivArrDelay  ORDER BY DivReachedDest, Quarter, DivArrDelay LIMIT 10"]}
{"sql":"SELECT Diverted, DayOfWeek, AVG(DestCityMarketID), SUM(DepartureDelayGroups), AVG(DestWac) FROM mytable GROUP BY Diverted, DayOfWeek  ORDER BY Diverted, DayOfWeek LIMIT 17","hsqls":["SELECT Diverted, DayOfWeek, AVG(DestCityMarketID), SUM(DepartureDelayGroups), AVG(DestWac) FROM mytable GROUP BY Diverted, DayOfWeek  ORDER BY Diverted, DayOfWeek LIMIT 17"]}
{"sql":"SELECT Diverted, OriginState, AirlineID, COUNT(FlightNum) FROM mytable GROUP BY Diverted, OriginState, AirlineID  ORDER BY Diverted, OriginState, AirlineID LIMIT 1","hsqls":["SELECT Diverted, OriginState, AirlineID, COUNT(FlightNum) FROM mytable GROUP BY Diverted, OriginState, AirlineID  ORDER BY Diverted, OriginState, AirlineID LIMIT 1"]}
{"sql":"SELECT FirstDepTime, DepTime, DepDel15, MAX(WheelsOn), COUNT(DepDelayMinutes) FROM mytable GROUP BY FirstDepTime, DepTime, DepDel15  ORDER BY FirstDepTime, DepTime, DepDel15 LIMIT 2","hsqls":["SELECT FirstDepTime, DepTime, DepDel15, MAX(WheelsOn), COUNT(DepDelayMinutes) FROM mytable GROUP BY FirstDepTime, DepTime, DepDel15  ORDER BY FirstDepTime, DepTime, DepDel15 LIMIT 2"]}
{"sql":"SELECT FirstDepTime, SecurityDelay, DestStateFips, COUNT(OriginCityMarketID), MIN(DepDelay) FROM mytable GROUP BY FirstDepTime, SecurityDelay, DestStateFips  ORDER BY FirstDepTime, SecurityDelay, DestStateFips LIMIT 13","hsqls":["SELECT FirstDepTime, SecurityDelay, DestStateFips, COUNT(OriginCityMarketID), MIN(DepDelay) FROM mytable GROUP BY FirstDepTime, SecurityDelay, DestStateFips  ORDER BY FirstDepTime, SecurityDelay, DestStateFips LIMIT 13"]}
{"sql":"SELECT FlightDate, OriginWac, DivActualElapsedTime, SUM(Quarter) FROM mytable GROUP BY FlightDate, OriginWac, DivActualElapsedTime  ORDER BY FlightDate, OriginWac, DivActualElapsedTime LIMIT 26","hsqls":["SELECT FlightDate, OriginWac, DivActualElapsedTime, SUM(Quarter) FROM mytable GROUP BY FlightDate, OriginWac, DivActualElapsedTime  ORDER BY FlightDate, OriginWac, DivActualElapsedTime LIMIT 26"]}
{"sql":"SELECT FlightNum, DestStateName, AVG(OriginWac), MAX(Distance) FROM mytable GROUP BY FlightNum, DestStateName  ORDER BY FlightNum, DestStateName LIMIT 7","hsqls":["SELECT FlightNum, DestStateName, AVG(OriginWac), MAX(Distance) FROM mytable GROUP BY FlightNum, DestStateName  ORDER BY FlightNum, DestStateName LIMIT 7"]}
{"sql":"SELECT Flights, DestCityName, CRSElapsedTime, COUNT(DivDistance) FROM mytable GROUP BY Flights, DestCityName, CRSElapsedTime  ORDER BY Flights, DestCityName, CRSElapsedTime LIMIT 18","hsqls":["SELECT Flights, DestCityName, CRSElapsedTime, COUNT(DivDistance) FROM mytable GROUP BY Flights, DestCityName, CRSElapsedTime  ORDER BY Flights, DestCityName, CRSElapsedTime LIMIT 18"]}
{"sql":"SELECT LateAircraftDelay, FlightNum, MAX(Flights), SUM(LateAircraftDelay), AVG(CRSArrTime) FROM mytable GROUP BY LateAircraftDelay, FlightNum  ORDER BY LateAircraftDelay, FlightNum LIMIT 7","hsqls":["SELECT LateAircraftDelay, FlightNum, MAX(Flights), SUM(LateAircraftDelay), AVG(CRSArrTime) FROM mytable GROUP BY LateAircraftDelay, FlightNum  ORDER BY LateAircraftDelay, FlightNum LIMIT 7"]}
{"sql":"SELECT LongestAddGTime, MIN(ActualElapsedTime), AVG(OriginStateFips) FROM mytable GROUP BY LongestAddGTime  ORDER BY LongestAddGTime LIMIT 16","hsqls":["SELECT LongestAddGTime, MIN(ActualElapsedTime), AVG(OriginStateFips) FROM mytable GROUP BY LongestAddGTime  ORDER BY LongestAddGTime LIMIT 16"]}
{"sql":"SELECT OriginCityMarketID, Dest, DestAirportID, COUNT(*) FROM mytable GROUP BY OriginCityMarketID, Dest, DestAirportID  ORDER BY OriginCityMarketID, Dest, DestAirportID LIMIT 24","hsqls":["SELECT OriginCityMarketID, Dest, DestAirportID, COUNT(*) FROM mytable GROUP BY OriginCityMarketID, Dest, DestAirportID  ORDER BY OriginCityMarketID, Dest, DestAirportID LIMIT 24"]}
{"sql":"SELECT OriginCityName, TailNum, MAX(DayOfWeek) FROM mytable GROUP BY OriginCityName, TailNum  ORDER BY OriginCityName, TailNum LIMIT 13","hsqls":["SELECT OriginCityName, TailNum, MAX(DayOfWeek) FROM mytable GROUP BY OriginCityName, TailNum  ORDER BY OriginCityName, TailNum LIMIT 13"]}
{"sql":"SELECT OriginState, CRSDepTime, SUM(Flights) FROM mytable GROUP BY OriginState, CRSDepTime  ORDER BY OriginState, CRSDepTime LIMIT 22","hsqls":["SELECT OriginState, CRSDepTime, SUM(Flights) FROM mytable GROUP BY OriginState, CRSDepTime  ORDER BY OriginState, CRSDepTime LIMIT 22"]}
{"sql":"SELECT OriginStateFips, DaysSinceEpoch, COUNT(OriginStateFips), AVG(CarrierDelay) FROM mytable GROUP BY OriginStateFips, DaysSinceEpoch  ORDER BY OriginStateFips, DaysSinceEpoch LIMIT 1","hsqls":["SELECT OriginStateFips, DaysSinceEpoch, COUNT(OriginStateFips), AVG(CarrierDelay) FROM mytable GROUP BY OriginStateFips, DaysSinceEpoch  ORDER BY OriginStateFips, DaysSinceEpoch LIMIT 1"]}
{"sql":"SELECT OriginWac, DayOfWeek, MAX(DestAirportID), MAX(CarrierDelay) FROM mytable GROUP BY OriginWac, DayOfWeek  ORDER BY OriginWac, DayOfWeek LIMIT 16","hsqls":["SELECT OriginWac, DayOfWeek, MAX(DestAirportID), MAX(CarrierDelay) FROM mytable GROUP BY OriginWac, DayOfWeek  ORDER BY OriginWac, DayOfWeek LIMIT 16"]}
{"sql":"SELECT Quarter, WheelsOn, MAX(CarrierDelay), AVG(ArrivalDelayGroups), MIN(LongestAddGTime) FROM mytable GROUP BY Quarter, WheelsOn  ORDER BY Quarter, WheelsOn LIMIT 19","hsqls":["SELECT Quarter, WheelsOn, MAX(CarrierDelay), AVG(ArrivalDelayGroups), MIN(LongestAddGTime) FROM mytable GROUP BY Quarter, WheelsOn  ORDER BY Quarter, WheelsOn LIMIT 19"]}
{"sql":"SELECT SecurityDelay, AirTime, COUNT(DepDelayMinutes), AVG(DepTime), MIN(OriginCityMarketID) FROM mytable GROUP BY SecurityDelay, AirTime  ORDER BY SecurityDelay, AirTime LIMIT 8","hsqls":["SELECT SecurityDelay, AirTime, COUNT(DepDelayMinutes), AVG(DepTime), MIN(OriginCityMarketID) FROM mytable GROUP BY SecurityDelay, AirTime  ORDER BY SecurityDelay, AirTime LIMIT 8"]}
{"sql":"SELECT SecurityDelay, Origin, DayofMonth, COUNT(Cancelled) FROM mytable GROUP BY SecurityDelay, Origin, DayofMonth  ORDER BY SecurityDelay, Origin, DayofMonth LIMIT 18","hsqls":["SELECT SecurityDelay, Origin, DayofMonth, COUNT(Cancelled) FROM mytable GROUP BY SecurityDelay, Origin, DayofMonth  ORDER BY SecurityDelay, Origin, DayofMonth LIMIT 18"]}
{"sql":"SELECT TaxiOut, MAX(DestStateFips), AVG(DestCityMarketID) FROM mytable GROUP BY TaxiOut  ORDER BY TaxiOut LIMIT 4","hsqls":["SELECT TaxiOut, MAX(DestStateFips), AVG(DestCityMarketID) FROM mytable GROUP BY TaxiOut  ORDER BY TaxiOut LIMIT 4"]}
{"sql":"SELECT TaxiOut, UniqueCarrier, SUM(WheelsOn), AVG(DestWac) FROM mytable GROUP BY TaxiOut, UniqueCarrier  ORDER BY TaxiOut, UniqueCarrier LIMIT 20","hsqls":["SELECT TaxiOut, UniqueCarrier, SUM(WheelsOn), AVG(DestWac) FROM mytable GROUP BY TaxiOut, UniqueCarrier  ORDER BY TaxiOut, UniqueCarrier LIMIT 20"]}
{"sql":"SELECT UniqueCarrier, OriginAirportID, AVG(LongestAddGTime) FROM mytable GROUP BY UniqueCarrier, OriginAirportID  ORDER BY UniqueCarrier, OriginAirportID LIMIT 1","hsqls":["SELECT UniqueCarrier, OriginAirportID, AVG(LongestAddGTime) FROM mytable GROUP BY UniqueCarrier, OriginAirportID  ORDER BY UniqueCarrier, OriginAirportID LIMIT 1"]}
{"sql":"SELECT WeatherDelay, DepDel15, DepTimeBlk, COUNT(*) FROM mytable GROUP BY WeatherDelay, DepDel15, DepTimeBlk  ORDER BY WeatherDelay, DepDel15, DepTimeBlk LIMIT 16","hsqls":["SELECT WeatherDelay, DepDel15, DepTimeBlk, COUNT(*) FROM mytable GROUP BY WeatherDelay, DepDel15, DepTimeBlk  ORDER BY WeatherDelay, DepDel15, DepTimeBlk LIMIT 16"]}
{"sql":"SELECT WheelsOn, OriginStateName, AVG(DepDel15) FROM mytable GROUP BY WheelsOn, OriginStateName  ORDER BY WheelsOn, OriginStateName LIMIT 18","hsqls":["SELECT WheelsOn, OriginStateName, AVG(DepDel15) FROM mytable GROUP BY WheelsOn, OriginStateName  ORDER BY WheelsOn, OriginStateName LIMIT 18"]}

# Filtering on Aggregation
{"sql":"SELECT AVG(AirTime), SUM(OriginStateFips) FROM mytable WHERE DivTailNums BETWEEN 'N8315C' AND 'N130DL' OR DivAirports IN ('PIH', 'DLH', 'MTJ', 'SEA', 'LIT') AND TaxiOut NOT IN (59, 112, 57, 72) LIMIT 5","hsqls":["SELECT AVG(AirTime), SUM(OriginStateFips)  FROM mytable WHERE (DivTailNums[1] BETWEEN 'N8315C' AND 'N130DL' OR DivTailNums[2] BETWEEN 'N8315C' AND 'N130DL' OR DivTailNums[3] BETWEEN 'N8315C' AND 'N130DL' OR DivTailNums[4] BETWEEN 'N8315C' AND 'N130DL' OR DivTailNums[5] BETWEEN 'N8315C' AND 'N130DL') OR (ARRAY_CONTAINS(DivAirports, 'PIH') OR ARRAY_CONTAINS(DivAirports, 'DLH') OR ARRAY_CONTAINS(DivAirports, 'MTJ') OR ARRAY_CONTAINS(DivAirports, 'SEA') OR ARRAY_CONTAINS(DivAirports, 'LIT')) AND TaxiOut NOT IN (59, 112, 57, 72) LIMIT 10000"]}
{"sql":"SELECT AVG(ArrDel15) FROM mytable WHERE DivWheelsOffs >= 1610 LIMIT 13","hsqls":["SELECT AVG(CAST(ArrDel15 AS DOUBLE)) FROM mytable WHERE (DivWheelsOffs[1] >= 1610 OR DivWheelsOffs[2] >= 1610 OR DivWheelsOffs[3] >= 1610 OR DivWheelsOffs[4] >= 1610 OR DivWheelsOffs[5] >= 1610) LIMIT 10000"]}
{"sql":"SELECT AVG(CRSDepTime), MIN(DivReachedDest) FROM mytable WHERE \"Year\" = 2014 OR Origin BETWEEN 'MLU' AND 'BDL' OR DestStateFips > 18 LIMIT 22","hsqls":["SELECT AVG(CRSDepTime), MIN(DivReachedDest) FROM mytable WHERE `Year` = 2014 OR Origin BETWEEN 'MLU' AND 'BDL' OR DestStateFips > 18 LIMIT 22"]}
{"sql":"SELECT AVG(CarrierDelay), AVG(OriginCityMarketID), MAX(ArrTime) FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 OR AirlineID <= 20398 LIMIT 14","hsqls":["SELECT AVG(CarrierDelay), AVG(OriginCityMarketID), MAX(ArrTime) FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 OR AirlineID <= 20398 LIMIT 14"]}
{"sql":"SELECT AVG(DayOfWeek) FROM mytable WHERE DivTailNums IN ('N915DE', 'N8612K') LIMIT 3","hsqls":["SELECT AVG(CAST(DayOfWeek AS DOUBLE)) FROM mytable WHERE ARRAY_CONTAINS(DivTailNums, 'N915DE') OR ARRAY_CONTAINS(DivTailNums, 'N8612K') LIMIT 10000"]}
{"sql":"SELECT AVG(DayOfWeek), MAX(Diverted) FROM mytable WHERE DivAirportSeqIDs >= 1281902 OR DestAirportSeqID NOT IN (1463502, 1530402, 1068502) AND DepDelayMinutes BETWEEN 48.0 AND 94.0 LIMIT 18","hsqls":["SELECT AVG(DayOfWeek), MAX(Diverted)  FROM mytable WHERE (DivAirportSeqIDs[1] >= 1281902 OR DivAirportSeqIDs[2] >= 1281902 OR DivAirportSeqIDs[3] >= 1281902 OR DivAirportSeqIDs[4] >= 1281902 OR DivAirportSeqIDs[5] >= 1281902) OR DestAirportSeqID NOT IN (1463502, 1530402, 1068502) AND DepDelayMinutes BETWEEN 48.0 AND 94.0 LIMIT 10000"]}
{"sql":"SELECT AVG(DayofMonth), COUNT(CRSElapsedTime) FROM mytable WHERE LateAircraftDelay BETWEEN 151 AND 72 OR \"Year\" IN (2014) LIMIT 14","hsqls":["SELECT AVG(DayofMonth), COUNT(CRSElapsedTime) FROM mytable WHERE LateAircraftDelay BETWEEN 151 AND 72 OR `Year` IN (2014) LIMIT 14"]}
{"sql":"SELECT AVG(DaysSinceEpoch) FROM mytable WHERE DivAirportIDs > 14027 AND DivLongestGTimes >= 61.0 AND Cancelled BETWEEN 0 AND 1 LIMIT 3","hsqls":["SELECT AVG(CAST(DaysSinceEpoch AS DOUBLE)) FROM mytable WHERE (DivAirportIDs[1] > 14027 OR DivAirportIDs[2] > 14027 OR DivAirportIDs[3] > 14027 OR DivAirportIDs[4] > 14027 OR DivAirportIDs[5] > 14027) AND (DivLongestGTimes[1] >= 61.0 OR DivLongestGTimes[2] >= 61.0 OR DivLongestGTimes[3] >= 61.0 OR DivLongestGTimes[4] >= 61.0 OR DivLongestGTimes[5] >= 61.0) AND Cancelled BETWEEN 0 AND 1 LIMIT 10000"]}
{"sql":"SELECT AVG(TotalAddGTime), MAX(OriginStateFips) FROM mytable WHERE \"Year\" NOT IN (2014) OR ArrDelay BETWEEN -30.0 AND 31.0 AND DayOfWeek NOT IN (6, 5) LIMIT 15","hsqls":["SELECT AVG(TotalAddGTime), MAX(OriginStateFips) FROM mytable WHERE `Year` NOT IN (2014) OR ArrDelay BETWEEN -30.0 AND 31.0 AND DayOfWeek NOT IN (6, 5) LIMIT 15"]}
{"sql":"SELECT AVG(TotalAddGTime), SUM(ArrivalDelayGroups), SUM(SecurityDelay) FROM mytable WHERE UniqueCarrier = 'AA' OR Cancelled IN (1, 0) OR DivWheelsOffs BETWEEN 1719 AND 1720 LIMIT 16","hsqls":["SELECT AVG(TotalAddGTime), SUM(ArrivalDelayGroups), SUM(SecurityDelay)  FROM mytable WHERE UniqueCarrier = 'AA' OR Cancelled IN (1, 0) OR (DivWheelsOffs[1] BETWEEN 1719 AND 1720 OR DivWheelsOffs[2] BETWEEN 1719 AND 1720 OR DivWheelsOffs[3] BETWEEN 1719 AND 1720 OR DivWheelsOffs[4] BETWEEN 1719 AND 1720 OR DivWheelsOffs[5] BETWEEN 1719 AND 1720) LIMIT 10000"]}
{"sql":"SELECT AVG(WeatherDelay), MIN(ArrTime) FROM mytable WHERE TaxiIn < 162 OR DivAirports >= 'SIT' OR OriginWac BETWEEN 1 AND 71 LIMIT 21","hsqls":["SELECT AVG(WeatherDelay), MIN(ArrTime)  FROM mytable WHERE TaxiIn < 162 OR (DivAirports[1] >= 'SIT' OR DivAirports[2] >= 'SIT' OR DivAirports[3] >= 'SIT' OR DivAirports[4] >= 'SIT' OR DivAirports[5] >= 'SIT') OR OriginWac BETWEEN 1 AND 71 LIMIT 10000"]}
{"sql":"SELECT AVG(\"Year\"), SUM(ArrivalDelayGroups), MAX(DepartureDelayGroups) FROM mytable WHERE DivWheelsOffs IN (1702, 2226, 749, 2328, 844) OR ArrDelay NOT IN (25.0, 58.0, -19.0, 281.0, 418.0) LIMIT 2","hsqls":["SELECT AVG(`Year`), SUM(ArrivalDelayGroups), MAX(DepartureDelayGroups)  FROM mytable WHERE (ARRAY_CONTAINS(DivWheelsOffs, 1702) OR ARRAY_CONTAINS(DivWheelsOffs, 2226) OR ARRAY_CONTAINS(DivWheelsOffs, 749) OR ARRAY_CONTAINS(DivWheelsOffs, 2328) OR ARRAY_CONTAINS(DivWheelsOffs, 844)) OR ArrDelay NOT IN (25.0, 58.0, -19.0, 281.0, 418.0) LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE ActualElapsedTime NOT IN (90, 178, 247, 118, 119) OR DistanceGroup BETWEEN 10 AND 4 AND DivAirportSeqIDs BETWEEN 1252302 AND 1232303 LIMIT 4","hsqls":["SELECT COUNT(*) FROM mytable WHERE ActualElapsedTime NOT IN (90, 178, 247, 118, 119) OR DistanceGroup BETWEEN 10 AND 4 AND (DivAirportSeqIDs[1] BETWEEN 1252302 AND 1232303 OR DivAirportSeqIDs[2] BETWEEN 1252302 AND 1232303 OR DivAirportSeqIDs[3] BETWEEN 1252302 AND 1232303 OR DivAirportSeqIDs[4] BETWEEN 1252302 AND 1232303 OR DivAirportSeqIDs[5] BETWEEN 1252302 AND 1232303) LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE CRSArrTime <> 1940 OR DivTailNums > 'N854AS' AND DayOfWeek NOT IN (3, 1, 6) LIMIT 15","hsqls":["SELECT COUNT(*) FROM mytable WHERE CRSArrTime <> 1940 OR (DivTailNums[1] > 'N854AS' OR DivTailNums[2] > 'N854AS' OR DivTailNums[3] > 'N854AS' OR DivTailNums[4] > 'N854AS' OR DivTailNums[5] > 'N854AS') AND DayOfWeek NOT IN (3, 1, 6) LIMIT 10000"]}
{"sql":"SELECT COUNT(*) FROM mytable WHERE \"Year\" BETWEEN 2014 AND 2014 OR DepTimeBlk BETWEEN '1400-1459' AND '1300-1359' LIMIT 8","hsqls":["SELECT COUNT(*) FROM mytable WHERE `Year` BETWEEN 2014 AND 2014 OR DepTimeBlk BETWEEN '1400-1459' AND '1300-1359' LIMIT 8"]}
{"sql":"SELECT COUNT(ActualElapsedTime), AVG(DestWac) FROM mytable WHERE DayOfWeek NOT IN (3, 1, 6, 4) OR DivTotalGTimes IN (62) LIMIT 18","hsqls":["SELECT COUNT(ActualElapsedTime), AVG(DestWac)  FROM mytable WHERE DayOfWeek NOT IN (3, 1, 6, 4) OR ARRAY_CONTAINS(DivTotalGTimes, 62) LIMIT 10000"]}
{"sql":"SELECT COUNT(AirTime) FROM mytable WHERE Cancelled BETWEEN 0 AND 0 OR DivWheelsOffs BETWEEN 2043 AND 2133 AND FlightNum NOT IN (3228) LIMIT 11","hsqls":["SELECT COUNT(AirTime) FROM mytable WHERE Cancelled BETWEEN 0 AND 0 OR (DivWheelsOffs[1] BETWEEN 2043 AND 2133 OR DivWheelsOffs[2] BETWEEN 2043 AND 2133 OR DivWheelsOffs[3] BETWEEN 2043 AND 2133 OR DivWheelsOffs[4] BETWEEN 2043 AND 2133 OR DivWheelsOffs[5] BETWEEN 2043 AND 2133) AND FlightNum NOT IN (3228) LIMIT 10000"]}
{"sql":"SELECT COUNT(CRSElapsedTime) FROM mytable WHERE DivWheelsOffs BETWEEN 1257 AND 325 AND DestState IN ('LA', 'MS') AND \"Month\" BETWEEN 1 AND 1 LIMIT 6","hsqls":["SELECT COUNT(CRSElapsedTime) FROM mytable WHERE (DivWheelsOffs[1] BETWEEN 1257 AND 325 OR DivWheelsOffs[2] BETWEEN 1257 AND 325 OR DivWheelsOffs[3] BETWEEN 1257 AND 325 OR DivWheelsOffs[4] BETWEEN 1257 AND 325 OR DivWheelsOffs[5] BETWEEN 1257 AND 325) AND DestState IN ('LA', 'MS') AND `Month` BETWEEN 1 AND 1 LIMIT 10000"]}
{"sql":"SELECT COUNT(Carrier), MIN(DivActualElapsedTime), MAX(DepDelayMinutes) FROM mytable WHERE DestCityMarketID NOT IN (31423) OR TaxiOut BETWEEN 24 AND 60 OR DivTotalGTimes BETWEEN 57 AND 76","hsqls":["SELECT COUNT(Carrier), MIN(DivActualElapsedTime), MAX(DepDelayMinutes)  FROM mytable WHERE DestCityMarketID NOT IN (31423) OR TaxiOut BETWEEN 24 AND 60 OR (DivTotalGTimes[1] BETWEEN 57 AND 76 OR DivTotalGTimes[2] BETWEEN 57 AND 76 OR DivTotalGTimes[3] BETWEEN 57 AND 76 OR DivTotalGTimes[4] BETWEEN 57 AND 76 OR DivTotalGTimes[5] BETWEEN 57 AND 76) LIMIT 10000"]}
{"sql":"SELECT COUNT(CarrierDelay), SUM(DestAirportID) FROM mytable WHERE DaysSinceEpoch <= 16073 AND DivAirportIDs IN (12278, 12451, 11973, 13424) LIMIT 15","hsqls":["SELECT COUNT(CarrierDelay), SUM(DestAirportID)  FROM mytable WHERE DaysSinceEpoch <= 16073 AND (ARRAY_CONTAINS(DivAirportIDs, 12278) OR ARRAY_CONTAINS(DivAirportIDs, 12451) OR ARRAY_CONTAINS(DivAirportIDs, 11973) OR ARRAY_CONTAINS(DivAirportIDs, 13424)) LIMIT 10000"]}
{"sql":"SELECT COUNT(DestStateName), SUM(ArrDelay), SUM(DepartureDelayGroups) FROM mytable WHERE DivAirportSeqIDs < 1234302 LIMIT 26","hsqls":["SELECT COUNT(DestStateName), SUM(ArrDelay), SUM(DepartureDelayGroups)  FROM mytable WHERE (DivAirportSeqIDs[1] < 1234302 OR DivAirportSeqIDs[2] < 1234302 OR DivAirportSeqIDs[3] < 1234302 OR DivAirportSeqIDs[4] < 1234302 OR DivAirportSeqIDs[5] < 1234302) LIMIT 10000"]}
{"sql":"SELECT COUNT(OriginCityMarketID), MAX(DestCityMarketID) FROM mytable WHERE Quarter NOT IN (1) OR Distance BETWEEN 1454 AND 196 AND DivAirportIDs <= 14006 LIMIT 22","hsqls":["SELECT COUNT(OriginCityMarketID), MAX(DestCityMarketID)  FROM mytable WHERE Quarter NOT IN (1) OR Distance BETWEEN 1454 AND 196 AND (DivAirportIDs[1] <= 14006 OR DivAirportIDs[2] <= 14006 OR DivAirportIDs[3] <= 14006 OR DivAirportIDs[4] <= 14006 OR DivAirportIDs[5] <= 14006) LIMIT 10000"]}
{"sql":"SELECT COUNT(OriginWac) FROM mytable WHERE CancellationCode BETWEEN 'A' AND 'A' AND DivTailNums BETWEEN 'N397DA' AND 'N940DN' LIMIT 5","hsqls":["SELECT COUNT(OriginWac) FROM mytable WHERE CancellationCode BETWEEN 'A' AND 'A' AND (DivTailNums[1] BETWEEN 'N397DA' AND 'N940DN' OR DivTailNums[2] BETWEEN 'N397DA' AND 'N940DN' OR DivTailNums[3] BETWEEN 'N397DA' AND 'N940DN' OR DivTailNums[4] BETWEEN 'N397DA' AND 'N940DN' OR DivTailNums[5] BETWEEN 'N397DA' AND 'N940DN') LIMIT 10000"]}
{"sql":"SELECT COUNT(\"Month\"), SUM(OriginAirportSeqID), MIN(AirlineID) FROM mytable WHERE DivTailNums <= 'N530MQ' AND AirTime NOT IN (122, 158, 73, 142) OR DestAirportID NOT IN (10423, 13303, 10581, 10747) LIMIT 2","hsqls":["SELECT COUNT(`Month`), SUM(OriginAirportSeqID), MIN(AirlineID)  FROM mytable WHERE (DivTailNums[1] <= 'N530MQ' OR DivTailNums[2] <= 'N530MQ' OR DivTailNums[3] <= 'N530MQ' OR DivTailNums[4] <= 'N530MQ' OR DivTailNums[5] <= 'N530MQ') AND AirTime NOT IN (122, 158, 73, 142) OR DestAirportID NOT IN (10423, 13303, 10581, 10747) LIMIT 10000"]}
{"sql":"SELECT MAX(AirTime) FROM mytable WHERE DaysSinceEpoch <> 16071 OR DivTailNums IN ('N713SK') AND DivActualElapsedTime BETWEEN 153 AND 1043 LIMIT 10","hsqls":["SELECT MAX(AirTime) FROM mytable WHERE DaysSinceEpoch <> 16071 OR ARRAY_CONTAINS(DivTailNums, 'N713SK') AND DivActualElapsedTime BETWEEN 153 AND 1043 LIMIT 10000"]}
{"sql":"SELECT MAX(ArrDelay), AVG(\"Month\"), MAX(ActualElapsedTime) FROM mytable WHERE DepTimeBlk IN ('2000-2059', '1300-1359', '1100-1159', '0600-0659', '0800-0859') LIMIT 14","hsqls":["SELECT MAX(ArrDelay), AVG(`Month`), MAX(ActualElapsedTime) FROM mytable WHERE DepTimeBlk IN ('2000-2059', '1300-1359', '1100-1159', '0600-0659', '0800-0859') LIMIT 14"]}
{"sql":"SELECT MAX(DistanceGroup), AVG(SecurityDelay), SUM(DestWac) FROM mytable WHERE NASDelay IN (49, 145, 45) AND DivWheelsOffs < 917 AND UniqueCarrier NOT IN ('F9', 'WN', 'OO', 'MQ', 'VX') LIMIT 27","hsqls":["SELECT MAX(DistanceGroup), AVG(SecurityDelay), SUM(DestWac)  FROM mytable WHERE NASDelay IN (49, 145, 45) AND (DivWheelsOffs[1] < 917 OR DivWheelsOffs[2] < 917 OR DivWheelsOffs[3] < 917 OR DivWheelsOffs[4] < 917 OR DivWheelsOffs[5] < 917) AND UniqueCarrier NOT IN ('F9', 'WN', 'OO', 'MQ', 'VX') LIMIT 10000"]}
{"sql":"SELECT MAX(DivActualElapsedTime), MIN(\"Month\"), AVG(WheelsOff) FROM mytable WHERE Diverted NOT IN (1, 0) OR Diverted BETWEEN 0 AND 1 AND DestCityMarketID = 31136 LIMIT 27","hsqls":["SELECT MAX(DivActualElapsedTime), MIN(`Month`), AVG(WheelsOff) FROM mytable WHERE Diverted NOT IN (1, 0) OR Diverted BETWEEN 0 AND 1 AND DestCityMarketID = 31136 LIMIT 27"]}
{"sql":"SELECT MAX(LongestAddGTime) FROM mytable WHERE DestStateName NOT IN ('New Hampshire', 'Massachusetts', 'California', 'Nevada') OR DaysSinceEpoch IN (16071, 16088, 16074, 16078, 16091) OR DivWheelsOns = 1317 LIMIT 11","hsqls":["SELECT MAX(LongestAddGTime) FROM mytable WHERE DestStateName NOT IN ('New Hampshire', 'Massachusetts', 'California', 'Nevada') OR DaysSinceEpoch IN (16071, 16088, 16074, 16078, 16091) OR (DivWheelsOns[1] = 1317 OR DivWheelsOns[2] = 1317 OR DivWheelsOns[3] = 1317 OR DivWheelsOns[4] = 1317 OR DivWheelsOns[5] = 1317) LIMIT 10000"]}
{"sql":"SELECT MAX(LongestAddGTime) FROM mytable WHERE WheelsOn NOT IN (1659, 936) OR DivTotalGTimes > 76 LIMIT 1","hsqls":["SELECT MAX(LongestAddGTime) FROM mytable WHERE WheelsOn NOT IN (1659, 936) OR (DivTotalGTimes[1] > 76 OR DivTotalGTimes[2] > 76 OR DivTotalGTimes[3] > 76 OR DivTotalGTimes[4] > 76 OR DivTotalGTimes[5] > 76) LIMIT 10000"]}
{"sql":"SELECT MAX(WheelsOff), COUNT(CancellationCode) FROM mytable WHERE ArrDel15 IN (1, 0, -9999) OR DivLongestGTimes < 57.0 OR DepDelay NOT IN (342.0, 48.0) LIMIT 25","hsqls":["SELECT MAX(WheelsOff), COUNT(CancellationCode)  FROM mytable WHERE ArrDel15 IN (1, 0, -9999) OR (DivLongestGTimes[1] < 57.0 OR DivLongestGTimes[2] < 57.0 OR DivLongestGTimes[3] < 57.0 OR DivLongestGTimes[4] < 57.0 OR DivLongestGTimes[5] < 57.0) OR DepDelay NOT IN (342.0, 48.0) LIMIT 10000"]}
{"sql":"SELECT MAX(\"Month\") FROM mytable WHERE CRSDepTime IN (1534, 2213) OR DestCityName BETWEEN 'Sacramento, CA' AND 'Nome, AK' OR ArrDelay > -7.0 LIMIT 11","hsqls":["SELECT MAX(`Month`) FROM mytable WHERE CRSDepTime IN (1534, 2213) OR DestCityName BETWEEN 'Sacramento, CA' AND 'Nome, AK' OR ArrDelay > -7.0 LIMIT 11"]}
{"sql":"SELECT MAX(\"Year\") FROM mytable WHERE DivWheelsOns >= 2058 OR UniqueCarrier BETWEEN 'VX' AND 'US' OR CRSElapsedTime > 290 LIMIT 20","hsqls":["SELECT MAX(`Year`) FROM mytable WHERE (DivWheelsOns[1] >= 2058 OR DivWheelsOns[2] >= 2058 OR DivWheelsOns[3] >= 2058 OR DivWheelsOns[4] >= 2058 OR DivWheelsOns[5] >= 2058) OR UniqueCarrier BETWEEN 'VX' AND 'US' OR CRSElapsedTime > 290 LIMIT 10000"]}
{"sql":"SELECT MIN(ArrDelay), COUNT(CRSDepTime), SUM(DayOfWeek) FROM mytable WHERE DivWheelsOffs >= 2009 AND Diverted >= 1 OR OriginCityMarketID >= 34783 LIMIT 29","hsqls":["SELECT MIN(ArrDelay), COUNT(CRSDepTime), SUM(DayOfWeek)  FROM mytable WHERE (DivWheelsOffs[1] >= 2009 OR DivWheelsOffs[2] >= 2009 OR DivWheelsOffs[3] >= 2009 OR DivWheelsOffs[4] >= 2009 OR DivWheelsOffs[5] >= 2009) AND Diverted >= 1 OR OriginCityMarketID >= 34783 LIMIT 10000"]}
{"sql":"SELECT MIN(ArrTime), AVG(AirlineID), COUNT(WeatherDelay) FROM mytable WHERE OriginCityName NOT IN ('Columbus, GA', 'Raleigh/Durham, NC') OR DivTailNums IN ('N314US', 'N3751B', 'N925DL', 'N393HA', 'N16951') LIMIT 29","hsqls":["SELECT MIN(ArrTime), AVG(AirlineID), COUNT(WeatherDelay)  FROM mytable WHERE OriginCityName NOT IN ('Columbus, GA', 'Raleigh/Durham, NC') OR (ARRAY_CONTAINS(DivTailNums,'N314US') OR ARRAY_CONTAINS(DivTailNums, 'N3751B') OR ARRAY_CONTAINS(DivTailNums, 'N925DL') OR ARRAY_CONTAINS(DivTailNums, 'N393HA') OR ARRAY_CONTAINS(DivTailNums, 'N16951')) LIMIT 10000"]}
{"sql":"SELECT MIN(DaysSinceEpoch), AVG(FlightNum) FROM mytable WHERE DepDel15 IN (1, 0, -9999) AND AirlineID BETWEEN 20366 AND 19393 OR DivAirportIDs IN (14730, 14262, 10868) LIMIT 6","hsqls":["SELECT MIN(DaysSinceEpoch), AVG(FlightNum)  FROM mytable WHERE DepDel15 IN (1, 0, -9999) AND AirlineID BETWEEN 20366 AND 19393 OR (ARRAY_CONTAINS(DivAirportIDs, 14730) OR ARRAY_CONTAINS(DivAirportIDs, 14262) OR ARRAY_CONTAINS(DivAirportIDs, 10868)) LIMIT 10000"]}
{"sql":"SELECT MIN(DaysSinceEpoch), COUNT(CRSElapsedTime) FROM mytable WHERE UniqueCarrier IN ('EV', 'F9', 'MQ', 'UA') AND DivWheelsOns IN (1717, 102, 1835) LIMIT 24","hsqls":["SELECT MIN(DaysSinceEpoch), COUNT(CRSElapsedTime)  FROM mytable WHERE UniqueCarrier IN ('EV', 'F9', 'MQ', 'UA') AND (ARRAY_CONTAINS(DivWheelsOns, 1717) OR ARRAY_CONTAINS(DivWheelsOns, 102) OR ARRAY_CONTAINS(DivWheelsOns, 1835)) LIMIT 10000"]}
{"sql":"SELECT MIN(DivReachedDest), AVG(AirTime) FROM mytable WHERE DivReachedDest BETWEEN -9999 AND -9999 AND \"Year\" < 2014 OR CRSElapsedTime >= 337 LIMIT 29","hsqls":["SELECT MIN(DivReachedDest), AVG(AirTime) FROM mytable WHERE DivReachedDest BETWEEN -9999 AND -9999 AND `Year` < 2014 OR CRSElapsedTime >= 337 LIMIT 29"]}
{"sql":"SELECT MIN(FlightNum), MAX(CRSDepTime), COUNT(DestState) FROM mytable WHERE Flights BETWEEN 1 AND 1 OR \"Month\" <> 1 AND DivReachedDest BETWEEN 0 AND 0 LIMIT 5","hsqls":["SELECT MIN(FlightNum), MAX(CRSDepTime), COUNT(DestState) FROM mytable WHERE Flights BETWEEN 1 AND 1 OR `Month` <> 1 AND DivReachedDest BETWEEN 0 AND 0 LIMIT 5"]}
{"sql":"SELECT MIN(Flights), SUM(CRSArrTime) FROM mytable WHERE FlightNum NOT IN (4484) AND DivAirportSeqIDs >= 1323202 AND DayOfWeek NOT IN (2, 1) LIMIT 14","hsqls":["SELECT MIN(Flights), SUM(CRSArrTime)  FROM mytable WHERE FlightNum NOT IN (4484) AND (DivAirportSeqIDs[1] >= 1323202 OR DivAirportSeqIDs[2] >= 1323202 OR DivAirportSeqIDs[3] >= 1323202 OR DivAirportSeqIDs[4] >= 1323202 OR DivAirportSeqIDs[5] >= 1323202) AND DayOfWeek NOT IN (2, 1) LIMIT 10000"]}
{"sql":"SELECT SUM(DepDel15), COUNT(AirTime) FROM mytable WHERE DivTailNums IN ('N3751B', 'N296WN', 'N416SW', 'N472WN') LIMIT 7","hsqls":["SELECT SUM(DepDel15), COUNT(AirTime) FROM mytable WHERE ARRAY_CONTAINS(DivTailNums, 'N3751B') OR ARRAY_CONTAINS(DivTailNums, 'N296WN') OR ARRAY_CONTAINS(DivTailNums, 'N416SW') OR ARRAY_CONTAINS(DivTailNums, 'N472WN') LIMIT 10000"]}
{"sql":"SELECT SUM(DivActualElapsedTime), COUNT(LateAircraftDelay), AVG(DivActualElapsedTime) FROM mytable WHERE DivTotalGTimes > 18 AND OriginCityMarketID IN (30721, 32389, 30781, 31076) OR DepDel15 BETWEEN -9999 AND 1 LIMIT 22","hsqls":["SELECT SUM(DivActualElapsedTime), COUNT(LateAircraftDelay), AVG(DivActualElapsedTime)  FROM mytable WHERE (DivTotalGTimes[1] > 18 OR DivTotalGTimes[2] > 18 OR DivTotalGTimes[3] > 18 OR DivTotalGTimes[4] > 18 OR DivTotalGTimes[5] > 18) AND OriginCityMarketID IN (30721, 32389, 30781, 31076) OR DepDel15 BETWEEN -9999 AND 1 LIMIT 10000"]}
{"sql":"SELECT SUM(DivActualElapsedTime), MAX(\"Month\") FROM mytable WHERE Distance <> 788 AND DivWheelsOffs > 1851 LIMIT 5","hsqls":["SELECT SUM(DivActualElapsedTime), MAX(`Month`)  FROM mytable WHERE Distance <> 788 AND (DivWheelsOffs[1] > 1851 OR DivWheelsOffs[2] > 1851 OR DivWheelsOffs[3] > 1851 OR DivWheelsOffs[4] > 1851 OR DivWheelsOffs[5] > 1851) LIMIT 10000"]}
{"sql":"SELECT SUM(DivArrDelay), SUM(DestStateFips) FROM mytable WHERE DivTailNums IN ('N3768', 'N438SW', 'N786SK', 'N636MQ', 'N3KXAA') AND DestAirportID < 11867 OR Carrier NOT IN ('DL', 'WN') LIMIT 20","hsqls":["SELECT SUM(DivArrDelay), SUM(DestStateFips)  FROM mytable WHERE (ARRAY_CONTAINS(DivTailNums, 'N3768') OR ARRAY_CONTAINS(DivTailNums, 'N438SW') OR ARRAY_CONTAINS(DivTailNums, 'N786SK') OR ARRAY_CONTAINS(DivTailNums, 'N636MQ') OR ARRAY_CONTAINS(DivTailNums, 'N3KXAA')) AND DestAirportID < 11867 OR Carrier NOT IN ('DL', 'WN') LIMIT 10000"]}
{"sql":"SELECT SUM(DivReachedDest), AVG(DestWac) FROM mytable WHERE DivWheelsOns BETWEEN 728 AND 1804 LIMIT 13","hsqls":["SELECT SUM(DivReachedDest), AVG(DestWac)  FROM mytable WHERE (DivWheelsOns[1] BETWEEN 728 AND 1804 OR DivWheelsOns[2] BETWEEN 728 AND 1804 OR DivWheelsOns[3] BETWEEN 728 AND 1804 OR DivWheelsOns[4] BETWEEN 728 AND 1804 OR DivWheelsOns[5] BETWEEN 728 AND 1804) LIMIT 10000"]}
{"sql":"SELECT SUM(WheelsOn), SUM(DivArrDelay), COUNT(DestState) FROM mytable WHERE DivAirports IN ('RFD') AND TaxiIn BETWEEN -9999 AND 94 LIMIT 29","hsqls":["SELECT SUM(WheelsOn), SUM(DivArrDelay), COUNT(DestState)  FROM mytable WHERE ARRAY_CONTAINS(DivAirports, 'RFD') AND TaxiIn BETWEEN -9999 AND 94 LIMIT 10000"]}
{"sql":"SELECT SUM(\"Month\") FROM mytable WHERE FirstDepTime <> 1742 AND DestStateName BETWEEN 'Maine' AND 'South Dakota' OR Carrier <= 'UA' LIMIT 23","hsqls":["SELECT SUM(`Month`) FROM mytable WHERE FirstDepTime <> 1742 AND DestStateName BETWEEN 'Maine' AND 'South Dakota' OR Carrier <= 'UA' LIMIT 23"]}
{"sql":"SELECT SUM(\"Year\"), MAX(DayofMonth), AVG(CRSArrTime) FROM mytable WHERE WheelsOff > 1737 AND DivTotalGTimes IN (30, 113, 102, 37) LIMIT 10","hsqls":["SELECT SUM(`Year`), MAX(DayofMonth), AVG(CRSArrTime)  FROM mytable WHERE WheelsOff > 1737 AND (ARRAY_CONTAINS(DivTotalGTimes, 30) OR ARRAY_CONTAINS(DivTotalGTimes, 113) OR ARRAY_CONTAINS(DivTotalGTimes, 102) OR ARRAY_CONTAINS(DivTotalGTimes, 37)) LIMIT 10000"]}

# Filtering & Grouping on Aggregation
{"sql":"SELECT ActualElapsedTime, AirTime, MIN(DistanceGroup), SUM(OriginAirportSeqID) FROM mytable WHERE ArrTime BETWEEN 2017 AND 2216 GROUP BY ActualElapsedTime, AirTime  ORDER BY ActualElapsedTime, AirTime LIMIT 14","hsqls":["SELECT ActualElapsedTime, AirTime, MIN(DistanceGroup), SUM(OriginAirportSeqID) FROM mytable WHERE ArrTime BETWEEN 2017 AND 2216 GROUP BY ActualElapsedTime, AirTime  ORDER BY ActualElapsedTime, AirTime LIMIT 14"]}
{"sql":"SELECT ArrivalDelayGroups, MIN(DepDel15), MAX(DestCityMarketID), COUNT(TailNum) FROM mytable WHERE DestAirportSeqID NOT IN (1114603, 1114002) GROUP BY ArrivalDelayGroups  ORDER BY ArrivalDelayGroups LIMIT 24","hsqls":["SELECT ArrivalDelayGroups, MIN(DepDel15), MAX(DestCityMarketID), COUNT(TailNum) FROM mytable WHERE DestAirportSeqID NOT IN (1114603, 1114002) GROUP BY ArrivalDelayGroups  ORDER BY ArrivalDelayGroups LIMIT 24"]}
{"sql":"SELECT CRSArrTime, SUM(DayofMonth), SUM(ArrTime) FROM mytable WHERE DaysSinceEpoch IN (16095, 16079) AND DivAirportLandings BETWEEN 1 AND 2 OR DestCityName <= 'Tucson, AZ' GROUP BY CRSArrTime  ORDER BY CRSArrTime LIMIT 22","hsqls":["SELECT CRSArrTime, SUM(DayofMonth), SUM(ArrTime) FROM mytable WHERE DaysSinceEpoch IN (16095, 16079) AND DivAirportLandings BETWEEN 1 AND 2 OR DestCityName <= 'Tucson, AZ' GROUP BY CRSArrTime  ORDER BY CRSArrTime LIMIT 22"]}
{"sql":"SELECT CRSElapsedTime, MAX(SecurityDelay), AVG(Diverted), COUNT(UniqueCarrier) FROM mytable WHERE DivArrDelay NOT IN (128, 199, 232, 626, 81) AND CancellationCode BETWEEN 'A' AND 'C' GROUP BY CRSElapsedTime  ORDER BY CRSElapsedTime LIMIT 1","hsqls":["SELECT CRSElapsedTime, MAX(SecurityDelay), AVG(Diverted), COUNT(UniqueCarrier) FROM mytable WHERE DivArrDelay NOT IN (128, 199, 232, 626, 81) AND CancellationCode BETWEEN 'A' AND 'C' GROUP BY CRSElapsedTime  ORDER BY CRSElapsedTime LIMIT 1"]}
{"sql":"SELECT Carrier, ArrTime, Origin, SUM(ArrDelay), MAX(DivReachedDest) FROM mytable WHERE Quarter IN (1) GROUP BY Carrier, ArrTime, Origin  ORDER BY Carrier, ArrTime, Origin LIMIT 10","hsqls":["SELECT Carrier, ArrTime, Origin, SUM(ArrDelay), MAX(DivReachedDest) FROM mytable WHERE Quarter IN (1) GROUP BY Carrier, ArrTime, Origin  ORDER BY Carrier, ArrTime, Origin LIMIT 10"]}
{"sql":"SELECT Carrier, FlightDate, DestCityName, COUNT(*) FROM mytable WHERE DepTimeBlk <= '0900-0959' GROUP BY Carrier, FlightDate, DestCityName  ORDER BY Carrier, FlightDate, DestCityName LIMIT 6","hsqls":["SELECT Carrier, FlightDate, DestCityName, COUNT(*) FROM mytable WHERE DepTimeBlk <= '0900-0959' GROUP BY Carrier, FlightDate, DestCityName  ORDER BY Carrier, FlightDate, DestCityName LIMIT 6"]}
{"sql":"SELECT DayofMonth, SUM(CRSArrTime), MIN(CRSElapsedTime) FROM mytable WHERE ArrDelay <> 364.0 GROUP BY DayofMonth  ORDER BY DayofMonth LIMIT 2","hsqls":["SELECT DayofMonth, SUM(CRSArrTime), MIN(CRSElapsedTime) FROM mytable WHERE ArrDelay <> 364.0 GROUP BY DayofMonth  ORDER BY DayofMonth LIMIT 2"]}
{"sql":"SELECT DaysSinceEpoch, COUNT(ArrivalDelayGroups), MAX(TaxiIn), MAX(CRSDepTime) FROM mytable WHERE ArrTimeBlk NOT IN ('2200-2259') GROUP BY DaysSinceEpoch  ORDER BY DaysSinceEpoch LIMIT 5","hsqls":["SELECT DaysSinceEpoch, COUNT(ArrivalDelayGroups), MAX(TaxiIn), MAX(CRSDepTime) FROM mytable WHERE ArrTimeBlk NOT IN ('2200-2259') GROUP BY DaysSinceEpoch  ORDER BY DaysSinceEpoch LIMIT 5"]}
{"sql":"SELECT DestStateName, SUM(LateAircraftDelay), AVG(TaxiIn) FROM mytable WHERE Distance IN (352, 805, 711, 325, 2105) OR ArrDelay BETWEEN 76.0 AND 46.0 GROUP BY DestStateName  ORDER BY DestStateName LIMIT 5","hsqls":["SELECT DestStateName, SUM(LateAircraftDelay), AVG(TaxiIn) FROM mytable WHERE Distance IN (352, 805, 711, 325, 2105) OR ArrDelay BETWEEN 76.0 AND 46.0 GROUP BY DestStateName  ORDER BY DestStateName LIMIT 5"]}
{"sql":"SELECT DestWac, Cancelled, AVG(DivReachedDest), AVG(DepDel15), MIN(ActualElapsedTime) FROM mytable WHERE OriginCityName <= 'Nashville, TN' AND DistanceGroup BETWEEN 1 AND 3 AND TotalAddGTime NOT IN (2, 55) GROUP BY DestWac, Cancelled  ORDER BY DestWac, Cancelled LIMIT 29","hsqls":["SELECT DestWac, Cancelled, AVG(DivReachedDest), AVG(DepDel15), MIN(ActualElapsedTime) FROM mytable WHERE OriginCityName <= 'Nashville, TN' AND DistanceGroup BETWEEN 1 AND 3 AND TotalAddGTime NOT IN (2, 55) GROUP BY DestWac, Cancelled  ORDER BY DestWac, Cancelled LIMIT 29"]}
{"sql":"SELECT DivActualElapsedTime, DayOfWeek, MIN(DestAirportID), COUNT(DivActualElapsedTime), COUNT(DivDistance) FROM mytable WHERE FlightDate IN ('2014-01-20', '2014-01-11', '2014-01-01', '2014-01-08') AND ActualElapsedTime BETWEEN 70 AND 245 AND Carrier <> 'DL' GROUP BY DivActualElapsedTime, DayOfWeek  ORDER BY DivActualElapsedTime, DayOfWeek LIMIT 19","hsqls":["SELECT DivActualElapsedTime, DayOfWeek, MIN(DestAirportID), COUNT(DivActualElapsedTime), COUNT(DivDistance) FROM mytable WHERE FlightDate IN ('2014-01-20', '2014-01-11', '2014-01-01', '2014-01-08') AND ActualElapsedTime BETWEEN 70 AND 245 AND Carrier <> 'DL' GROUP BY DivActualElapsedTime, DayOfWeek  ORDER BY DivActualElapsedTime, DayOfWeek LIMIT 19"]}
{"sql":"SELECT DivReachedDest, TaxiIn, SUM(ActualElapsedTime), AVG(ArrivalDelayGroups), MIN(WheelsOff) FROM mytable WHERE DivDistance BETWEEN 391 AND 95 OR ActualElapsedTime BETWEEN 239 AND 413 OR Diverted NOT IN (1, 0) GROUP BY DivReachedDest, TaxiIn  ORDER BY DivReachedDest, TaxiIn LIMIT 29","hsqls":["SELECT DivReachedDest, TaxiIn, SUM(ActualElapsedTime), AVG(ArrivalDelayGroups), MIN(WheelsOff) FROM mytable WHERE DivDistance BETWEEN 391 AND 95 OR ActualElapsedTime BETWEEN 239 AND 413 OR Diverted NOT IN (1, 0) GROUP BY DivReachedDest, TaxiIn  ORDER BY DivReachedDest, TaxiIn LIMIT 29"]}
{"sql":"SELECT Diverted, CRSArrTime, CancellationCode, MAX(DaysSinceEpoch), SUM(DayOfWeek), AVG(DivAirportLandings) FROM mytable WHERE ArrTimeBlk < '2300-2359' GROUP BY Diverted, CRSArrTime, CancellationCode  ORDER BY Diverted, CRSArrTime, CancellationCode LIMIT 20","hsqls":["SELECT Diverted, CRSArrTime, CancellationCode, MAX(DaysSinceEpoch), SUM(DayOfWeek), AVG(DivAirportLandings) FROM mytable WHERE ArrTimeBlk < '2300-2359' GROUP BY Diverted, CRSArrTime, CancellationCode  ORDER BY Diverted, CRSArrTime, CancellationCode LIMIT 20"]}
{"sql":"SELECT FirstDepTime, MIN(DivActualElapsedTime), MAX(DistanceGroup), MAX(ArrDelayMinutes) FROM mytable WHERE AirTime <= 200 OR Diverted > 1 OR CRSDepTime BETWEEN 612 AND 1653 GROUP BY FirstDepTime  ORDER BY FirstDepTime LIMIT 29","hsqls":["SELECT FirstDepTime, MIN(DivActualElapsedTime), MAX(DistanceGroup), MAX(ArrDelayMinutes) FROM mytable WHERE AirTime <= 200 OR Diverted > 1 OR CRSDepTime BETWEEN 612 AND 1653 GROUP BY FirstDepTime  ORDER BY FirstDepTime LIMIT 29"]}
{"sql":"SELECT FlightDate, ArrDelay, SUM(Diverted), SUM(FlightNum), MIN(OriginCityMarketID) FROM mytable WHERE OriginState BETWEEN 'NV' AND 'VI' GROUP BY FlightDate, ArrDelay  ORDER BY FlightDate, ArrDelay LIMIT 17","hsqls":["SELECT FlightDate, ArrDelay, SUM(Diverted), SUM(FlightNum), MIN(OriginCityMarketID) FROM mytable WHERE OriginState BETWEEN 'NV' AND 'VI' GROUP BY FlightDate, ArrDelay  ORDER BY FlightDate, ArrDelay LIMIT 17"]}
{"sql":"SELECT LongestAddGTime, ArrivalDelayGroups, OriginAirportID, COUNT(*) FROM mytable WHERE DivArrDelay <= 638 GROUP BY LongestAddGTime, ArrivalDelayGroups, OriginAirportID  ORDER BY LongestAddGTime, ArrivalDelayGroups, OriginAirportID LIMIT 7","hsqls":["SELECT LongestAddGTime, ArrivalDelayGroups, OriginAirportID, COUNT(*) FROM mytable WHERE DivArrDelay <= 638 GROUP BY LongestAddGTime, ArrivalDelayGroups, OriginAirportID  ORDER BY LongestAddGTime, ArrivalDelayGroups, OriginAirportID LIMIT 7"]}
{"sql":"SELECT LongestAddGTime, MAX(AirlineID), SUM(CRSArrTime), SUM(DivArrDelay) FROM mytable WHERE FirstDepTime BETWEEN 12 AND 617 OR LongestAddGTime <> 55 OR CRSArrTime <> 846 GROUP BY LongestAddGTime  ORDER BY LongestAddGTime LIMIT 28","hsqls":["SELECT LongestAddGTime, MAX(AirlineID), SUM(CRSArrTime), SUM(DivArrDelay) FROM mytable WHERE FirstDepTime BETWEEN 12 AND 617 OR LongestAddGTime <> 55 OR CRSArrTime <> 846 GROUP BY LongestAddGTime  ORDER BY LongestAddGTime LIMIT 28"]}
{"sql":"SELECT OriginCityMarketID, CRSElapsedTime, DaysSinceEpoch, SUM(CRSElapsedTime) FROM mytable WHERE Cancelled <= 1 OR ArrDelay NOT IN (245.0, 193.0, 450.0) AND Distance > 1156 GROUP BY OriginCityMarketID, CRSElapsedTime, DaysSinceEpoch  ORDER BY OriginCityMarketID, CRSElapsedTime, DaysSinceEpoch LIMIT 26","hsqls":["SELECT OriginCityMarketID, CRSElapsedTime, DaysSinceEpoch, SUM(CRSElapsedTime) FROM mytable WHERE Cancelled <= 1 OR ArrDelay NOT IN (245.0, 193.0, 450.0) AND Distance > 1156 GROUP BY OriginCityMarketID, CRSElapsedTime, DaysSinceEpoch  ORDER BY OriginCityMarketID, CRSElapsedTime, DaysSinceEpoch LIMIT 26"]}
{"sql":"SELECT OriginCityMarketID, OriginCityName, DepDel15, COUNT(ArrDel15) FROM mytable WHERE CRSDepTime <> 2034 AND ArrDelay NOT IN (-40.0, 132.0) GROUP BY OriginCityMarketID, OriginCityName, DepDel15  ORDER BY OriginCityMarketID, OriginCityName, DepDel15 LIMIT 6","hsqls":["SELECT OriginCityMarketID, OriginCityName, DepDel15, COUNT(ArrDel15) FROM mytable WHERE CRSDepTime <> 2034 AND ArrDelay NOT IN (-40.0, 132.0) GROUP BY OriginCityMarketID, OriginCityName, DepDel15  ORDER BY OriginCityMarketID, OriginCityName, DepDel15 LIMIT 6"]}
{"sql":"SELECT OriginCityMarketID, OriginCityName, DivArrDelay, MIN(OriginWac), SUM(DayOfWeek), COUNT(AirlineID) FROM mytable WHERE DepartureDelayGroups IN (10, 0, 5) AND FlightDate <> '2014-01-03' GROUP BY OriginCityMarketID, OriginCityName, DivArrDelay  ORDER BY OriginCityMarketID, OriginCityName, DivArrDelay LIMIT 6","hsqls":["SELECT OriginCityMarketID, OriginCityName, DivArrDelay, MIN(OriginWac), SUM(DayOfWeek), COUNT(AirlineID) FROM mytable WHERE DepartureDelayGroups IN (10, 0, 5) AND FlightDate <> '2014-01-03' GROUP BY OriginCityMarketID, OriginCityName, DivArrDelay  ORDER BY OriginCityMarketID, OriginCityName, DivArrDelay LIMIT 6"]}
{"sql":"SELECT OriginCityName, DepTime, UniqueCarrier, COUNT(*) FROM mytable WHERE ArrivalDelayGroups BETWEEN 5 AND 7 GROUP BY OriginCityName, DepTime, UniqueCarrier  ORDER BY OriginCityName, DepTime, UniqueCarrier LIMIT 19","hsqls":["SELECT OriginCityName, DepTime, UniqueCarrier, COUNT(*) FROM mytable WHERE ArrivalDelayGroups BETWEEN 5 AND 7 GROUP BY OriginCityName, DepTime, UniqueCarrier  ORDER BY OriginCityName, DepTime, UniqueCarrier LIMIT 19"]}
{"sql":"SELECT OriginCityName, MAX(TotalAddGTime), MIN(DistanceGroup) FROM mytable WHERE Dest NOT IN ('MSN') OR FirstDepTime <= 1859 OR Distance = 422 GROUP BY OriginCityName  ORDER BY OriginCityName LIMIT 1","hsqls":["SELECT OriginCityName, MAX(TotalAddGTime), MIN(DistanceGroup) FROM mytable WHERE Dest NOT IN ('MSN') OR FirstDepTime <= 1859 OR Distance = 422 GROUP BY OriginCityName  ORDER BY OriginCityName LIMIT 1"]}
{"sql":"SELECT TailNum, OriginWac, DayOfWeek, MAX(WheelsOff), SUM(CRSArrTime), MAX(TaxiIn) FROM mytable WHERE OriginWac NOT IN (45, 93, 23, 86) GROUP BY TailNum, OriginWac, DayOfWeek  ORDER BY TailNum, OriginWac, DayOfWeek LIMIT 28","hsqls":["SELECT TailNum, OriginWac, DayOfWeek, MAX(WheelsOff), SUM(CRSArrTime), MAX(TaxiIn) FROM mytable WHERE OriginWac NOT IN (45, 93, 23, 86) GROUP BY TailNum, OriginWac, DayOfWeek  ORDER BY TailNum, OriginWac, DayOfWeek LIMIT 28"]}
{"sql":"SELECT TaxiIn, MIN(DepartureDelayGroups), MAX(CRSDepTime) FROM mytable WHERE DestWac <> 82 AND DaysSinceEpoch BETWEEN 16087 AND 16099 OR ArrTime = 314 GROUP BY TaxiIn  ORDER BY TaxiIn LIMIT 29","hsqls":["SELECT TaxiIn, MIN(DepartureDelayGroups), MAX(CRSDepTime) FROM mytable WHERE DestWac <> 82 AND DaysSinceEpoch BETWEEN 16087 AND 16099 OR ArrTime = 314 GROUP BY TaxiIn  ORDER BY TaxiIn LIMIT 29"]}
{"sql":"SELECT TaxiOut, DayofMonth, COUNT(*) FROM mytable WHERE OriginCityMarketID < 30141 AND AirlineID BETWEEN 20398 AND 20437 GROUP BY TaxiOut, DayofMonth  ORDER BY TaxiOut, DayofMonth LIMIT 29","hsqls":["SELECT TaxiOut, DayofMonth, COUNT(*) FROM mytable WHERE OriginCityMarketID < 30141 AND AirlineID BETWEEN 20398 AND 20437 GROUP BY TaxiOut, DayofMonth  ORDER BY TaxiOut, DayofMonth LIMIT 29"]}
{"sql":"SELECT TotalAddGTime, DepDel15, Origin, COUNT(*) FROM mytable WHERE DistanceGroup BETWEEN 3 AND 10 OR FlightNum > 4146 OR DistanceGroup BETWEEN 7 AND 2 GROUP BY TotalAddGTime, DepDel15, Origin  ORDER BY TotalAddGTime, DepDel15, Origin LIMIT 12","hsqls":["SELECT TotalAddGTime, DepDel15, Origin, COUNT(*) FROM mytable WHERE DistanceGroup BETWEEN 3 AND 10 OR FlightNum > 4146 OR DistanceGroup BETWEEN 7 AND 2 GROUP BY TotalAddGTime, DepDel15, Origin  ORDER BY TotalAddGTime, DepDel15, Origin LIMIT 12"]}
{"sql":"SELECT UniqueCarrier, MIN(DepDelayMinutes), AVG(DestWac) FROM mytable WHERE UniqueCarrier BETWEEN 'OO' AND 'FL' OR SecurityDelay IN (0, 18) GROUP BY UniqueCarrier  ORDER BY UniqueCarrier LIMIT 17","hsqls":["SELECT UniqueCarrier, MIN(DepDelayMinutes), AVG(DestWac) FROM mytable WHERE UniqueCarrier BETWEEN 'OO' AND 'FL' OR SecurityDelay IN (0, 18) GROUP BY UniqueCarrier  ORDER BY UniqueCarrier LIMIT 17"]}
{"sql":"SELECT WeatherDelay, DivActualElapsedTime, MAX(LateAircraftDelay) FROM mytable WHERE CarrierDelay IN (3, 117, 59, 102, 11) OR Carrier >= 'DL' GROUP BY WeatherDelay, DivActualElapsedTime  ORDER BY WeatherDelay, DivActualElapsedTime LIMIT 11","hsqls":["SELECT WeatherDelay, DivActualElapsedTime, MAX(LateAircraftDelay) FROM mytable WHERE CarrierDelay IN (3, 117, 59, 102, 11) OR Carrier >= 'DL' GROUP BY WeatherDelay, DivActualElapsedTime  ORDER BY WeatherDelay, DivActualElapsedTime LIMIT 11"]}
{"sql":"SELECT WheelsOff, CRSArrTime, OriginCityMarketID, MAX(DestAirportSeqID), MIN(CRSElapsedTime), SUM(OriginAirportSeqID) FROM mytable WHERE DayOfWeek BETWEEN 2 AND 7 GROUP BY WheelsOff, CRSArrTime, OriginCityMarketID  ORDER BY WheelsOff, CRSArrTime, OriginCityMarketID LIMIT 8","hsqls":["SELECT WheelsOff, CRSArrTime, OriginCityMarketID, MAX(DestAirportSeqID), MIN(CRSElapsedTime), SUM(OriginAirportSeqID) FROM mytable WHERE DayOfWeek BETWEEN 2 AND 7 GROUP BY WheelsOff, CRSArrTime, OriginCityMarketID  ORDER BY WheelsOff, CRSArrTime, OriginCityMarketID LIMIT 8"]}
{"sql":"SELECT WheelsOn, MIN(OriginStateFips), AVG(DivArrDelay), MAX(ActualElapsedTime) FROM mytable WHERE DestStateName BETWEEN 'Alabama' AND 'Rhode Island' AND DayofMonth BETWEEN 24 AND 25 OR WheelsOn BETWEEN 1823 AND 1723 GROUP BY WheelsOn  ORDER BY WheelsOn LIMIT 29","hsqls":["SELECT WheelsOn, MIN(OriginStateFips), AVG(DivArrDelay), MAX(ActualElapsedTime) FROM mytable WHERE DestStateName BETWEEN 'Alabama' AND 'Rhode Island' AND DayofMonth BETWEEN 24 AND 25 OR WheelsOn BETWEEN 1823 AND 1723 GROUP BY WheelsOn  ORDER BY WheelsOn LIMIT 29"]}

# Selection & Order by
{"sql":"SELECT ActualElapsedTime, ActualElapsedTime, DestCityName FROM mytable ORDER BY ActualElapsedTime, DestCityName LIMIT 25"}
{"sql":"SELECT ActualElapsedTime, TaxiOut, SecurityDelay, DestCityMarketID FROM mytable WHERE \"Month\" IN (1) OR OriginStateName BETWEEN 'Connecticut' AND 'Pennsylvania' OR ArrTime < 2123 ORDER BY TaxiOut, SecurityDelay, DestCityMarketID LIMIT 11","hsqls":["SELECT ActualElapsedTime, TaxiOut, SecurityDelay, DestCityMarketID FROM mytable WHERE `Month` IN (1) OR OriginStateName BETWEEN 'Connecticut' AND 'Pennsylvania' OR ArrTime < 2123 ORDER BY TaxiOut, SecurityDelay, DestCityMarketID LIMIT 11"]}
{"sql":"SELECT AirTime, OriginWac, CRSElapsedTime FROM mytable WHERE TotalAddGTime <= 21 ORDER BY OriginWac, CRSElapsedTime LIMIT 16"}
{"sql":"SELECT AirlineID, OriginAirportSeqID, FlightDate FROM mytable WHERE WeatherDelay BETWEEN 234 AND 1 AND ArrDel15 BETWEEN -9999 AND 1 OR ArrivalDelayGroups > 7 ORDER BY OriginAirportSeqID, FlightDate LIMIT 28"}
{"sql":"SELECT ArrDelayMinutes, OriginStateFips, DayOfWeek FROM mytable WHERE AirlineID NOT IN (19393, 20437, 20409) AND FlightNum BETWEEN 5601 AND 6260 OR Diverted IN (1, 0) ORDER BY OriginStateFips, DayOfWeek LIMIT 22"}
{"sql":"SELECT CRSElapsedTime, DaysSinceEpoch, \"Year\", LateAircraftDelay FROM mytable WHERE DepartureDelayGroups IN (2, 5) ORDER BY \"Year\", LateAircraftDelay LIMIT 11","hsqls":["SELECT CRSElapsedTime, DaysSinceEpoch, `Year`, LateAircraftDelay FROM mytable WHERE DepartureDelayGroups IN (2, 5) ORDER BY `Year`, LateAircraftDelay LIMIT 11"]}
{"sql":"SELECT CarrierDelay, \"Year\", DestState, DaysSinceEpoch FROM mytable ORDER BY \"Year\", DestState, DaysSinceEpoch LIMIT 16","hsqls":["SELECT CarrierDelay, `Year`, DestState, DaysSinceEpoch FROM mytable ORDER BY `Year`, DestState, DaysSinceEpoch LIMIT 16"]}
{"sql":"SELECT DayOfWeek, DepartureDelayGroups, CRSArrTime FROM mytable WHERE Cancelled < 1 OR Origin = 'COD' AND OriginCityName NOT IN ('Dallas, TX') ORDER BY DepartureDelayGroups, CRSArrTime LIMIT 19"}
{"sql":"SELECT DaysSinceEpoch, Quarter FROM mytable WHERE Distance BETWEEN 919 AND 1623 OR OriginCityMarketID NOT IN (33851, 30713, 32511) OR CRSArrTime = 1000 ORDER BY Quarter LIMIT 7"}
{"sql":"SELECT DepDelay, TaxiIn, ArrivalDelayGroups FROM mytable WHERE ArrTimeBlk BETWEEN '1700-1759' AND '1800-1859' AND DestCityName BETWEEN 'Grand Rapids, MI' AND 'State College, PA' ORDER BY ArrivalDelayGroups LIMIT 4"}
{"sql":"SELECT DestWac, OriginCityName, ArrDel15, DepDel15, \"Month\" FROM mytable ORDER BY DestWac, DepDel15, \"Month\" LIMIT 14","hsqls":["SELECT DestWac, OriginCityName, ArrDel15, DepDel15, `Month` FROM mytable ORDER BY DestWac, DepDel15, `Month` LIMIT 14"]}
{"sql":"SELECT LateAircraftDelay, OriginStateFips, DayOfWeek, CRSArrTime, AirTime, DayofMonth FROM mytable WHERE DivDistance IN (68, 577) AND DestAirportID NOT IN (14100, 10792, 13487) ORDER BY CRSArrTime, AirTime, DayofMonth LIMIT 25"}
{"sql":"SELECT LongestAddGTime, DestCityMarketID FROM mytable WHERE TailNum IN ('N732US', 'N4YBAA', 'N349NW') AND DivActualElapsedTime NOT IN (368, 219, 218, 350) AND TaxiOut IN (93, 81) ORDER BY DestCityMarketID LIMIT 9"}
{"sql":"SELECT OriginAirportSeqID, \"Year\", Distance, ActualElapsedTime FROM mytable WHERE ArrDelayMinutes IN (122.0) ORDER BY Distance, ActualElapsedTime LIMIT 2","hsqls":["SELECT OriginAirportSeqID, `Year`, Distance, ActualElapsedTime FROM mytable WHERE ArrDelayMinutes IN (122.0) ORDER BY Distance, ActualElapsedTime LIMIT 2"]}
{"sql":"SELECT Quarter, DepDelayMinutes, DistanceGroup FROM mytable WHERE DepDelayMinutes < 26.0 OR TailNum < 'N439US' AND CancellationCode BETWEEN 'C' AND 'A' ORDER BY DistanceGroup LIMIT 15"}
{"sql":"SELECT TailNum, OriginCityName, Dest FROM mytable WHERE ActualElapsedTime BETWEEN 125 AND 299 AND OriginCityMarketID NOT IN (31884, 35991, 30073, 32335, 33264) AND DepDelayMinutes BETWEEN 338.0 AND 186.0 ORDER BY OriginCityName, Dest LIMIT 18"}
{"sql":"SELECT TaxiOut, Flights, OriginCityMarketID FROM mytable WHERE CRSDepTime NOT IN (2210, 716, 1510, 1153, 1517) AND ArrTimeBlk BETWEEN '1900-1959' AND '0700-0759' ORDER BY Flights, OriginCityMarketID LIMIT 25"}
{"sql":"SELECT TotalAddGTime, Flights FROM mytable WHERE DestStateFips NOT IN (48, 35, 22, 36, 39) AND CRSElapsedTime > 146 AND DivArrDelay BETWEEN 353 AND 328 ORDER BY Flights LIMIT 11"}
{"sql":"SELECT WeatherDelay, Cancelled, Dest, OriginAirportID FROM mytable WHERE AirTime <= 329 OR AirlineID < 20366 OR AirlineID BETWEEN 20304 AND 19805 ORDER BY OriginAirportID LIMIT 22"}
{"sql":"SELECT WheelsOff, TotalAddGTime, \"Month\", OriginState FROM mytable ORDER BY OriginState LIMIT 24","hsqls":["SELECT WheelsOff, TotalAddGTime, `Month`, OriginState FROM mytable ORDER BY OriginState LIMIT 24"]}
{"sql":"SELECT \"Year\", DepTime FROM mytable WHERE CRSArrTime BETWEEN 1237 AND 1534 AND Cancelled BETWEEN 0 AND 1 ORDER BY DepTime LIMIT 3","hsqls":["SELECT `Year`, DepTime FROM mytable WHERE CRSArrTime BETWEEN 1237 AND 1534 AND Cancelled BETWEEN 0 AND 1 ORDER BY DepTime LIMIT 3"]}

# Selection
{"sql":"SELECT DivDistance, ActualElapsedTime FROM mytable LIMIT 29"}
{"sql":"SELECT DayOfWeek FROM mytable WHERE TotalAddGTime IN (128, 148, 4, 34) LIMIT 8"}
{"sql":"SELECT WheelsOff FROM mytable WHERE DivDistance < 436 LIMIT 12"}
{"sql":"SELECT DivDistance, DepTime FROM mytable WHERE NASDelay IN (45, 55, 31, 9) LIMIT 26"}
{"sql":"SELECT DepDelay FROM mytable WHERE DepDelayMinutes BETWEEN 292.0 AND 237.0 AND DestState IN ('DE', 'AZ') LIMIT 18"}
{"sql":"SELECT DestStateFips FROM mytable LIMIT 27"}
