/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class UserTokenSettingsDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 15562;
  }

  // Properties.
  protected final PascalString name;
  protected final List<KeyValuePair> recordProperties;
  protected final UserTokenType tokenType;
  protected final PascalString issuedTokenType;
  protected final PascalString issuerEndpointUrl;
  protected final PascalString securityPolicyUri;
  protected final PascalString certificateGroupName;
  protected final PascalString authorizationServiceName;

  public UserTokenSettingsDataType(
      PascalString name,
      List<KeyValuePair> recordProperties,
      UserTokenType tokenType,
      PascalString issuedTokenType,
      PascalString issuerEndpointUrl,
      PascalString securityPolicyUri,
      PascalString certificateGroupName,
      PascalString authorizationServiceName) {
    super();
    this.name = name;
    this.recordProperties = recordProperties;
    this.tokenType = tokenType;
    this.issuedTokenType = issuedTokenType;
    this.issuerEndpointUrl = issuerEndpointUrl;
    this.securityPolicyUri = securityPolicyUri;
    this.certificateGroupName = certificateGroupName;
    this.authorizationServiceName = authorizationServiceName;
  }

  public PascalString getName() {
    return name;
  }

  public List<KeyValuePair> getRecordProperties() {
    return recordProperties;
  }

  public UserTokenType getTokenType() {
    return tokenType;
  }

  public PascalString getIssuedTokenType() {
    return issuedTokenType;
  }

  public PascalString getIssuerEndpointUrl() {
    return issuerEndpointUrl;
  }

  public PascalString getSecurityPolicyUri() {
    return securityPolicyUri;
  }

  public PascalString getCertificateGroupName() {
    return certificateGroupName;
  }

  public PascalString getAuthorizationServiceName() {
    return authorizationServiceName;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("UserTokenSettingsDataType");

    // Simple Field (name)
    writeSimpleField("name", name, writeComplex(writeBuffer));

    // Implicit Field (noOfRecordProperties) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfRecordProperties =
        (int) ((((getRecordProperties()) == (null)) ? -(1) : COUNT(getRecordProperties())));
    writeImplicitField(
        "noOfRecordProperties", noOfRecordProperties, writeSignedInt(writeBuffer, 32));

    // Array Field (recordProperties)
    writeComplexTypeArrayField("recordProperties", recordProperties, writeBuffer);

    // Simple Field (tokenType)
    writeSimpleEnumField(
        "tokenType",
        "UserTokenType",
        tokenType,
        writeEnum(
            UserTokenType::getValue, UserTokenType::name, writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (issuedTokenType)
    writeSimpleField("issuedTokenType", issuedTokenType, writeComplex(writeBuffer));

    // Simple Field (issuerEndpointUrl)
    writeSimpleField("issuerEndpointUrl", issuerEndpointUrl, writeComplex(writeBuffer));

    // Simple Field (securityPolicyUri)
    writeSimpleField("securityPolicyUri", securityPolicyUri, writeComplex(writeBuffer));

    // Simple Field (certificateGroupName)
    writeSimpleField("certificateGroupName", certificateGroupName, writeComplex(writeBuffer));

    // Simple Field (authorizationServiceName)
    writeSimpleField(
        "authorizationServiceName", authorizationServiceName, writeComplex(writeBuffer));

    writeBuffer.popContext("UserTokenSettingsDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    UserTokenSettingsDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (name)
    lengthInBits += name.getLengthInBits();

    // Implicit Field (noOfRecordProperties)
    lengthInBits += 32;

    // Array field
    if (recordProperties != null) {
      int i = 0;
      for (KeyValuePair element : recordProperties) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= recordProperties.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (tokenType)
    lengthInBits += 32;

    // Simple field (issuedTokenType)
    lengthInBits += issuedTokenType.getLengthInBits();

    // Simple field (issuerEndpointUrl)
    lengthInBits += issuerEndpointUrl.getLengthInBits();

    // Simple field (securityPolicyUri)
    lengthInBits += securityPolicyUri.getLengthInBits();

    // Simple field (certificateGroupName)
    lengthInBits += certificateGroupName.getLengthInBits();

    // Simple field (authorizationServiceName)
    lengthInBits += authorizationServiceName.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("UserTokenSettingsDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString name =
        readSimpleField(
            "name", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfRecordProperties =
        readImplicitField("noOfRecordProperties", readSignedInt(readBuffer, 32));

    List<KeyValuePair> recordProperties =
        readCountArrayField(
            "recordProperties",
            readComplex(
                () ->
                    (KeyValuePair) ExtensionObjectDefinition.staticParse(readBuffer, (int) (14535)),
                readBuffer),
            noOfRecordProperties);

    UserTokenType tokenType =
        readEnumField(
            "tokenType",
            "UserTokenType",
            readEnum(UserTokenType::enumForValue, readUnsignedLong(readBuffer, 32)));

    PascalString issuedTokenType =
        readSimpleField(
            "issuedTokenType", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString issuerEndpointUrl =
        readSimpleField(
            "issuerEndpointUrl",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString securityPolicyUri =
        readSimpleField(
            "securityPolicyUri",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString certificateGroupName =
        readSimpleField(
            "certificateGroupName",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString authorizationServiceName =
        readSimpleField(
            "authorizationServiceName",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("UserTokenSettingsDataType");
    // Create the instance
    return new UserTokenSettingsDataTypeBuilderImpl(
        name,
        recordProperties,
        tokenType,
        issuedTokenType,
        issuerEndpointUrl,
        securityPolicyUri,
        certificateGroupName,
        authorizationServiceName);
  }

  public static class UserTokenSettingsDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString name;
    private final List<KeyValuePair> recordProperties;
    private final UserTokenType tokenType;
    private final PascalString issuedTokenType;
    private final PascalString issuerEndpointUrl;
    private final PascalString securityPolicyUri;
    private final PascalString certificateGroupName;
    private final PascalString authorizationServiceName;

    public UserTokenSettingsDataTypeBuilderImpl(
        PascalString name,
        List<KeyValuePair> recordProperties,
        UserTokenType tokenType,
        PascalString issuedTokenType,
        PascalString issuerEndpointUrl,
        PascalString securityPolicyUri,
        PascalString certificateGroupName,
        PascalString authorizationServiceName) {
      this.name = name;
      this.recordProperties = recordProperties;
      this.tokenType = tokenType;
      this.issuedTokenType = issuedTokenType;
      this.issuerEndpointUrl = issuerEndpointUrl;
      this.securityPolicyUri = securityPolicyUri;
      this.certificateGroupName = certificateGroupName;
      this.authorizationServiceName = authorizationServiceName;
    }

    public UserTokenSettingsDataType build() {
      UserTokenSettingsDataType userTokenSettingsDataType =
          new UserTokenSettingsDataType(
              name,
              recordProperties,
              tokenType,
              issuedTokenType,
              issuerEndpointUrl,
              securityPolicyUri,
              certificateGroupName,
              authorizationServiceName);
      return userTokenSettingsDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof UserTokenSettingsDataType)) {
      return false;
    }
    UserTokenSettingsDataType that = (UserTokenSettingsDataType) o;
    return (getName() == that.getName())
        && (getRecordProperties() == that.getRecordProperties())
        && (getTokenType() == that.getTokenType())
        && (getIssuedTokenType() == that.getIssuedTokenType())
        && (getIssuerEndpointUrl() == that.getIssuerEndpointUrl())
        && (getSecurityPolicyUri() == that.getSecurityPolicyUri())
        && (getCertificateGroupName() == that.getCertificateGroupName())
        && (getAuthorizationServiceName() == that.getAuthorizationServiceName())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getName(),
        getRecordProperties(),
        getTokenType(),
        getIssuedTokenType(),
        getIssuerEndpointUrl(),
        getSecurityPolicyUri(),
        getCertificateGroupName(),
        getAuthorizationServiceName());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
