/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.admin.Bookies;
import org.apache.pulsar.client.admin.BrokerStats;
import org.apache.pulsar.client.admin.Brokers;
import org.apache.pulsar.client.admin.Clusters;
import org.apache.pulsar.client.admin.Functions;
import org.apache.pulsar.client.admin.Lookup;
import org.apache.pulsar.client.admin.Namespaces;
import org.apache.pulsar.client.admin.NonPersistentTopics;
import org.apache.pulsar.client.admin.Packages;
import org.apache.pulsar.client.admin.Properties;
import org.apache.pulsar.client.admin.ProxyStats;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.ResourceGroups;
import org.apache.pulsar.client.admin.ResourceQuotas;
import org.apache.pulsar.client.admin.Schemas;
import org.apache.pulsar.client.admin.Sink;
import org.apache.pulsar.client.admin.Sinks;
import org.apache.pulsar.client.admin.Source;
import org.apache.pulsar.client.admin.Sources;
import org.apache.pulsar.client.admin.Tenants;
import org.apache.pulsar.client.admin.TopicPolicies;
import org.apache.pulsar.client.admin.Topics;
import org.apache.pulsar.client.admin.Transactions;
import org.apache.pulsar.client.admin.Worker;
import org.apache.pulsar.client.admin.internal.BookiesImpl;
import org.apache.pulsar.client.admin.internal.BrokerStatsImpl;
import org.apache.pulsar.client.admin.internal.BrokersImpl;
import org.apache.pulsar.client.admin.internal.ClustersImpl;
import org.apache.pulsar.client.admin.internal.FunctionsImpl;
import org.apache.pulsar.client.admin.internal.JacksonConfigurator;
import org.apache.pulsar.client.admin.internal.LookupImpl;
import org.apache.pulsar.client.admin.internal.NamespacesImpl;
import org.apache.pulsar.client.admin.internal.NonPersistentTopicsImpl;
import org.apache.pulsar.client.admin.internal.PackagesImpl;
import org.apache.pulsar.client.admin.internal.ProxyStatsImpl;
import org.apache.pulsar.client.admin.internal.ResourceGroupsImpl;
import org.apache.pulsar.client.admin.internal.ResourceQuotasImpl;
import org.apache.pulsar.client.admin.internal.SchemasImpl;
import org.apache.pulsar.client.admin.internal.SinksImpl;
import org.apache.pulsar.client.admin.internal.SourcesImpl;
import org.apache.pulsar.client.admin.internal.TenantsImpl;
import org.apache.pulsar.client.admin.internal.TopicPoliciesImpl;
import org.apache.pulsar.client.admin.internal.TopicsImpl;
import org.apache.pulsar.client.admin.internal.TransactionsImpl;
import org.apache.pulsar.client.admin.internal.WorkerImpl;
import org.apache.pulsar.client.admin.internal.http.AsyncHttpConnector;
import org.apache.pulsar.client.admin.internal.http.AsyncHttpConnectorProvider;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.PulsarClientSharedResourcesImpl;
import org.apache.pulsar.client.impl.auth.AuthenticationDisabled;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.common.net.ServiceURI;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarAdminImpl
implements PulsarAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarAdmin.class);
    public static final int DEFAULT_REQUEST_TIMEOUT_SECONDS = 300;
    private final Clusters clusters;
    private final Brokers brokers;
    private final BrokerStats brokerStats;
    private final ProxyStats proxyStats;
    private final Tenants tenants;
    private final ResourceGroups resourcegroups;
    private final Properties properties;
    private final Namespaces namespaces;
    private final Bookies bookies;
    private final TopicsImpl topics;
    private final TopicPolicies localTopicPolicies;
    private final TopicPolicies globalTopicPolicies;
    private final NonPersistentTopics nonPersistentTopics;
    private final ResourceQuotas resourceQuotas;
    private final ClientConfigurationData clientConfigData;
    private final Client client;
    private final AsyncHttpConnector asyncHttpConnector;
    private final String serviceUrl;
    private final Lookup lookups;
    private final Functions functions;
    private final Sources sources;
    private final Sinks sinks;
    private final Worker worker;
    private final Schemas schemas;
    private final Packages packages;
    private final Transactions transactions;
    protected final WebTarget root;
    protected final Authentication auth;

    public PulsarAdminImpl(String serviceUrl, ClientConfigurationData clientConfigData, ClassLoader clientBuilderClassLoader) throws PulsarClientException {
        this(serviceUrl, clientConfigData, clientBuilderClassLoader, true, null);
    }

    public PulsarAdminImpl(String serviceUrl, ClientConfigurationData clientConfigData, ClassLoader clientBuilderClassLoader, boolean acceptGzipCompression, PulsarClientSharedResourcesImpl sharedResources) throws PulsarClientException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)serviceUrl), (Object)"Service URL needs to be specified");
        this.clientConfigData = clientConfigData;
        this.auth = clientConfigData != null ? clientConfigData.getAuthentication() : new AuthenticationDisabled();
        LOG.debug("created: serviceUrl={}, authMethodName={}", (Object)serviceUrl, (Object)this.auth.getAuthMethodName());
        this.auth.start();
        if (clientConfigData != null && StringUtils.isBlank((CharSequence)clientConfigData.getServiceUrl())) {
            clientConfigData.setServiceUrl(serviceUrl);
        }
        AsyncHttpConnectorProvider asyncConnectorProvider = new AsyncHttpConnectorProvider(clientConfigData, clientConfigData.getAutoCertRefreshSeconds(), acceptGzipCompression);
        ClientConfig httpConfig = new ClientConfig();
        httpConfig.property("jersey.config.client.followRedirects", (Object)true);
        httpConfig.property("jersey.config.client.async.threadPoolSize", (Object)8);
        httpConfig.register(MultiPartFeature.class);
        httpConfig.connectorProvider((ConnectorProvider)asyncConnectorProvider);
        ClassLoader originalCtxLoader = null;
        if (clientBuilderClassLoader != null) {
            originalCtxLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(clientBuilderClassLoader);
        }
        ClientBuilder clientBuilder = (ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().withConfig((Configuration)httpConfig).connectTimeout((long)this.clientConfigData.getConnectionTimeoutMs(), TimeUnit.MILLISECONDS).readTimeout((long)this.clientConfigData.getReadTimeoutMs(), TimeUnit.MILLISECONDS).register(JacksonConfigurator.class)).register(JacksonFeature.class);
        boolean useTls = clientConfigData.getServiceUrl().startsWith("https://");
        this.client = clientBuilder.build();
        this.serviceUrl = serviceUrl;
        ServiceURI serviceUri = ServiceURI.create((String)serviceUrl);
        this.root = this.client.target(serviceUri.selectOne());
        this.asyncHttpConnector = asyncConnectorProvider.getConnector(Math.toIntExact(clientConfigData.getConnectionTimeoutMs()), Math.toIntExact(clientConfigData.getReadTimeoutMs()), Math.toIntExact(clientConfigData.getRequestTimeoutMs()), clientConfigData.getAutoCertRefreshSeconds(), sharedResources);
        long requestTimeoutMs = clientConfigData.getRequestTimeoutMs();
        this.clusters = new ClustersImpl(this.root, this.auth, requestTimeoutMs);
        this.brokers = new BrokersImpl(this.root, this.auth, requestTimeoutMs);
        this.brokerStats = new BrokerStatsImpl(this.root, this.auth, requestTimeoutMs);
        this.proxyStats = new ProxyStatsImpl(this.root, this.auth, requestTimeoutMs);
        this.tenants = new TenantsImpl(this.root, this.auth, requestTimeoutMs);
        this.resourcegroups = new ResourceGroupsImpl(this.root, this.auth, requestTimeoutMs);
        this.properties = new TenantsImpl(this.root, this.auth, requestTimeoutMs);
        this.namespaces = new NamespacesImpl(this.root, this.auth, requestTimeoutMs);
        this.topics = new TopicsImpl(this.root, this.auth, requestTimeoutMs);
        this.localTopicPolicies = new TopicPoliciesImpl(this.root, this.auth, requestTimeoutMs, false);
        this.globalTopicPolicies = new TopicPoliciesImpl(this.root, this.auth, requestTimeoutMs, true);
        this.nonPersistentTopics = new NonPersistentTopicsImpl(this.root, this.auth, requestTimeoutMs);
        this.resourceQuotas = new ResourceQuotasImpl(this.root, this.auth, requestTimeoutMs);
        this.lookups = new LookupImpl(this.root, this.auth, useTls, requestTimeoutMs, this.topics);
        this.functions = new FunctionsImpl(this.root, this.auth, this.asyncHttpConnector, requestTimeoutMs);
        this.sources = new SourcesImpl(this.root, this.auth, this.asyncHttpConnector, requestTimeoutMs);
        this.sinks = new SinksImpl(this.root, this.auth, this.asyncHttpConnector, requestTimeoutMs);
        this.worker = new WorkerImpl(this.root, this.auth, requestTimeoutMs);
        this.schemas = new SchemasImpl(this.root, this.auth, requestTimeoutMs);
        this.bookies = new BookiesImpl(this.root, this.auth, requestTimeoutMs);
        this.packages = new PackagesImpl(this.root, this.auth, this.asyncHttpConnector, requestTimeoutMs);
        this.transactions = new TransactionsImpl(this.root, this.auth, requestTimeoutMs);
        if (originalCtxLoader != null) {
            Thread.currentThread().setContextClassLoader(originalCtxLoader);
        }
    }

    @Deprecated
    public PulsarAdminImpl(URL serviceUrl, Authentication auth) throws PulsarClientException {
        this(serviceUrl.toString(), PulsarAdminImpl.getConfigData(auth), null);
    }

    private static ClientConfigurationData getConfigData(Authentication auth) {
        ClientConfigurationData conf = new ClientConfigurationData();
        conf.setAuthentication(auth);
        return conf;
    }

    @Deprecated
    public PulsarAdminImpl(URL serviceUrl, String authPluginClassName, String authParamsString) throws PulsarClientException {
        this(serviceUrl, AuthenticationFactory.create((String)authPluginClassName, (String)authParamsString));
    }

    @Deprecated
    public PulsarAdminImpl(URL serviceUrl, String authPluginClassName, Map<String, String> authParams) throws PulsarClientException {
        this(serviceUrl, AuthenticationFactory.create((String)authPluginClassName, authParams));
    }

    public Clusters clusters() {
        return this.clusters;
    }

    public Brokers brokers() {
        return this.brokers;
    }

    public Tenants tenants() {
        return this.tenants;
    }

    public ResourceGroups resourcegroups() {
        return this.resourcegroups;
    }

    @Deprecated
    public Properties properties() {
        return this.properties;
    }

    public Namespaces namespaces() {
        return this.namespaces;
    }

    public Topics topics() {
        return this.topics;
    }

    public TopicPolicies topicPolicies() {
        return this.localTopicPolicies;
    }

    public TopicPolicies topicPolicies(boolean isGlobal) {
        return isGlobal ? this.globalTopicPolicies : this.localTopicPolicies;
    }

    public Bookies bookies() {
        return this.bookies;
    }

    @Deprecated
    public NonPersistentTopics nonPersistentTopics() {
        return this.nonPersistentTopics;
    }

    public ResourceQuotas resourceQuotas() {
        return this.resourceQuotas;
    }

    public Lookup lookups() {
        return this.lookups;
    }

    public Functions functions() {
        return this.functions;
    }

    @Deprecated
    public Source source() {
        return (Source)this.sources;
    }

    public Sources sources() {
        return this.sources;
    }

    @Deprecated
    public Sink sink() {
        return (Sink)this.sinks;
    }

    public Sinks sinks() {
        return this.sinks;
    }

    public Worker worker() {
        return this.worker;
    }

    public BrokerStats brokerStats() {
        return this.brokerStats;
    }

    public ProxyStats proxyStats() {
        return this.proxyStats;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public ClientConfigurationData getClientConfigData() {
        return this.clientConfigData;
    }

    public Schemas schemas() {
        return this.schemas;
    }

    public Packages packages() {
        return this.packages;
    }

    public Transactions transactions() {
        return this.transactions;
    }

    public void close() {
        try {
            this.auth.close();
        }
        catch (IOException e) {
            LOG.error("Failed to close the authentication service", (Throwable)e);
        }
        this.client.close();
        this.asyncHttpConnector.close();
    }

    @Generated
    public AsyncHttpConnector getAsyncHttpConnector() {
        return this.asyncHttpConnector;
    }
}

