/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.AbstractUnresolvedObject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectFactory;
import org.apache.qpid.server.model.ConfiguredObjectTypeRegistry;
import org.apache.qpid.server.plugin.ConfiguredObjectTypeFactory;
import org.apache.qpid.server.store.ConfiguredObjectDependency;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.UnresolvedConfiguredObject;

public abstract class AbstractConfiguredObjectTypeFactory<X extends AbstractConfiguredObject<X>>
implements ConfiguredObjectTypeFactory<X> {
    private final Class<X> _clazz;

    public AbstractConfiguredObjectTypeFactory(Class<X> clazz) {
        this._clazz = clazz;
    }

    @Override
    public final String getType() {
        return ConfiguredObjectTypeRegistry.getType(this._clazz);
    }

    @Override
    public final Class<? super X> getCategoryClass() {
        return ConfiguredObjectTypeRegistry.getCategory(this._clazz);
    }

    @Override
    public X create(ConfiguredObjectFactory factory, Map<String, Object> attributes, ConfiguredObject<?> parent) {
        X instance = this.createInstance(attributes, parent);
        ((AbstractConfiguredObject)instance).create();
        return instance;
    }

    @Override
    public CompletableFuture<X> createAsync(ConfiguredObjectFactory factory, Map<String, Object> attributes, ConfiguredObject<?> parent) {
        CompletableFuture returnVal = new CompletableFuture();
        Object instance = this.createInstance(attributes, parent);
        CompletableFuture<Void> createFuture = ((AbstractConfiguredObject)instance).createAsync();
        createFuture.whenComplete((result, throwable) -> {
            if (throwable != null) {
                returnVal.completeExceptionally((Throwable)throwable);
            } else {
                returnVal.complete(instance);
            }
        });
        return returnVal;
    }

    protected abstract X createInstance(Map<String, Object> var1, ConfiguredObject<?> var2);

    @Override
    public UnresolvedConfiguredObject<X> recover(ConfiguredObjectFactory factory, ConfiguredObjectRecord record, ConfiguredObject<?> parent) {
        return new GenericUnresolvedConfiguredObject(record, parent);
    }

    private class GenericUnresolvedConfiguredObject
    extends AbstractUnresolvedObject<X> {
        public GenericUnresolvedConfiguredObject(ConfiguredObjectRecord record, ConfiguredObject<?> parent) {
            super(AbstractConfiguredObjectTypeFactory.this._clazz, record, parent);
        }

        @Override
        protected <C extends ConfiguredObject<C>> void resolved(ConfiguredObjectDependency<C> dependency, C value) {
        }

        @Override
        public X resolve() {
            HashMap<String, Object> attributesWithId = new HashMap<String, Object>(this.getRecord().getAttributes());
            attributesWithId.put("id", this.getRecord().getId());
            Object instance = AbstractConfiguredObjectTypeFactory.this.createInstance(attributesWithId, this.getParent());
            ((AbstractConfiguredObject)instance).registerWithParents();
            return instance;
        }
    }
}

