/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.security.AccessControlContext;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.subjects.ChannelLogSubject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.protocol.PublishAuthorisationCache;
import org.apache.qpid.server.protocol.v0_10.AMQPConnection_0_10;
import org.apache.qpid.server.protocol.v0_10.ConsumerTarget_0_10;
import org.apache.qpid.server.protocol.v0_10.ServerSession;
import org.apache.qpid.server.protocol.v0_10.Session;
import org.apache.qpid.server.session.AMQPSession;
import org.apache.qpid.server.session.AbstractAMQPSession;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.Deletable;

public class Session_0_10
extends AbstractAMQPSession<Session_0_10, ConsumerTarget_0_10>
implements LogSubject,
Deletable<Session_0_10>,
Session<Session_0_10> {
    private final AMQPConnection_0_10 _connection;
    private final ServerSession _serverSession;
    private final String _peerSessionName;

    protected Session_0_10(Connection<?> parent, int sessionId, ServerSession serverSession, String peerSessionName) {
        super(parent, sessionId, (LogSubject)new ChannelLogSubject((AMQPConnection)((AMQPConnection_0_10)parent), (Object)String.format("%d:%s", sessionId, peerSessionName)));
        this._peerSessionName = peerSessionName;
        this._connection = (AMQPConnection_0_10)parent;
        this._serverSession = serverSession;
    }

    public String toLogString() {
        return this.getLogSubject().toLogString();
    }

    public void block(Queue<?> queue) {
        this._serverSession.block(queue);
    }

    public void unblock(Queue<?> queue) {
        this._serverSession.unblock(queue);
    }

    public void block() {
        this._serverSession.block();
    }

    public void unblock() {
        this._serverSession.unblock();
    }

    public Object getConnectionReference() {
        return this._serverSession.getConnectionReference();
    }

    public void transportStateChanged() {
        for (ConsumerTarget_0_10 consumerTarget : this._serverSession.getSubscriptions()) {
            consumerTarget.transportStateChanged();
        }
        if (!this._consumersWithPendingWork.isEmpty() && !this.getAMQPConnection().isTransportBlockedForWriting()) {
            this.getAMQPConnection().notifyWork((AMQPSession)this);
        }
    }

    protected void updateBlockedStateIfNecessary() {
        this._serverSession.updateBlockedStateIfNecesssary();
    }

    public boolean getBlocking() {
        return this._serverSession.getBlocking();
    }

    public int getUnacknowledgedMessageCount() {
        return this._serverSession.getUnacknowledgedMessageCount();
    }

    public long getTransactionUpdateTimeLong() {
        return this._serverSession.getTransactionUpdateTimeLong();
    }

    public long getTransactionStartTimeLong() {
        return this._serverSession.getTransactionStartTimeLong();
    }

    public AMQPConnection_0_10 getConnection() {
        return this._connection;
    }

    public Subject getSubject() {
        return this._subject;
    }

    AccessControlContext getAccessControllerContext() {
        return this._accessControllerContext;
    }

    PublishAuthorisationCache getPublishAuthCache() {
        return this._publishAuthCache;
    }

    List<Action<? super Session_0_10>> getTaskList() {
        return this._taskList;
    }

    public boolean isClosing() {
        return this._serverSession.isClosing();
    }

    ServerSession getServerSession() {
        return this._serverSession;
    }

    @Override
    public String getPeerSessionName() {
        return this._peerSessionName;
    }
}

