/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.bean;

import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.SettableAnyProperty;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.util.TokenBuffer;

public abstract class PropertyValue {
    public final PropertyValue next;
    public final Object value;

    protected PropertyValue(PropertyValue next, Object value) {
        this.next = next;
        this.value = value;
    }

    public abstract void assign(DeserializationContext var1, Object var2) throws JacksonException;

    public void setValue(DeserializationContext ctxt, Object parameterObject) throws JacksonException {
        throw new UnsupportedOperationException("Should not be called on type: " + this.getClass().getName());
    }

    static final class Merging
    extends PropertyValue {
        final SettableBeanProperty _property;

        public Merging(PropertyValue next, TokenBuffer buffered, SettableBeanProperty prop) {
            super(next, (Object)buffered);
            this._property = prop;
        }

        @Override
        public void assign(DeserializationContext ctxt, Object bean) {
            TokenBuffer buffered = (TokenBuffer)((Object)this.value);
            try (JsonParser p = buffered.asParser();){
                p.nextToken();
                this._property.deserializeAndSet(p, ctxt, bean);
            }
        }
    }

    static final class AnyParameter
    extends PropertyValue {
        final SettableAnyProperty _property;
        final String _propertyName;

        public AnyParameter(PropertyValue next, Object value, SettableAnyProperty prop, String propName) {
            super(next, value);
            this._property = prop;
            this._propertyName = propName;
        }

        @Override
        public void assign(DeserializationContext ctxt, Object bean) throws JacksonException {
        }

        @Override
        public void setValue(DeserializationContext ctxt, Object parameterObject) throws JacksonException {
            this._property.set(ctxt, parameterObject, this._propertyName, this.value);
        }
    }

    static final class Map
    extends PropertyValue {
        final Object _key;

        public Map(PropertyValue next, Object value, Object key) {
            super(next, value);
            this._key = key;
        }

        @Override
        public void assign(DeserializationContext ctxt, Object bean) throws JacksonException {
            ((java.util.Map)bean).put(this._key, this.value);
        }
    }

    static final class Any
    extends PropertyValue {
        final SettableAnyProperty _property;
        final String _propertyName;

        public Any(PropertyValue next, Object value, SettableAnyProperty prop, String propName) {
            super(next, value);
            this._property = prop;
            this._propertyName = propName;
        }

        @Override
        public void assign(DeserializationContext ctxt, Object bean) throws JacksonException {
            this._property.set(ctxt, bean, this._propertyName, this.value);
        }
    }

    static final class Regular
    extends PropertyValue {
        final SettableBeanProperty _property;

        public Regular(PropertyValue next, Object value, SettableBeanProperty prop) {
            super(next, value);
            this._property = prop;
        }

        @Override
        public void assign(DeserializationContext ctxt, Object bean) throws JacksonException {
            this._property.set(ctxt, bean, this.value);
        }
    }
}

