/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.qpid.server.logging.LogMessage;
import org.slf4j.LoggerFactory;

public class MessageStoreMessages {
    private static final ResourceBundle MESSAGES;
    private static final Locale CURRENT_LOCALE;
    public static final String MESSAGESTORE_LOG_HIERARCHY = "qpid.message.messagestore";
    public static final String CLOSED_LOG_HIERARCHY = "qpid.message.messagestore.closed";
    public static final String CREATED_LOG_HIERARCHY = "qpid.message.messagestore.created";
    public static final String OVERFULL_LOG_HIERARCHY = "qpid.message.messagestore.overfull";
    public static final String RECOVERED_LOG_HIERARCHY = "qpid.message.messagestore.recovered";
    public static final String RECOVERY_COMPLETE_LOG_HIERARCHY = "qpid.message.messagestore.recovery_complete";
    public static final String RECOVERY_START_LOG_HIERARCHY = "qpid.message.messagestore.recovery_start";
    public static final String STORE_LOCATION_LOG_HIERARCHY = "qpid.message.messagestore.store_location";
    public static final String UNDERFULL_LOG_HIERARCHY = "qpid.message.messagestore.underfull";

    public static LogMessage CLOSED() {
        String rawMessage;
        final String message = rawMessage = MESSAGES.getString("CLOSED");
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return MessageStoreMessages.CLOSED_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage CREATED() {
        String rawMessage;
        final String message = rawMessage = MESSAGES.getString("CREATED");
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return MessageStoreMessages.CREATED_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage OVERFULL() {
        String rawMessage;
        final String message = rawMessage = MESSAGES.getString("OVERFULL");
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return MessageStoreMessages.OVERFULL_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage RECOVERED(Number param1) {
        String rawMessage = MESSAGES.getString("RECOVERED");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return MessageStoreMessages.RECOVERED_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage RECOVERY_COMPLETE() {
        String rawMessage;
        final String message = rawMessage = MESSAGES.getString("RECOVERY_COMPLETE");
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return MessageStoreMessages.RECOVERY_COMPLETE_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage RECOVERY_START() {
        String rawMessage;
        final String message = rawMessage = MESSAGES.getString("RECOVERY_START");
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return MessageStoreMessages.RECOVERY_START_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage STORE_LOCATION(CharSequence param1) {
        String rawMessage = MESSAGES.getString("STORE_LOCATION");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return MessageStoreMessages.STORE_LOCATION_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage UNDERFULL() {
        String rawMessage;
        final String message = rawMessage = MESSAGES.getString("UNDERFULL");
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return MessageStoreMessages.UNDERFULL_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    private MessageStoreMessages() {
    }

    static {
        Locale locale = Locale.US;
        String localeSetting = System.getProperty("qpid.broker_locale");
        if (localeSetting != null) {
            String[] localeParts = localeSetting.split("_");
            String language = localeParts.length > 0 ? localeParts[0] : "";
            String country = localeParts.length > 1 ? localeParts[1] : "";
            String variant = "";
            if (localeParts.length > 2) {
                variant = localeSetting.substring(language.length() + 1 + country.length() + 1);
            }
            locale = new Locale(language, country, variant);
        }
        CURRENT_LOCALE = locale;
        LoggerFactory.getLogger((String)MESSAGESTORE_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)CLOSED_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)CREATED_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)OVERFULL_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)RECOVERED_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)RECOVERY_COMPLETE_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)RECOVERY_START_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)STORE_LOCATION_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)UNDERFULL_LOG_HIERARCHY);
        MESSAGES = ResourceBundle.getBundle("org.apache.qpid.server.logging.messages.MessageStore_logmessages", CURRENT_LOCALE);
    }
}

