/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.hdfs.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.hdfs.client.HdfsClient;
import org.apache.ranger.services.hdfs.client.HdfsConnectionMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsResourceMgr {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsResourceMgr.class);
    public static final String PATH = "path";

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) throws Exception {
        Map<String, Object> ret = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HdfsResourceMgr.connectionTest ServiceName: " + serviceName + "Configs" + configs);
        }
        try {
            ret = HdfsClient.connectionTest(serviceName, configs);
        }
        catch (HadoopException e) {
            LOG.error("<== HdfsResourceMgr.testConnection Error: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HdfsResourceMgr.connectionTest Result : " + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getHdfsResources(String serviceName, String serviceType, Map<String, String> configs, ResourceLookupContext context) throws Exception {
        List resultList;
        block18: {
            resultList = null;
            String userInput = context.getUserInput();
            String resource = context.getResourceName();
            Map resourceMap = context.getResources();
            final ArrayList<String> pathList = new ArrayList<String>();
            if (resource != null && resourceMap != null && resourceMap.get(PATH) != null) {
                for (String path : (List)resourceMap.get(PATH)) {
                    pathList.add(path);
                }
            }
            if (serviceName != null && userInput != null) {
                try {
                    String wildCardToMatch;
                    HdfsClient hdfsClient;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("<== HdfsResourceMgr.getHdfsResources() UserInput: " + userInput + "configs: " + configs + "context: " + context);
                    }
                    if ((hdfsClient = new HdfsConnectionMgr().getHadoopConnection(serviceName, serviceType, configs)) == null) break block18;
                    Integer lastIndex = userInput.lastIndexOf("/");
                    if (lastIndex < 0) {
                        wildCardToMatch = userInput + "*";
                        userInput = "/";
                    } else if (lastIndex == 0 && userInput.length() == 1) {
                        wildCardToMatch = null;
                        userInput = "/";
                    } else if (lastIndex + 1 == userInput.length()) {
                        wildCardToMatch = null;
                        userInput = userInput.substring(0, lastIndex + 1);
                    } else {
                        wildCardToMatch = userInput.substring(lastIndex + 1) + "*";
                        userInput = userInput.substring(0, lastIndex + 1);
                    }
                    final String finalBaseDir = userInput;
                    final String finalWildCardToMatch = wildCardToMatch;
                    Callable<List<String>> callableObj = new Callable<List<String>>(){

                        @Override
                        public List<String> call() throws Exception {
                            return hdfsClient.listFiles(finalBaseDir, finalWildCardToMatch, pathList);
                        }
                    };
                    if (callableObj != null) {
                        HdfsClient hdfsClient2 = hdfsClient;
                        synchronized (hdfsClient2) {
                            resultList = (List)TimedEventUtil.timedTask((Callable)callableObj, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Resource dir : " + userInput + " wild card to match : " + wildCardToMatch + "\n Matching resources : " + resultList);
                    }
                }
                catch (HadoopException e) {
                    LOG.error("Unable to get hdfs resources.", (Throwable)e);
                    throw e;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HdfsResourceMgr.getHdfsResources() Result : " + resultList);
        }
        return resultList;
    }
}

