/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.source.atlas;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.tagsync.source.atlas.AtlasResourceMapper;
import org.apache.ranger.tagsync.source.atlasrest.RangerAtlasEntity;

public class AtlasHiveResourceMapper
extends AtlasResourceMapper {
    public static final String ENTITY_TYPE_HIVE_DB = "hive_db";
    public static final String ENTITY_TYPE_HIVE_TABLE = "hive_table";
    public static final String ENTITY_TYPE_HIVE_COLUMN = "hive_column";
    public static final String RANGER_TYPE_HIVE_DB = "database";
    public static final String RANGER_TYPE_HIVE_TABLE = "table";
    public static final String RANGER_TYPE_HIVE_COLUMN = "column";
    public static final String[] SUPPORTED_ENTITY_TYPES = new String[]{"hive_db", "hive_table", "hive_column"};

    public AtlasHiveResourceMapper() {
        super("hive", SUPPORTED_ENTITY_TYPES);
    }

    @Override
    public RangerServiceResource buildResource(RangerAtlasEntity entity) throws Exception {
        String clusterName;
        String qualifiedName = (String)entity.getAttributes().get("qualifiedName");
        if (StringUtils.isEmpty((String)qualifiedName)) {
            throw new Exception("attribute 'qualifiedName' not found in entity");
        }
        String resourceStr = this.getResourceNameFromQualifiedName(qualifiedName);
        if (StringUtils.isEmpty((String)resourceStr)) {
            this.throwExceptionWithMessage("resource not found in attribute 'qualifiedName': " + qualifiedName);
        }
        if (StringUtils.isEmpty((String)(clusterName = this.getClusterNameFromQualifiedName(qualifiedName)))) {
            this.throwExceptionWithMessage("cluster-name not found in attribute 'qualifiedName': " + qualifiedName);
        }
        String entityType = entity.getTypeName();
        String entityGuid = entity.getGuid();
        String serviceName = this.getRangerServiceName(clusterName);
        String[] resources = resourceStr.split("\\.");
        String dbName = resources.length > 0 ? resources[0] : null;
        String tblName = resources.length > 1 ? resources[1] : null;
        String colName = resources.length > 2 ? resources[2] : null;
        HashMap<String, RangerPolicy.RangerPolicyResource> elements = new HashMap<String, RangerPolicy.RangerPolicyResource>();
        if (StringUtils.equals((String)entityType, (String)ENTITY_TYPE_HIVE_DB)) {
            if (StringUtils.isNotEmpty((String)dbName)) {
                elements.put(RANGER_TYPE_HIVE_DB, new RangerPolicy.RangerPolicyResource(dbName));
            }
        } else if (StringUtils.equals((String)entityType, (String)ENTITY_TYPE_HIVE_TABLE)) {
            if (StringUtils.isNotEmpty((String)dbName) && StringUtils.isNotEmpty((String)tblName)) {
                elements.put(RANGER_TYPE_HIVE_DB, new RangerPolicy.RangerPolicyResource(dbName));
                elements.put(RANGER_TYPE_HIVE_TABLE, new RangerPolicy.RangerPolicyResource(tblName));
            }
        } else if (StringUtils.equals((String)entityType, (String)ENTITY_TYPE_HIVE_COLUMN)) {
            if (StringUtils.isNotEmpty((String)dbName) && StringUtils.isNotEmpty((String)tblName) && StringUtils.isNotEmpty((String)colName)) {
                elements.put(RANGER_TYPE_HIVE_DB, new RangerPolicy.RangerPolicyResource(dbName));
                elements.put(RANGER_TYPE_HIVE_TABLE, new RangerPolicy.RangerPolicyResource(tblName));
                elements.put(RANGER_TYPE_HIVE_COLUMN, new RangerPolicy.RangerPolicyResource(colName));
            }
        } else {
            this.throwExceptionWithMessage("unrecognized entity-type: " + entityType);
        }
        if (elements.isEmpty()) {
            this.throwExceptionWithMessage("invalid qualifiedName for entity-type '" + entityType + "': " + qualifiedName);
        }
        RangerServiceResource ret = new RangerServiceResource(entityGuid, serviceName, elements);
        return ret;
    }
}

