/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.search.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupPagedList;
import com.microsoft.azure.management.search.AdminKeyKind;
import com.microsoft.azure.management.search.AdminKeys;
import com.microsoft.azure.management.search.CheckNameAvailabilityResult;
import com.microsoft.azure.management.search.QueryKey;
import com.microsoft.azure.management.search.SearchService;
import com.microsoft.azure.management.search.SearchServices;
import com.microsoft.azure.management.search.implementation.AdminKeyResultInner;
import com.microsoft.azure.management.search.implementation.AdminKeysImpl;
import com.microsoft.azure.management.search.implementation.CheckNameAvailabilityOutputInner;
import com.microsoft.azure.management.search.implementation.CheckNameAvailabilityResultImpl;
import com.microsoft.azure.management.search.implementation.QueryKeyImpl;
import com.microsoft.azure.management.search.implementation.QueryKeyInner;
import com.microsoft.azure.management.search.implementation.SearchManagementClientImpl;
import com.microsoft.azure.management.search.implementation.SearchServiceImpl;
import com.microsoft.azure.management.search.implementation.SearchServiceInner;
import com.microsoft.azure.management.search.implementation.SearchServiceManager;
import com.microsoft.azure.management.search.implementation.ServicesInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class SearchServicesImpl
extends GroupableResourcesImpl<SearchService, SearchServiceImpl, SearchServiceInner, ServicesInner, SearchServiceManager>
implements SearchServices {
    SearchServicesImpl(SearchServiceManager searchServiceManager) {
        super((Object)((SearchManagementClientImpl)((Object)searchServiceManager.inner())).services(), (ManagerBase)searchServiceManager);
    }

    public PagedList<SearchService> list() {
        final SearchServicesImpl self = this;
        return new GroupPagedList<SearchService>(((SearchServiceManager)this.manager()).resourceManager().resourceGroups().list()){

            public List<SearchService> listNextGroup(String resourceGroupName) {
                return SearchServicesImpl.this.wrapList(((ServicesInner)self.inner()).listByResourceGroup(resourceGroupName));
            }
        };
    }

    public Observable<SearchService> listAsync() {
        return ((SearchServiceManager)this.manager()).resourceManager().resourceGroups().listAsync().flatMap((Func1)new Func1<ResourceGroup, Observable<SearchService>>(){

            public Observable<SearchService> call(ResourceGroup resourceGroup) {
                return SearchServicesImpl.this.wrapListAsync(((ServicesInner)SearchServicesImpl.this.inner()).listByResourceGroupAsync(resourceGroup.name()));
            }
        });
    }

    public PagedList<SearchService> listByResourceGroup(String groupName) {
        return this.wrapList(((ServicesInner)this.inner()).listByResourceGroup(groupName));
    }

    public Observable<SearchService> listByResourceGroupAsync(String resourceGroupName) {
        return this.wrapListAsync(((ServicesInner)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }

    protected Observable<SearchServiceInner> getInnerAsync(String resourceGroupName, String name) {
        return ((ServicesInner)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    public SearchServiceImpl define(String name) {
        return this.wrapModel(name);
    }

    protected Completable deleteInnerAsync(String groupName, String name) {
        return ((ServicesInner)this.inner()).deleteAsync(groupName, name).toCompletable();
    }

    protected SearchServiceImpl wrapModel(String name) {
        SearchServiceInner inner = new SearchServiceInner();
        return new SearchServiceImpl(name, inner, (SearchServiceManager)super.manager());
    }

    protected SearchServiceImpl wrapModel(SearchServiceInner inner) {
        if (inner == null) {
            return null;
        }
        return new SearchServiceImpl(inner.name(), inner, (SearchServiceManager)this.manager());
    }

    @Override
    public CheckNameAvailabilityResult checkNameAvailability(String name) {
        return (CheckNameAvailabilityResult)this.checkNameAvailabilityAsync(name).toBlocking().last();
    }

    @Override
    public Observable<CheckNameAvailabilityResult> checkNameAvailabilityAsync(String name) {
        return ((ServicesInner)this.inner()).checkNameAvailabilityAsync(name).map((Func1)new Func1<CheckNameAvailabilityOutputInner, CheckNameAvailabilityResult>(){

            public CheckNameAvailabilityResult call(CheckNameAvailabilityOutputInner checkNameAvailabilityOutputInner) {
                return new CheckNameAvailabilityResultImpl(checkNameAvailabilityOutputInner);
            }
        });
    }

    @Override
    public ServiceFuture<CheckNameAvailabilityResult> checkNameAvailabilityAsync(String name, ServiceCallback<CheckNameAvailabilityResult> callback) {
        return ServiceFuture.fromBody(this.checkNameAvailabilityAsync(name), callback);
    }

    @Override
    public AdminKeys getAdminKeys(String resourceGroupName, String searchServiceName) {
        return new AdminKeysImpl(((SearchManagementClientImpl)((Object)((SearchServiceManager)this.manager()).inner())).adminKeys().get(resourceGroupName, searchServiceName));
    }

    @Override
    public Observable<AdminKeys> getAdminKeysAsync(String resourceGroupName, String searchServiceName) {
        return ((SearchManagementClientImpl)((Object)((SearchServiceManager)this.manager()).inner())).adminKeys().getAsync(resourceGroupName, searchServiceName).map((Func1)new Func1<AdminKeyResultInner, AdminKeys>(){

            public AdminKeys call(AdminKeyResultInner adminKeyResultInner) {
                return new AdminKeysImpl(adminKeyResultInner);
            }
        });
    }

    @Override
    public List<QueryKey> listQueryKeys(String resourceGroupName, String searchServiceName) {
        ArrayList<QueryKeyImpl> queryKeys = new ArrayList<QueryKeyImpl>();
        List<QueryKeyInner> queryKeyInners = ((SearchManagementClientImpl)((Object)((SearchServiceManager)this.manager()).inner())).queryKeys().listBySearchService(resourceGroupName, searchServiceName);
        if (queryKeyInners != null) {
            for (QueryKeyInner queryKeyInner : queryKeyInners) {
                queryKeys.add(new QueryKeyImpl(queryKeyInner));
            }
        }
        return Collections.unmodifiableList(queryKeys);
    }

    @Override
    public Observable<QueryKey> listQueryKeysAsync(String resourceGroupName, String searchServiceName) {
        Observable<List<QueryKeyInner>> queryKeysList = ((SearchManagementClientImpl)((Object)((SearchServiceManager)this.manager()).inner())).queryKeys().listBySearchServiceAsync(resourceGroupName, searchServiceName);
        return queryKeysList.flatMap((Func1)new Func1<List<QueryKeyInner>, Observable<QueryKeyInner>>(){

            public Observable<QueryKeyInner> call(List<QueryKeyInner> queryKeyInners) {
                return Observable.from(queryKeyInners);
            }
        }).map((Func1)new Func1<QueryKeyInner, QueryKey>(){

            public QueryKey call(QueryKeyInner queryKeyInner) {
                return new QueryKeyImpl(queryKeyInner);
            }
        });
    }

    @Override
    public AdminKeys regenerateAdminKeys(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind) {
        return new AdminKeysImpl(((SearchManagementClientImpl)((Object)((SearchServiceManager)this.manager()).inner())).adminKeys().regenerate(resourceGroupName, searchServiceName, keyKind));
    }

    @Override
    public Observable<AdminKeys> regenerateAdminKeysAsync(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind) {
        return ((SearchManagementClientImpl)((Object)((SearchServiceManager)this.manager()).inner())).adminKeys().regenerateAsync(resourceGroupName, searchServiceName, keyKind).map((Func1)new Func1<AdminKeyResultInner, AdminKeys>(){

            public AdminKeys call(AdminKeyResultInner adminKeyResultInner) {
                return new AdminKeysImpl(adminKeyResultInner);
            }
        });
    }

    @Override
    public QueryKey createQueryKey(String resourceGroupName, String searchServiceName, String name) {
        return new QueryKeyImpl(((SearchManagementClientImpl)((Object)((SearchServiceManager)this.manager()).inner())).queryKeys().create(resourceGroupName, searchServiceName, name));
    }

    @Override
    public Observable<QueryKey> createQueryKeyAsync(String resourceGroupName, String searchServiceName, String name) {
        return ((SearchManagementClientImpl)((Object)((SearchServiceManager)this.manager()).inner())).queryKeys().createAsync(resourceGroupName, searchServiceName, name).map((Func1)new Func1<QueryKeyInner, QueryKey>(){

            public QueryKey call(QueryKeyInner queryKeyInner) {
                return new QueryKeyImpl(queryKeyInner);
            }
        });
    }

    @Override
    public void deleteQueryKey(String resourceGroupName, String searchServiceName, String key) {
        ((SearchManagementClientImpl)((Object)((SearchServiceManager)this.manager()).inner())).queryKeys().delete(resourceGroupName, searchServiceName, key);
    }

    @Override
    public Completable deleteQueryKeyAsync(String resourceGroupName, String searchServiceName, String key) {
        return ((SearchManagementClientImpl)((Object)((SearchServiceManager)this.manager()).inner())).queryKeys().deleteAsync(resourceGroupName, searchServiceName, key).toCompletable();
    }
}

