/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.metamodel.MappedSuperclassType;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.metamodel.AttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.IdentifiableTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;

public class MappedSuperclassTypeImpl<X>
extends IdentifiableTypeImpl<X>
implements MappedSuperclassType<X> {
    private static final long serialVersionUID = 3770722221322920646L;
    private Map<Class, IdentifiableTypeImpl> inheritingIdentifiableTypes = new HashMap<Class, IdentifiableTypeImpl>();

    protected MappedSuperclassTypeImpl(MetamodelImpl metamodel, ClassDescriptor relationalDescriptor) {
        super(metamodel, relationalDescriptor);
    }

    protected void addInheritingType(IdentifiableTypeImpl identifiableType) {
        this.inheritingIdentifiableTypes.put(identifiableType.getJavaType(), identifiableType);
    }

    protected static MappedSuperclassTypeImpl<?> create(MetamodelImpl metamodel, ClassDescriptor relationalDescriptor) {
        MappedSuperclassTypeImpl mappedSuperclassTypeImpl = new MappedSuperclassTypeImpl(metamodel, relationalDescriptor);
        return mappedSuperclassTypeImpl;
    }

    public AttributeImpl getMemberFromInheritingType(String name) {
        AttributeImpl inheritedAttribute = null;
        for (IdentifiableTypeImpl inheritingType : this.inheritingIdentifiableTypes.values()) {
            Map inheritingTypeMembers = inheritingType.getMembers();
            if (inheritingTypeMembers == null && inheritingType.isMappedSuperclass()) {
                inheritingType.initialize();
                inheritingTypeMembers = inheritingType.getMembers();
            }
            if (inheritingTypeMembers == null || !inheritingTypeMembers.containsKey(name)) continue;
            inheritedAttribute = (AttributeImpl)inheritingType.getAttribute(name);
            break;
        }
        return inheritedAttribute;
    }

    @Override
    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.MAPPED_SUPERCLASS;
    }

    @Override
    protected void initialize() {
        this.descriptor.convertClassNamesToClasses(this.metamodel.getSession().getDatasourcePlatform().getConversionManager().getLoader());
        super.initialize();
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public boolean isMappedSuperclass() {
        return !this.isEntity();
    }
}

