/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider.hdfs;

import java.util.Map;
import java.util.Properties;
import org.apache.ranger.audit.provider.BufferedAuditProvider;
import org.apache.ranger.audit.provider.DebugTracer;
import org.apache.ranger.audit.provider.LocalFileLogBuffer;
import org.apache.ranger.audit.provider.Log4jTracer;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.provider.hdfs.HdfsLogDestination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsAuditProvider
extends BufferedAuditProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsAuditProvider.class);

    public void init(Properties props) {
        LOG.info("HdfsAuditProvider.init()");
        super.init(props);
        Map hdfsProps = MiscUtil.getPropertiesWithPrefix((Properties)props, (String)"xasecure.audit.hdfs.config.");
        String encoding = (String)hdfsProps.get("encoding");
        String hdfsDestinationDirectory = (String)hdfsProps.get("destination.directory");
        String hdfsDestinationFile = (String)hdfsProps.get("destination.file");
        int hdfsDestinationFlushIntervalSeconds = MiscUtil.parseInteger((String)((String)hdfsProps.get("destination.flush.interval.seconds")), (int)900);
        int hdfsDestinationRolloverIntervalSeconds = MiscUtil.parseInteger((String)((String)hdfsProps.get("destination.rollover.interval.seconds")), (int)86400);
        int hdfsDestinationOpenRetryIntervalSeconds = MiscUtil.parseInteger((String)((String)hdfsProps.get("destination.open.retry.interval.seconds")), (int)60);
        String localFileBufferDirectory = (String)hdfsProps.get("local.buffer.directory");
        String localFileBufferFile = (String)hdfsProps.get("local.buffer.file");
        int localFileBufferFlushIntervalSeconds = MiscUtil.parseInteger((String)((String)hdfsProps.get("local.buffer.flush.interval.seconds")), (int)60);
        int localFileBufferFileBufferSizeBytes = MiscUtil.parseInteger((String)((String)hdfsProps.get("local.buffer.file.buffer.size.bytes")), (int)8192);
        int localFileBufferRolloverIntervalSeconds = MiscUtil.parseInteger((String)((String)hdfsProps.get("local.buffer.rollover.interval.seconds")), (int)600);
        String localFileBufferArchiveDirectory = (String)hdfsProps.get("local.archive.directory");
        int localFileBufferArchiveFileCount = MiscUtil.parseInteger((String)((String)hdfsProps.get("local.archive.max.file.count")), (int)10);
        Map configProps = MiscUtil.getPropertiesWithPrefix((Properties)props, (String)"xasecure.audit.destination.hdfs.config.");
        Log4jTracer tracer = new Log4jTracer(LOG);
        HdfsLogDestination mHdfsDestination = new HdfsLogDestination((DebugTracer)tracer);
        mHdfsDestination.setDirectory(hdfsDestinationDirectory);
        mHdfsDestination.setFile(hdfsDestinationFile);
        mHdfsDestination.setFlushIntervalSeconds(hdfsDestinationFlushIntervalSeconds);
        mHdfsDestination.setEncoding(encoding);
        mHdfsDestination.setRolloverIntervalSeconds(hdfsDestinationRolloverIntervalSeconds);
        mHdfsDestination.setOpenRetryIntervalSeconds(hdfsDestinationOpenRetryIntervalSeconds);
        mHdfsDestination.setConfigProps(configProps);
        LocalFileLogBuffer mLocalFileBuffer = new LocalFileLogBuffer((DebugTracer)tracer);
        mLocalFileBuffer.setDirectory(localFileBufferDirectory);
        mLocalFileBuffer.setFile(localFileBufferFile);
        mLocalFileBuffer.setFlushIntervalSeconds(localFileBufferFlushIntervalSeconds);
        mLocalFileBuffer.setFileBufferSizeBytes(localFileBufferFileBufferSizeBytes);
        mLocalFileBuffer.setEncoding(encoding);
        mLocalFileBuffer.setRolloverIntervalSeconds(localFileBufferRolloverIntervalSeconds);
        mLocalFileBuffer.setArchiveDirectory(localFileBufferArchiveDirectory);
        mLocalFileBuffer.setArchiveFileCount(localFileBufferArchiveFileCount);
        this.setBufferAndDestination(mLocalFileBuffer, mHdfsDestination);
    }
}

