/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.ssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.ssl.KeyStoresFactory;
import org.apache.hadoop.hdds.security.ssl.ReloadingX509KeyManager;
import org.apache.hadoop.hdds.security.ssl.ReloadingX509TrustManager;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class PemFileBasedKeyStoresFactory
implements KeyStoresFactory,
CertificateNotification {
    private static final Logger LOG = LoggerFactory.getLogger(PemFileBasedKeyStoresFactory.class);
    public static final String DEFAULT_KEYSTORE_TYPE = "jks";
    private KeyManager[] keyManagers;
    private TrustManager[] trustManagers;
    private final CertificateClient caClient;

    public PemFileBasedKeyStoresFactory(SecurityConfig securityConfig, CertificateClient client) {
        this.caClient = client;
    }

    private void createTrustManagers() throws GeneralSecurityException, IOException {
        ReloadingX509TrustManager trustManager = new ReloadingX509TrustManager(DEFAULT_KEYSTORE_TYPE, this.caClient);
        this.trustManagers = new TrustManager[]{trustManager};
    }

    private void createKeyManagers() throws GeneralSecurityException, IOException {
        ReloadingX509KeyManager keystoreManager = new ReloadingX509KeyManager(DEFAULT_KEYSTORE_TYPE, this.caClient);
        this.keyManagers = new KeyManager[]{keystoreManager};
    }

    @Override
    public synchronized void init(KeyStoresFactory.Mode mode, boolean requireClientAuth) throws IOException, GeneralSecurityException {
        if (requireClientAuth || mode == KeyStoresFactory.Mode.SERVER) {
            this.createKeyManagers();
        } else {
            KeyStore keystore = KeyStore.getInstance(DEFAULT_KEYSTORE_TYPE);
            keystore.load(null, null);
            KeyManagerFactory keyMgrFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyMgrFactory.init(keystore, null);
            this.keyManagers = keyMgrFactory.getKeyManagers();
        }
        this.createTrustManagers();
        this.caClient.registerNotificationReceiver(this);
    }

    @Override
    public synchronized void destroy() {
        if (this.keyManagers != null) {
            this.keyManagers = null;
        }
        if (this.trustManagers != null) {
            this.trustManagers = null;
        }
    }

    @Override
    public synchronized KeyManager[] getKeyManagers() {
        KeyManager[] copy = new KeyManager[this.keyManagers.length];
        System.arraycopy(this.keyManagers, 0, copy, 0, this.keyManagers.length);
        return copy;
    }

    @Override
    public synchronized TrustManager[] getTrustManagers() {
        TrustManager[] copy = new TrustManager[this.trustManagers.length];
        System.arraycopy(this.trustManagers, 0, copy, 0, this.trustManagers.length);
        return copy;
    }

    @Override
    public synchronized void notifyCertificateRenewed(CertificateClient certClient, String oldCertId, String newCertId) {
        LOG.info("{} notify certificate renewed", (Object)certClient.getComponentName());
        if (this.keyManagers != null) {
            for (KeyManager km : this.keyManagers) {
                if (!(km instanceof ReloadingX509KeyManager)) continue;
                ((ReloadingX509KeyManager)km).loadFrom(certClient);
            }
        }
        if (this.trustManagers != null) {
            for (TrustManager tm : this.trustManagers) {
                if (!(tm instanceof ReloadingX509TrustManager)) continue;
                ((ReloadingX509TrustManager)tm).loadFrom(certClient);
            }
        }
    }
}

