/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;

public class BatchOperation {
    private List<SingleOperation> operations = Lists.newArrayList();

    public void put(byte[] key, byte[] value) {
        this.operations.add(new SingleOperation(Operation.PUT, key, value));
    }

    public void delete(byte[] key) {
        this.operations.add(new SingleOperation(Operation.DELETE, key, null));
    }

    public List<SingleOperation> getOperations() {
        return this.operations;
    }

    static class SingleOperation {
        private final Operation opt;
        private final byte[] key;
        private final byte[] value;

        SingleOperation(Operation opt, byte[] key, byte[] value) {
            this.opt = opt;
            this.key = Objects.requireNonNull(key, "key cannot be null");
            this.value = value;
        }

        public Operation getOpt() {
            return this.opt;
        }

        public byte[] getKey() {
            return this.key;
        }

        public byte[] getValue() {
            return this.value;
        }
    }

    public static enum Operation {
        DELETE,
        PUT;

    }
}

