/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.okhttp.v3_0;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.jdbc.;
import io.trino.jdbc.$internal.okhttp3.Request;
import io.trino.jdbc.$internal.okhttp3.Response;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesExtractorBuilder;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractorBuilder;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.okhttp.v3_0.OkHttpTelemetry;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.okhttp.v3_0.internal.OkHttpInstrumenterFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class OkHttpTelemetryBuilder {
    private final OpenTelemetry openTelemetry;
    private final List<.AttributesExtractor<Request, Response>> additionalExtractors = new ArrayList<.AttributesExtractor<Request, Response>>();
    private Consumer<HttpClientAttributesExtractorBuilder<Request, Response>> extractorConfigurer = builder -> {};
    private Consumer<HttpSpanNameExtractorBuilder<Request>> spanNameExtractorConfigurer = builder -> {};
    private boolean emitExperimentalHttpClientMetrics = false;

    OkHttpTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public OkHttpTelemetryBuilder addAttributesExtractor(.AttributesExtractor<Request, Response> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public OkHttpTelemetryBuilder setCapturedRequestHeaders(List<String> requestHeaders) {
        this.extractorConfigurer = this.extractorConfigurer.andThen(builder -> builder.setCapturedRequestHeaders(requestHeaders));
        return this;
    }

    @CanIgnoreReturnValue
    public OkHttpTelemetryBuilder setCapturedResponseHeaders(List<String> responseHeaders) {
        this.extractorConfigurer = this.extractorConfigurer.andThen(builder -> builder.setCapturedResponseHeaders(responseHeaders));
        return this;
    }

    @CanIgnoreReturnValue
    public OkHttpTelemetryBuilder setKnownMethods(Set<String> knownMethods) {
        this.extractorConfigurer = this.extractorConfigurer.andThen(builder -> builder.setKnownMethods(knownMethods));
        this.spanNameExtractorConfigurer = this.spanNameExtractorConfigurer.andThen(builder -> builder.setKnownMethods(knownMethods));
        return this;
    }

    @CanIgnoreReturnValue
    public OkHttpTelemetryBuilder setEmitExperimentalHttpClientMetrics(boolean emitExperimentalHttpClientMetrics) {
        this.emitExperimentalHttpClientMetrics = emitExperimentalHttpClientMetrics;
        return this;
    }

    public OkHttpTelemetry build() {
        return new OkHttpTelemetry(OkHttpInstrumenterFactory.create(this.openTelemetry, this.extractorConfigurer, this.spanNameExtractorConfigurer, this.additionalExtractors, this.emitExperimentalHttpClientMetrics), this.openTelemetry.getPropagators());
    }
}

