/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hdds.scm.storage.ByteReaderStrategy;
import org.apache.hadoop.hdds.scm.storage.ExtendedInputStream;
import org.apache.hadoop.hdds.scm.storage.PartInputStream;

public class MultipartInputStream
extends ExtendedInputStream {
    private final String key;
    private final long length;
    private final List<? extends PartInputStream> partStreams;
    private final long[] partOffsets;
    private boolean closed;
    private int partIndex;
    private int prevPartIndex;

    public MultipartInputStream(String keyName, List<? extends PartInputStream> inputStreams) {
        Preconditions.checkNotNull(inputStreams);
        this.key = keyName;
        this.partStreams = inputStreams;
        this.partOffsets = new long[inputStreams.size()];
        int i = 0;
        long streamLength = 0L;
        for (PartInputStream partInputStream : inputStreams) {
            this.partOffsets[i++] = streamLength;
            streamLength += partInputStream.getLength();
        }
        this.length = streamLength;
    }

    @Override
    protected synchronized int readWithStrategy(ByteReaderStrategy strategy) throws IOException {
        Preconditions.checkArgument((strategy != null ? 1 : 0) != 0);
        this.checkOpen();
        int totalReadLen = 0;
        while (strategy.getTargetLength() > 0) {
            if (this.partStreams.size() == 0 || this.partStreams.size() - 1 <= this.partIndex && this.partStreams.get(this.partIndex).getRemaining() == 0L) {
                return totalReadLen == 0 ? -1 : totalReadLen;
            }
            PartInputStream current = this.partStreams.get(this.partIndex);
            int numBytesToRead = this.getNumBytesToRead(strategy, current);
            int numBytesRead = strategy.readFromBlock((InputStream)((Object)current), numBytesToRead);
            this.checkPartBytesRead(numBytesToRead, numBytesRead, current);
            totalReadLen += numBytesRead;
            if (current.getRemaining() > 0L || this.partIndex + 1 >= this.partStreams.size()) continue;
            ++this.partIndex;
        }
        return totalReadLen;
    }

    protected int getNumBytesToRead(ByteReaderStrategy strategy, PartInputStream current) throws IOException {
        return strategy.getTargetLength();
    }

    protected void checkPartBytesRead(int numBytesToRead, int numBytesRead, PartInputStream stream) throws IOException {
    }

    @Override
    public synchronized void seek(long pos) throws IOException {
        this.checkOpen();
        if (pos == 0L && this.length == 0L) {
            return;
        }
        if (pos < 0L || pos > this.length) {
            throw new EOFException("EOF encountered at pos: " + pos + " for key: " + this.key);
        }
        if (this.partIndex >= this.partStreams.size()) {
            this.partIndex = Arrays.binarySearch(this.partOffsets, pos);
        } else if (pos < this.partOffsets[this.partIndex]) {
            this.partIndex = Arrays.binarySearch(this.partOffsets, 0, this.partIndex, pos);
        } else if (pos >= this.partOffsets[this.partIndex] + this.partStreams.get(this.partIndex).getLength()) {
            this.partIndex = Arrays.binarySearch(this.partOffsets, this.partIndex + 1, this.partStreams.size(), pos);
        }
        if (this.partIndex < 0) {
            this.partIndex = -this.partIndex - 2;
        }
        this.partStreams.get(this.prevPartIndex).seek(0L);
        for (int index = this.partIndex + 1; index < this.partStreams.size(); ++index) {
            this.partStreams.get(index).seek(0L);
        }
        this.partStreams.get(this.partIndex).seek(pos - this.partOffsets[this.partIndex]);
        this.prevPartIndex = this.partIndex;
    }

    public synchronized long getPos() throws IOException {
        return this.length == 0L ? 0L : this.partOffsets[this.partIndex] + this.partStreams.get(this.partIndex).getPos();
    }

    @Override
    public synchronized int available() throws IOException {
        this.checkOpen();
        long remaining = this.length - this.getPos();
        return remaining <= Integer.MAX_VALUE ? (int)remaining : Integer.MAX_VALUE;
    }

    public synchronized void unbuffer() {
        for (PartInputStream partInputStream : this.partStreams) {
            partInputStream.unbuffer();
        }
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long toSkip = Math.min(n, this.length - this.getPos());
        this.seek(this.getPos() + toSkip);
        return toSkip;
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        for (PartInputStream partInputStream : this.partStreams) {
            partInputStream.close();
        }
    }

    private void checkOpen() throws IOException {
        if (this.closed) {
            throw new IOException(": Stream is closed! Key: " + this.key);
        }
    }

    public long getLength() {
        return this.length;
    }

    @VisibleForTesting
    public synchronized int getCurrentStreamIndex() {
        return this.partIndex;
    }

    @VisibleForTesting
    public long getRemainingOfIndex(int index) throws IOException {
        return this.partStreams.get(index).getRemaining();
    }

    @VisibleForTesting
    public List<? extends PartInputStream> getPartStreams() {
        return this.partStreams;
    }
}

