/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.ratis.util.Preconditions;

public interface SegmentedRaftLogFormat {
    public static int getHeaderLength() {
        return Internal.HEADER.remaining();
    }

    public static ByteBuffer getHeaderBytebuffer() {
        return Internal.HEADER.duplicate();
    }

    public static int matchHeader(byte[] bytes, int offset, int length) {
        Preconditions.assertTrue(length <= SegmentedRaftLogFormat.getHeaderLength());
        for (int i = 0; i < length; ++i) {
            if (bytes[offset + i] == Internal.HEADER.get(i)) continue;
            return i;
        }
        return length;
    }

    public static byte getTerminator() {
        return 0;
    }

    public static boolean isTerminator(byte b) {
        return b == 0;
    }

    public static boolean isTerminator(byte[] bytes, int offset, int length) {
        return SegmentedRaftLogFormat.indexOfNonTerminator(bytes, offset, length) == -1;
    }

    public static int indexOfNonTerminator(byte[] bytes, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            if (SegmentedRaftLogFormat.isTerminator(bytes[offset + i])) continue;
            return i;
        }
        return -1;
    }

    public static class Internal {
        private static final ByteBuffer HEADER;
        private static final byte TERMINATOR_BYTE = 0;

        static {
            byte[] bytes = "RaftLog1".getBytes(StandardCharsets.UTF_8);
            ByteBuffer header = ByteBuffer.allocateDirect(bytes.length);
            header.put(bytes).flip();
            HEADER = header.asReadOnlyBuffer();
        }
    }
}

