/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.statemachine.impl;

import java.io.IOException;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.SnapshotRetentionPolicy;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.Preconditions;

public class BaseStateMachine
implements StateMachine,
StateMachine.DataApi,
StateMachine.EventApi,
StateMachine.LeaderEventApi,
StateMachine.FollowerEventApi {
    private final CompletableFuture<RaftServer> server = new CompletableFuture();
    private volatile RaftGroupId groupId;
    private final LifeCycle lifeCycle = new LifeCycle(JavaUtils.getClassSimpleName(this.getClass()));
    private final AtomicReference<TermIndex> lastAppliedTermIndex = new AtomicReference();
    private final SortedMap<Long, CompletableFuture<Void>> transactionFutures = new TreeMap<Long, CompletableFuture<Void>>();

    public BaseStateMachine() {
        this.setLastAppliedTermIndex(TermIndex.INITIAL_VALUE);
    }

    public RaftPeerId getId() {
        return this.server.isDone() ? this.server.join().getId() : null;
    }

    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    public CompletableFuture<RaftServer> getServer() {
        return this.server;
    }

    public RaftGroupId getGroupId() {
        return this.groupId;
    }

    @Override
    public LifeCycle.State getLifeCycleState() {
        return this.lifeCycle.getCurrentState();
    }

    @Override
    public void initialize(RaftServer raftServer, RaftGroupId raftGroupId, RaftStorage storage) throws IOException {
        this.groupId = raftGroupId;
        this.server.complete(raftServer);
        this.lifeCycle.setName("" + this);
    }

    @Override
    public SnapshotInfo getLatestSnapshot() {
        return this.getStateMachineStorage().getLatestSnapshot();
    }

    @Override
    public void pause() {
    }

    @Override
    public void reinitialize() throws IOException {
    }

    @Override
    public TransactionContext applyTransactionSerial(TransactionContext trx) throws InvalidProtocolBufferException {
        return trx;
    }

    @Override
    public CompletableFuture<Message> applyTransaction(TransactionContext trx) {
        RaftProtos.LogEntryProto entry = Objects.requireNonNull(trx.getLogEntry());
        this.updateLastAppliedTermIndex(entry.getTerm(), entry.getIndex());
        return CompletableFuture.completedFuture(Message.valueOf(trx.getLogEntry().getStateMachineLogEntry().getLogData()));
    }

    @Override
    public TermIndex getLastAppliedTermIndex() {
        return this.lastAppliedTermIndex.get();
    }

    protected void setLastAppliedTermIndex(TermIndex newTI) {
        this.lastAppliedTermIndex.set(newTI);
    }

    @Override
    public void notifyTermIndexUpdated(long term, long index) {
        this.updateLastAppliedTermIndex(term, index);
    }

    protected boolean updateLastAppliedTermIndex(long term, long index) {
        return this.updateLastAppliedTermIndex(TermIndex.valueOf(term, index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateLastAppliedTermIndex(TermIndex newTI) {
        Objects.requireNonNull(newTI, "newTI == null");
        TermIndex oldTI = this.lastAppliedTermIndex.getAndSet(newTI);
        if (!newTI.equals(oldTI)) {
            LOG.trace("{}: update lastAppliedTermIndex from {} to {}", this.getId(), oldTI, newTI);
            if (oldTI != null) {
                Preconditions.assertTrue(newTI.compareTo(oldTI) >= 0, () -> this.getId() + ": Failed updateLastAppliedTermIndex: newTI = " + newTI + " < oldTI = " + oldTI);
            }
            return true;
        }
        SortedMap<Long, CompletableFuture<Void>> sortedMap = this.transactionFutures;
        synchronized (sortedMap) {
            long i;
            while (!this.transactionFutures.isEmpty() && (i = this.transactionFutures.firstKey().longValue()) <= newTI.getIndex()) {
                ((CompletableFuture)this.transactionFutures.remove(i)).complete(null);
            }
        }
        return false;
    }

    @Override
    public long takeSnapshot() throws IOException {
        return -1L;
    }

    @Override
    public StateMachineStorage getStateMachineStorage() {
        return new StateMachineStorage(){

            @Override
            public void init(RaftStorage raftStorage) throws IOException {
            }

            @Override
            public SnapshotInfo getLatestSnapshot() {
                return null;
            }

            @Override
            public void format() throws IOException {
            }

            @Override
            public void cleanupOldSnapshots(SnapshotRetentionPolicy snapshotRetentionPolicy) {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Message> queryStale(Message request, long minIndex) {
        if (this.getLastAppliedTermIndex().getIndex() < minIndex) {
            SortedMap<Long, CompletableFuture<Void>> sortedMap = this.transactionFutures;
            synchronized (sortedMap) {
                if (this.getLastAppliedTermIndex().getIndex() < minIndex) {
                    return this.transactionFutures.computeIfAbsent(minIndex, key -> new CompletableFuture()).thenCompose(v -> this.query(request));
                }
            }
        }
        return this.query(request);
    }

    @Override
    public CompletableFuture<Message> query(Message request) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public TransactionContext startTransaction(RaftClientRequest request) throws IOException {
        return TransactionContext.newBuilder().setStateMachine(this).setClientRequest(request).build();
    }

    @Override
    public TransactionContext cancelTransaction(TransactionContext trx) throws IOException {
        return trx;
    }

    @Override
    public TransactionContext preAppendTransaction(TransactionContext trx) throws IOException {
        return trx;
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + ":" + (!this.server.isDone() ? "uninitialized" : this.getId() + ":" + this.groupId);
    }
}

