/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.sql.datasources.geopackage.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.sedona.sql.datasources.geopackage.model.GeoPackageField;
import org.apache.sedona.sql.datasources.geopackage.model.TableType$;
import org.apache.sedona.sql.datasources.geopackage.model.TileMatrix;
import org.apache.sedona.sql.datasources.geopackage.model.TileMetadata;
import scala.Enumeration;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.runtime.BoxesRunTime;

public final class GeoPackageConnectionManager$ {
    public static GeoPackageConnectionManager$ MODULE$;

    static {
        new GeoPackageConnectionManager$();
    }

    public Statement createStatement(String file) {
        Connection conn = DriverManager.getConnection(new StringBuilder(12).append("jdbc:sqlite:").append(file).toString());
        return conn.createStatement();
    }

    public void closeStatement(Statement st) {
        st.close();
    }

    public ResultSet getTableCursor(String path, String tableName) {
        Connection conn = DriverManager.getConnection(new StringBuilder(12).append("jdbc:sqlite:").append(path).toString());
        Statement stmt = conn.createStatement();
        return stmt.executeQuery(new StringBuilder(14).append("SELECT * FROM ").append(tableName).toString());
    }

    public Seq<GeoPackageField> getSchema(String file, String tableName) {
        Seq seq;
        Statement statement = this.createStatement(file);
        try {
            ResultSet rs = statement.executeQuery(new StringBuilder(19).append("PRAGMA table_info(").append(tableName).append(")").toString());
            ArrayBuffer fields = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            while (rs.next()) {
                String columnName = rs.getString("name");
                String columnType = rs.getString("type");
                fields.$plus$eq((Object)new GeoPackageField(columnName, columnType, true));
            }
            seq = fields.toSeq();
        }
        finally {
            this.closeStatement(statement);
        }
        return seq;
    }

    public Enumeration.Value findFeatureMetadata(String file, String tableName) {
        Enumeration.Value value;
        Statement statement = this.createStatement(file);
        ResultSet rs = statement.executeQuery(new StringBuilder(49).append("select * from gpkg_contents where table_name = '").append(tableName).append("'").toString());
        try {
            String string = rs.getString("data_type");
            Enumeration.Value value2 = "features".equals(string) ? TableType$.MODULE$.FEATURES() : ("tiles".equals(string) ? TableType$.MODULE$.TILES() : TableType$.MODULE$.UNKNOWN());
            value = value2;
        }
        finally {
            rs.close();
            this.closeStatement(statement);
        }
        return value;
    }

    public HashMap<Object, TileMatrix> getZoomLevelData(String file, String tableName) {
        Statement stmt = this.createStatement(file);
        String arg$macro$1 = tableName;
        ResultSet rs = stmt.executeQuery(new StringOps("select * from gpkg_tile_matrix where table_name = '%s'").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1})));
        HashMap result = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            while (rs.next()) {
                int zoom_level = rs.getInt("zoom_level");
                int matrix_width = rs.getInt("matrix_width");
                int matrix_height = rs.getInt("matrix_height");
                int tile_width = rs.getInt("tile_width");
                int tile_height = rs.getInt("tile_height");
                double pixel_x_size = rs.getDouble("pixel_x_size");
                double pixel_y_size = rs.getDouble("pixel_y_size");
                result.update((Object)BoxesRunTime.boxToInteger((int)zoom_level), (Object)new TileMatrix(zoom_level, matrix_width, matrix_height, tile_width, tile_height, pixel_x_size, pixel_y_size));
            }
        }
        finally {
            rs.close();
            this.closeStatement(stmt);
        }
        return result;
    }

    public TileMetadata findTilesMetadata(String file, String tableName) {
        TileMetadata tileMetadata;
        Statement statement = this.createStatement(file);
        ResultSet rs = statement.executeQuery(new StringBuilder(56).append("select * from gpkg_tile_matrix_set where table_name = '").append(tableName).append("'").toString());
        try {
            double minX = rs.getDouble("min_x");
            double minY = rs.getDouble("min_y");
            double maxX = rs.getDouble("max_x");
            double maxY = rs.getDouble("max_y");
            int srsID = rs.getInt("srs_id");
            HashMap<Object, TileMatrix> getZoomLevelData = this.getZoomLevelData(file, tableName);
            tileMetadata = new TileMetadata(tableName, minX, minY, maxX, maxY, srsID, getZoomLevelData, null);
        }
        finally {
            rs.close();
            this.closeStatement(statement);
        }
        return tileMetadata;
    }

    private GeoPackageConnectionManager$() {
        MODULE$ = this;
    }
}

