/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.snowflake.snowsql.udtfs;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.sedona.common.Functions;
import org.apache.sedona.snowflake.snowsql.GeometrySerde;
import org.apache.sedona.snowflake.snowsql.annotations.UDTFAnnotations;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;

@UDTFAnnotations.TabularFunc(name="ST_Collect", argNames={"geom"})
public class ST_Collect {
    public static final GeometryFactory geometryFactory = new GeometryFactory();
    List<Geometry> buffer = new ArrayList<Geometry>();

    public static Class getOutputClass() {
        return OutputRow.class;
    }

    public Stream<OutputRow> process(byte[] geom) throws ParseException {
        this.buffer.add(GeometrySerde.deserialize(geom));
        return Stream.empty();
    }

    public Stream<OutputRow> endPartition() {
        return Stream.of(new OutputRow(GeometrySerde.serialize(Functions.createMultiGeometry(this.buffer.toArray(new Geometry[0])))));
    }

    public static class OutputRow {
        public byte[] collection;

        public OutputRow(byte[] collection) {
            this.collection = collection;
        }
    }
}

