/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.shapefileParser.shapes;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeParser;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeReaderFactory;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeType;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.TypeUnknownException;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.ShpRecord;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class PrimitiveShape
implements Serializable {
    private final byte[] primitiveRecord;
    private final ShapeType shapeType;
    private String attributes = null;

    public PrimitiveShape(ShpRecord record) {
        this.primitiveRecord = record.getBytes().getBytes();
        this.shapeType = ShapeType.getType(record.getTypeID());
    }

    public byte[] getPrimitiveRecord() {
        return this.primitiveRecord;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public Geometry getShape(GeometryFactory geometryFactory) throws IOException, TypeUnknownException {
        ShapeParser parser = this.shapeType.getParser(geometryFactory);
        ByteBuffer shapeBuffer = ByteBuffer.wrap(this.primitiveRecord);
        Geometry shape = parser.parseShape(ShapeReaderFactory.fromByteBuffer(shapeBuffer));
        if (this.attributes != null) {
            shape.setUserData(this.attributes);
        }
        return shape;
    }
}

