/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import javax.annotation.Nonnull;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.CollectionInfo;
import ucar.nc2.ft.point.PointCollectionImpl;
import ucar.nc2.ft.point.PointFeatureImpl;
import ucar.nc2.ft.point.PointIteratorFromStructureData;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationFeatureHas;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.NestedTable;
import ucar.nc2.time.CalendarDateUnit;

public class StandardPointFeatureIterator
extends PointIteratorFromStructureData {
    protected PointCollectionImpl collectionDsg;
    protected NestedTable ft;
    protected CalendarDateUnit timeUnit;
    protected Cursor cursor;

    StandardPointFeatureIterator(PointCollectionImpl dsg, NestedTable ft, CalendarDateUnit timeUnit, StructureDataIterator structIter, Cursor cursor) {
        super(structIter, null);
        this.collectionDsg = dsg;
        this.ft = ft;
        this.timeUnit = timeUnit;
        this.cursor = cursor;
        CollectionInfo info = dsg.getInfo();
        if (!info.isComplete()) {
            this.setCalculateBounds(info);
        }
    }

    @Override
    protected PointFeature makeFeature(int recnum, StructureData sdata) throws IOException {
        this.cursor.recnum[0] = recnum;
        this.cursor.tableData[0] = sdata;
        this.cursor.currentIndex = 0;
        this.ft.addParentJoin(this.cursor);
        if (this.isMissing()) {
            return null;
        }
        double obsTime = this.ft.getObsTime(this.cursor);
        return new StandardPointFeature(this.cursor.copy(), this.timeUnit, obsTime);
    }

    protected boolean isMissing() throws IOException {
        return this.ft.isTimeMissing(this.cursor) || this.ft.isMissing(this.cursor);
    }

    private class StandardPointFeature
    extends PointFeatureImpl
    implements StationPointFeature,
    StationFeatureHas {
        protected Cursor cursor;

        StandardPointFeature(Cursor cursor, CalendarDateUnit timeUnit, double obsTime) {
            super(StandardPointFeatureIterator.this.collectionDsg, timeUnit);
            this.cursor = cursor;
            cursor.currentIndex = 1;
            this.obsTime = obsTime;
            this.nomTime = StandardPointFeatureIterator.this.ft.getNomTime(this.cursor);
            if (Double.isNaN(this.nomTime)) {
                this.nomTime = obsTime;
            }
            this.location = StandardPointFeatureIterator.this.ft.getEarthLocation(this.cursor);
        }

        @Override
        @Nonnull
        public StructureData getFeatureData() {
            return StandardPointFeatureIterator.this.ft.makeObsStructureData(this.cursor, 0);
        }

        @Override
        @Nonnull
        public StructureData getDataAll() {
            return StandardPointFeatureIterator.this.ft.makeObsStructureData(this.cursor);
        }

        @Override
        @Nonnull
        public DsgFeatureCollection getFeatureCollection() {
            return this.dsg;
        }

        @Override
        public StationFeature getStation() {
            return StandardPointFeatureIterator.this.ft.makeStation(this.cursor.getParentStructure());
        }

        @Override
        public StationFeature getStationFeature() {
            if (StandardPointFeatureIterator.this.collectionDsg instanceof StationFeature) {
                return (StationFeature)((Object)StandardPointFeatureIterator.this.collectionDsg);
            }
            return null;
        }
    }
}

