/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.zipkin2.reporter;

import java.util.List;
import org.apache.shardingsphere.shade.zipkin2.reporter.BytesMessageEncoder;

public enum Encoding {
    JSON{

        @Override
        public int listSizeInBytes(int encodedSizeInBytes) {
            return 2 + encodedSizeInBytes;
        }

        @Override
        public int listSizeInBytes(List<byte[]> values2) {
            int sizeInBytes = 2;
            int i = 0;
            int length = values2.size();
            while (i < length) {
                sizeInBytes += values2.get(i++).length;
                if (i >= length) continue;
                ++sizeInBytes;
            }
            return sizeInBytes;
        }

        @Override
        public byte[] encode(List<byte[]> encodedSpans) {
            return BytesMessageEncoder.JSON.encode(encodedSpans);
        }

        @Override
        public String mediaType() {
            return "application/json";
        }
    }
    ,
    THRIFT{

        @Override
        public int listSizeInBytes(int encodedSizeInBytes) {
            return 5 + encodedSizeInBytes;
        }

        @Override
        public int listSizeInBytes(List<byte[]> values2) {
            int sizeInBytes = 5;
            int length = values2.size();
            for (int i = 0; i < length; ++i) {
                sizeInBytes += values2.get(i).length;
            }
            return sizeInBytes;
        }

        @Override
        public byte[] encode(List<byte[]> encodedSpans) {
            return BytesMessageEncoder.THRIFT.encode(encodedSpans);
        }

        @Override
        public String mediaType() {
            return "application/x-thrift";
        }
    }
    ,
    PROTO3{

        @Override
        public int listSizeInBytes(int encodedSizeInBytes) {
            return encodedSizeInBytes;
        }

        @Override
        public int listSizeInBytes(List<byte[]> values2) {
            int sizeInBytes = 0;
            int i = 0;
            int length = values2.size();
            while (i < length) {
                sizeInBytes += values2.get(i++).length;
            }
            return sizeInBytes;
        }

        @Override
        public byte[] encode(List<byte[]> encodedSpans) {
            return BytesMessageEncoder.PROTO3.encode(encodedSpans);
        }

        @Override
        public String mediaType() {
            return "application/x-protobuf";
        }
    };


    public abstract byte[] encode(List<byte[]> var1);

    public abstract int listSizeInBytes(int var1);

    public abstract int listSizeInBytes(List<byte[]> var1);

    public abstract String mediaType();
}

