/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.retriever.dml.table.hint;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.shadow.condition.ShadowCondition;
import org.apache.shardingsphere.shadow.route.determiner.HintShadowAlgorithmDeterminer;
import org.apache.shardingsphere.shadow.route.retriever.dml.table.ShadowTableDataSourceMappingsRetriever;
import org.apache.shardingsphere.shadow.rule.ShadowRule;
import org.apache.shardingsphere.shadow.spi.ShadowOperationType;
import org.apache.shardingsphere.shadow.spi.hint.HintShadowAlgorithm;

public final class ShadowTableHintDataSourceMappingsRetriever
implements ShadowTableDataSourceMappingsRetriever {
    private final ShadowOperationType operationType;
    private final boolean isShadow;

    @Override
    public Map<String, String> retrieve(ShadowRule rule, Collection<String> shadowTables) {
        return shadowTables.isEmpty() && this.isMatchDefaultAlgorithm(rule) ? rule.getAllShadowDataSourceMappings() : this.findShadowDataSourceMappingsBySQLHints(rule, shadowTables);
    }

    private boolean isMatchDefaultAlgorithm(ShadowRule rule) {
        return rule.getDefaultShadowAlgorithm().filter(optional -> HintShadowAlgorithmDeterminer.isShadow((HintShadowAlgorithm)optional, new ShadowCondition(), rule, this.isShadow)).isPresent();
    }

    private Map<String, String> findShadowDataSourceMappingsBySQLHints(ShadowRule rule, Collection<String> shadowTables) {
        for (String each : shadowTables) {
            if (!this.containsShadowInSQLHints(rule, each, new ShadowCondition(each, this.operationType))) continue;
            return rule.getShadowDataSourceMappings(each);
        }
        return Collections.emptyMap();
    }

    private boolean containsShadowInSQLHints(ShadowRule rule, String tableName, ShadowCondition shadowCondition) {
        for (HintShadowAlgorithm<Comparable<?>> each : rule.getHintShadowAlgorithms(tableName)) {
            if (!HintShadowAlgorithmDeterminer.isShadow(each, shadowCondition, rule, this.isShadow)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public ShadowTableHintDataSourceMappingsRetriever(ShadowOperationType operationType, boolean isShadow) {
        this.operationType = operationType;
        this.isShadow = isShadow;
    }
}

