/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.rule.changed;

import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.spi.rule.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.mode.spi.rule.item.alter.AlterRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.drop.DropRuleItem;
import org.apache.shardingsphere.shadow.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.rule.ShadowRule;

public final class DefaultShadowAlgorithmNameChangedProcessor
implements RuleItemConfigurationChangedProcessor<ShadowRuleConfiguration, String> {
    public String swapRuleItemConfiguration(AlterRuleItem alterRuleItem, String yamlContent) {
        return yamlContent;
    }

    public ShadowRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(ShadowRule.class).map(ShadowRule::getConfiguration).orElseGet(ShadowRuleConfiguration::new);
    }

    public void changeRuleItemConfiguration(AlterRuleItem alterRuleItem, ShadowRuleConfiguration currentRuleConfig, String toBeChangedItemConfig) {
        currentRuleConfig.setDefaultShadowAlgorithmName(toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(DropRuleItem dropRuleItem, ShadowRuleConfiguration currentRuleConfig) {
        currentRuleConfig.setDefaultShadowAlgorithmName(null);
    }

    public String getType() {
        return "shadow.default_shadow_algorithm_name";
    }
}

