/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service.metadata.table;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.version.MetaDataVersion;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlShardingSphereTable;
import org.apache.shardingsphere.infra.yaml.schema.swapper.YamlTableSwapper;
import org.apache.shardingsphere.mode.metadata.persist.service.version.MetaDataVersionPersistService;
import org.apache.shardingsphere.mode.node.path.metadata.TableMetaDataNodePath;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class TableMetaDataPersistService {
    private final PersistRepository repository;
    private final MetaDataVersionPersistService metaDataVersionPersistService;

    public Collection<ShardingSphereTable> load(String databaseName, String schemaName) {
        return this.repository.getChildrenKeys(TableMetaDataNodePath.getMetaDataTablesPath((String)databaseName, (String)schemaName)).stream().map(each -> this.load(databaseName, schemaName, (String)each)).collect(Collectors.toList());
    }

    public ShardingSphereTable load(String databaseName, String schemaName, String tableName) {
        String tableContent = this.repository.query(TableMetaDataNodePath.getTableVersionPath((String)databaseName, (String)schemaName, (String)tableName, (String)this.repository.query(TableMetaDataNodePath.getTableActiveVersionPath((String)databaseName, (String)schemaName, (String)tableName))));
        return new YamlTableSwapper().swapToObject((YamlShardingSphereTable)YamlEngine.unmarshal((String)tableContent, YamlShardingSphereTable.class));
    }

    public void persist(String databaseName, String schemaName, Collection<ShardingSphereTable> tables) {
        LinkedList<MetaDataVersion> metaDataVersions = new LinkedList<MetaDataVersion>();
        for (ShardingSphereTable each : tables) {
            String tableName = each.getName().toLowerCase();
            List<String> versions = this.metaDataVersionPersistService.getVersions(TableMetaDataNodePath.getTableVersionsPath((String)databaseName, (String)schemaName, (String)tableName));
            String nextActiveVersion = versions.isEmpty() ? "0" : String.valueOf(Integer.parseInt(versions.get(0)) + 1);
            this.repository.persist(TableMetaDataNodePath.getTableVersionPath((String)databaseName, (String)schemaName, (String)tableName, (String)nextActiveVersion), YamlEngine.marshal((Object)new YamlTableSwapper().swapToYamlConfiguration(each)));
            if (Strings.isNullOrEmpty((String)this.getActiveVersion(databaseName, schemaName, tableName))) {
                this.repository.persist(TableMetaDataNodePath.getTableActiveVersionPath((String)databaseName, (String)schemaName, (String)tableName), "0");
            }
            metaDataVersions.add(new MetaDataVersion(TableMetaDataNodePath.getTablePath((String)databaseName, (String)schemaName, (String)tableName), this.getActiveVersion(databaseName, schemaName, tableName), nextActiveVersion));
        }
        this.metaDataVersionPersistService.switchActiveVersion(metaDataVersions);
    }

    private String getActiveVersion(String databaseName, String schemaName, String tableName) {
        return this.repository.query(TableMetaDataNodePath.getTableActiveVersionPath((String)databaseName, (String)schemaName, (String)tableName));
    }

    public void drop(String databaseName, String schemaName, String tableName) {
        this.repository.delete(TableMetaDataNodePath.getTablePath((String)databaseName, (String)schemaName, (String)tableName.toLowerCase()));
    }

    public void drop(String databaseName, String schemaName, Collection<ShardingSphereTable> tables) {
        tables.forEach(each -> this.drop(databaseName, schemaName, each.getName()));
    }

    @Generated
    public TableMetaDataPersistService(PersistRepository repository, MetaDataVersionPersistService metaDataVersionPersistService) {
        this.repository = repository;
        this.metaDataVersionPersistService = metaDataVersionPersistService;
    }
}

