/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.pojo;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShardingTokenUtils {
    public static Map<String, String> getLogicAndActualTableMap(RouteUnit routeUnit, SQLStatementContext sqlStatementContext, ShardingRule rule) {
        if (!(sqlStatementContext instanceof TableAvailable)) {
            return Collections.emptyMap();
        }
        Collection tableNames = ((TableAvailable)sqlStatementContext).getTablesContext().getTableNames();
        CaseInsensitiveMap result = new CaseInsensitiveMap(tableNames.size(), 1.0f);
        for (RouteMapper each : routeUnit.getTableMappers()) {
            result.put(each.getLogicName(), each.getActualName());
            result.putAll(rule.getLogicAndActualTablesFromBindingTable(routeUnit.getDataSourceMapper().getLogicName(), each.getLogicName(), each.getActualName(), tableNames));
        }
        return result;
    }

    @Generated
    private ShardingTokenUtils() {
    }
}

