/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.type.SimpleTableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.util.SubqueryTableBindUtils;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.database.opengauss.type.OpenGaussDatabaseType;
import org.apache.shardingsphere.infra.database.postgresql.type.PostgreSQLDatabaseType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.table.TableExistsException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.SchemaNotFoundException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.TableNotFoundException;
import org.apache.shardingsphere.infra.metadata.database.schema.manager.SystemSchemaManager;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.RenameTableDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.ColumnSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.TableSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.AlterTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.RenameTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class SimpleTableSegmentBinder {
    private static final String PG_CATALOG = "pg_catalog";

    public static SimpleTableSegment bind(SimpleTableSegment segment, SQLStatementBinderContext binderContext, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts) {
        SimpleTableSegmentBinder.fillPivotColumnNamesInBinderContext(segment, binderContext);
        IdentifierValue databaseName = SimpleTableSegmentBinder.getDatabaseName(segment, binderContext);
        IdentifierValue schemaName = SimpleTableSegmentBinder.getSchemaName(segment, binderContext, databaseName);
        IdentifierValue tableName = segment.getTableName().getIdentifier();
        ShardingSphereSchema schema = binderContext.getMetaData().getDatabase(databaseName.getValue()).getSchema(schemaName.getValue());
        SimpleTableSegmentBinder.checkTableExists(binderContext, schema, schemaName.getValue(), tableName.getValue());
        tableBinderContexts.put((Object)new CaseInsensitiveMap.CaseInsensitiveString(segment.getAliasName().orElseGet(() -> ((IdentifierValue)tableName).getValue())), (Object)SimpleTableSegmentBinder.createSimpleTableBinderContext(segment, schema, databaseName, schemaName, binderContext));
        TableNameSegment tableNameSegment = new TableNameSegment(segment.getTableName().getStartIndex(), segment.getTableName().getStopIndex(), tableName);
        tableNameSegment.setTableBoundInfo(new TableSegmentBoundInfo(databaseName, schemaName));
        SimpleTableSegment result = new SimpleTableSegment(tableNameSegment);
        segment.getOwner().ifPresent(arg_0 -> ((SimpleTableSegment)result).setOwner(arg_0));
        segment.getAliasSegment().ifPresent(arg_0 -> ((SimpleTableSegment)result).setAlias(arg_0));
        return result;
    }

    private static void fillPivotColumnNamesInBinderContext(SimpleTableSegment segment, SQLStatementBinderContext binderContext) {
        segment.getPivot().ifPresent(optional -> optional.getPivotColumns().forEach(each -> binderContext.getPivotColumnNames().add(each.getIdentifier().getValue())));
    }

    private static IdentifierValue getDatabaseName(SimpleTableSegment segment, SQLStatementBinderContext binderContext) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(binderContext.getSqlStatement().getDatabaseType()).getDialectDatabaseMetaData();
        Optional<String> owner = dialectDatabaseMetaData.getDefaultSchema().isPresent() ? segment.getOwner().flatMap(OwnerSegment::getOwner) : segment.getOwner();
        IdentifierValue result = new IdentifierValue(owner.map(optional -> optional.getIdentifier().getValue()).orElse(binderContext.getCurrentDatabaseName()));
        ShardingSpherePreconditions.checkNotNull((Object)result.getValue(), NoDatabaseSelectedException::new);
        ShardingSpherePreconditions.checkState((boolean)binderContext.getMetaData().containsDatabase(result.getValue()), () -> new UnknownDatabaseException(result.getValue()));
        return result;
    }

    private static IdentifierValue getSchemaName(SimpleTableSegment segment, SQLStatementBinderContext binderContext, IdentifierValue databaseName) {
        IdentifierValue result = SimpleTableSegmentBinder.getSchemaName(segment, binderContext);
        ShardingSpherePreconditions.checkState((boolean)binderContext.getMetaData().getDatabase(databaseName.getValue()).containsSchema(result.getValue()), () -> new SchemaNotFoundException(result.getValue()));
        return result;
    }

    private static IdentifierValue getSchemaName(SimpleTableSegment segment, SQLStatementBinderContext binderContext) {
        if (segment.getOwner().isPresent()) {
            return ((OwnerSegment)segment.getOwner().get()).getIdentifier();
        }
        DatabaseType databaseType = binderContext.getSqlStatement().getDatabaseType();
        if ((databaseType instanceof PostgreSQLDatabaseType || databaseType instanceof OpenGaussDatabaseType) && SystemSchemaManager.isSystemTable((String)databaseType.getType(), (String)PG_CATALOG, (String)segment.getTableName().getIdentifier().getValue())) {
            return new IdentifierValue(PG_CATALOG);
        }
        return new IdentifierValue(new DatabaseTypeRegistry(databaseType).getDefaultSchemaName(binderContext.getCurrentDatabaseName()));
    }

    private static void checkTableExists(SQLStatementBinderContext binderContext, ShardingSphereSchema schema, String schemaName, String tableName) {
        if (binderContext.getSqlStatement() instanceof CreateTableStatement && SimpleTableSegmentBinder.isCreateTable(((CreateTableStatement)binderContext.getSqlStatement()).getTable(), tableName)) {
            ShardingSpherePreconditions.checkState((binderContext.getHintValueContext().isSkipMetadataValidate() || ((CreateTableStatement)binderContext.getSqlStatement()).isIfNotExists() || !schema.containsTable(tableName) ? 1 : 0) != 0, () -> new TableExistsException(tableName));
            return;
        }
        if (binderContext.getSqlStatement() instanceof AlterTableStatement && SimpleTableSegmentBinder.isRenameTable((AlterTableStatement)binderContext.getSqlStatement(), tableName)) {
            ShardingSpherePreconditions.checkState((binderContext.getHintValueContext().isSkipMetadataValidate() || !schema.containsTable(tableName) ? 1 : 0) != 0, () -> new TableExistsException(tableName));
            return;
        }
        if (binderContext.getSqlStatement() instanceof DropTableStatement) {
            ShardingSpherePreconditions.checkState((((DropTableStatement)binderContext.getSqlStatement()).isIfExists() || schema.containsTable(tableName) ? 1 : 0) != 0, () -> new TableNotFoundException(tableName));
            return;
        }
        if (binderContext.getSqlStatement() instanceof RenameTableStatement && SimpleTableSegmentBinder.isRenameTable((RenameTableStatement)binderContext.getSqlStatement(), tableName)) {
            ShardingSpherePreconditions.checkState((binderContext.getHintValueContext().isSkipMetadataValidate() || !schema.containsTable(tableName) ? 1 : 0) != 0, () -> new TableExistsException(tableName));
            return;
        }
        if (binderContext.getSqlStatement() instanceof CreateViewStatement && SimpleTableSegmentBinder.isCreateTable(((CreateViewStatement)binderContext.getSqlStatement()).getView(), tableName)) {
            ShardingSpherePreconditions.checkState((binderContext.getHintValueContext().isSkipMetadataValidate() || ((CreateViewStatement)binderContext.getSqlStatement()).isReplaceView() || !schema.containsTable(tableName) ? 1 : 0) != 0, () -> new TableExistsException(tableName));
            return;
        }
        if (binderContext.getSqlStatement() instanceof AlterViewStatement && SimpleTableSegmentBinder.isRenameView((AlterViewStatement)binderContext.getSqlStatement(), tableName)) {
            ShardingSpherePreconditions.checkState((binderContext.getHintValueContext().isSkipMetadataValidate() || !schema.containsTable(tableName) ? 1 : 0) != 0, () -> new TableExistsException(tableName));
            return;
        }
        if (binderContext.getSqlStatement() instanceof DropViewStatement) {
            ShardingSpherePreconditions.checkState((((DropViewStatement)binderContext.getSqlStatement()).isIfExists() || schema.containsTable(tableName) ? 1 : 0) != 0, () -> new TableNotFoundException(tableName));
            return;
        }
        if ("DUAL".equalsIgnoreCase(tableName)) {
            return;
        }
        if (SystemSchemaManager.isSystemTable((String)schemaName, (String)tableName)) {
            return;
        }
        if (binderContext.getExternalTableBinderContexts().containsKey((Object)new CaseInsensitiveMap.CaseInsensitiveString(tableName))) {
            return;
        }
        if (binderContext.getCommonTableExpressionsSegmentsUniqueAliases().contains(tableName)) {
            return;
        }
        ShardingSpherePreconditions.checkState((boolean)schema.containsTable(tableName), () -> new TableNotFoundException(tableName));
    }

    private static boolean isCreateTable(SimpleTableSegment simpleTableSegment, String tableName) {
        return simpleTableSegment.getTableName().getIdentifier().getValue().equalsIgnoreCase(tableName);
    }

    private static boolean isRenameTable(AlterTableStatement alterTableStatement, String tableName) {
        return alterTableStatement.getRenameTable().isPresent() && ((SimpleTableSegment)alterTableStatement.getRenameTable().get()).getTableName().getIdentifier().getValue().equalsIgnoreCase(tableName);
    }

    private static boolean isRenameTable(RenameTableStatement renameTableStatement, String tableName) {
        for (RenameTableDefinitionSegment each : renameTableStatement.getRenameTables()) {
            if (!each.getRenameTable().getTableName().getIdentifier().getValue().equalsIgnoreCase(tableName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRenameView(AlterViewStatement alterViewStatement, String tableName) {
        return alterViewStatement.getRenameView().isPresent() && ((SimpleTableSegment)alterViewStatement.getRenameView().get()).getTableName().getIdentifier().getValue().equalsIgnoreCase(tableName);
    }

    private static SimpleTableSegmentBinderContext createSimpleTableBinderContext(SimpleTableSegment segment, ShardingSphereSchema schema, IdentifierValue databaseName, IdentifierValue schemaName, SQLStatementBinderContext binderContext) {
        IdentifierValue tableName = segment.getTableName().getIdentifier();
        if (binderContext.getMetaData().getDatabase(databaseName.getValue()).getSchema(schemaName.getValue()).containsTable(tableName.getValue())) {
            return SimpleTableSegmentBinder.createSimpleTableSegmentBinderContextWithMetaData(segment, schema, databaseName, schemaName, binderContext, tableName);
        }
        if (binderContext.getSqlStatement() instanceof CreateTableStatement) {
            return new SimpleTableSegmentBinderContext(SimpleTableSegmentBinder.createProjectionSegments((CreateTableStatement)binderContext.getSqlStatement(), databaseName, schemaName, tableName));
        }
        CaseInsensitiveMap.CaseInsensitiveString caseInsensitiveTableName = new CaseInsensitiveMap.CaseInsensitiveString(tableName.getValue());
        if (binderContext.getExternalTableBinderContexts().containsKey((Object)caseInsensitiveTableName)) {
            TableSegmentBinderContext tableSegmentBinderContext = (TableSegmentBinderContext)binderContext.getExternalTableBinderContexts().get((Object)caseInsensitiveTableName).iterator().next();
            return new SimpleTableSegmentBinderContext(SubqueryTableBindUtils.createSubqueryProjections(tableSegmentBinderContext.getProjectionSegments(), tableName, binderContext.getSqlStatement().getDatabaseType()));
        }
        return new SimpleTableSegmentBinderContext(Collections.emptyList());
    }

    private static Collection<ProjectionSegment> createProjectionSegments(CreateTableStatement sqlStatement, IdentifierValue databaseName, IdentifierValue schemaName, IdentifierValue tableName) {
        LinkedList<ProjectionSegment> result = new LinkedList<ProjectionSegment>();
        for (ColumnDefinitionSegment each : sqlStatement.getColumnDefinitions()) {
            each.getColumnName().setColumnBoundInfo(new ColumnSegmentBoundInfo(new TableSegmentBoundInfo(databaseName, schemaName), tableName, each.getColumnName().getIdentifier()));
            result.add((ProjectionSegment)new ColumnProjectionSegment(each.getColumnName()));
        }
        return result;
    }

    private static SimpleTableSegmentBinderContext createSimpleTableSegmentBinderContextWithMetaData(SimpleTableSegment segment, ShardingSphereSchema schema, IdentifierValue databaseName, IdentifierValue schemaName, SQLStatementBinderContext binderContext, IdentifierValue tableName) {
        LinkedList<ProjectionSegment> projectionSegments = new LinkedList<ProjectionSegment>();
        QuoteCharacter quoteCharacter = new DatabaseTypeRegistry(binderContext.getSqlStatement().getDatabaseType()).getDialectDatabaseMetaData().getQuoteCharacter();
        for (ShardingSphereColumn each : schema.getTable(tableName.getValue()).getAllColumns()) {
            ColumnProjectionSegment columnProjectionSegment = new ColumnProjectionSegment(SimpleTableSegmentBinder.createColumnSegment(segment, databaseName, schemaName, each, quoteCharacter, tableName));
            columnProjectionSegment.setVisible(each.isVisible());
            projectionSegments.add((ProjectionSegment)columnProjectionSegment);
        }
        return new SimpleTableSegmentBinderContext(projectionSegments);
    }

    private static ColumnSegment createColumnSegment(SimpleTableSegment segment, IdentifierValue databaseName, IdentifierValue schemaName, ShardingSphereColumn column, QuoteCharacter quoteCharacter, IdentifierValue tableName) {
        ColumnSegment result = new ColumnSegment(0, 0, new IdentifierValue(column.getName(), quoteCharacter));
        result.setOwner(new OwnerSegment(0, 0, segment.getAlias().orElse(tableName)));
        result.setColumnBoundInfo(new ColumnSegmentBoundInfo(new TableSegmentBoundInfo(databaseName, schemaName), tableName, new IdentifierValue(column.getName(), quoteCharacter)));
        return result;
    }

    @Generated
    private SimpleTableSegmentBinder() {
    }
}

