/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.segment.dml.with;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.type.SimpleTableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type.SubqueryTableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.syntax.DuplicateCommonTableExpressionAliasException;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonTableExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;

public final class CommonTableExpressionSegmentBinder {
    public static CommonTableExpressionSegment bind(CommonTableExpressionSegment segment, SQLStatementBinderContext binderContext, boolean recursive) {
        if (segment.getAliasName().isPresent()) {
            ShardingSpherePreconditions.checkState((!binderContext.getCommonTableExpressionsSegmentsUniqueAliases().contains(segment.getAliasName().get()) ? 1 : 0) != 0, () -> new DuplicateCommonTableExpressionAliasException((String)segment.getAliasName().get()));
            binderContext.getCommonTableExpressionsSegmentsUniqueAliases().add((String)segment.getAliasName().get());
        }
        if (recursive && segment.getAliasName().isPresent()) {
            binderContext.getExternalTableBinderContexts().put((Object)new CaseInsensitiveMap.CaseInsensitiveString((String)segment.getAliasName().get()), (Object)new SimpleTableSegmentBinderContext(segment.getColumns().stream().map(ColumnProjectionSegment::new).collect(Collectors.toList())));
        }
        SubqueryTableSegment subqueryTableSegment = new SubqueryTableSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getSubquery());
        subqueryTableSegment.setAlias(segment.getAliasSegment());
        SubqueryTableSegment boundSubquerySegment = SubqueryTableSegmentBinder.bind(subqueryTableSegment, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)LinkedHashMultimap.create(), binderContext.getExternalTableBinderContexts());
        CommonTableExpressionSegment result = new CommonTableExpressionSegment(segment.getStartIndex(), segment.getStopIndex(), (AliasSegment)boundSubquerySegment.getAliasSegment().orElse(null), boundSubquerySegment.getSubquery());
        result.getColumns().addAll(segment.getColumns());
        return result;
    }

    @Generated
    private CommonTableExpressionSegmentBinder() {
    }
}

