/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.rule;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.mask.config.rule.MaskColumnRuleConfiguration;
import org.apache.shardingsphere.mask.config.rule.MaskTableRuleConfiguration;
import org.apache.shardingsphere.mask.rule.MaskColumn;
import org.apache.shardingsphere.mask.spi.MaskAlgorithm;

public final class MaskTable {
    private final Map<String, MaskColumn> columns;

    public MaskTable(MaskTableRuleConfiguration config, Map<String, MaskAlgorithm<?, ?>> maskAlgorithms) {
        this.columns = (Map)config.getColumns().stream().collect(Collectors.toMap(MaskColumnRuleConfiguration::getLogicColumn, each -> new MaskColumn(each.getLogicColumn(), (MaskAlgorithm)maskAlgorithms.get(each.getMaskAlgorithm())), (oldValue, currentValue) -> oldValue, CaseInsensitiveMap::new));
    }

    public Optional<MaskAlgorithm> findAlgorithm(String columnName) {
        return this.columns.containsKey(columnName) ? Optional.of(this.columns.get(columnName).getMaskAlgorithm()) : Optional.empty();
    }
}

