/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.type.index;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.SchemaNotFoundException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.TableNotFoundException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereIndex;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.pojo.AlterSchemaMetaDataPOJO;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtils;
import org.apache.shardingsphere.mode.metadata.refresher.MetaDataRefresher;
import org.apache.shardingsphere.mode.persist.service.divided.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateIndexStatement;

public final class CreateIndexStatementSchemaRefresher
implements MetaDataRefresher<CreateIndexStatement> {
    @Override
    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, DatabaseType databaseType, CreateIndexStatement sqlStatement, ConfigurationProperties props) {
        String indexName = null == sqlStatement.getIndex() ? IndexMetaDataUtils.getGeneratedLogicIndexName((Collection)sqlStatement.getColumns()) : sqlStatement.getIndex().getIndexName().getIdentifier().getValue();
        String tableName = sqlStatement.getTable().getTableName().getIdentifier().getValue();
        ShardingSpherePreconditions.checkState((boolean)database.containsSchema(schemaName), () -> new SchemaNotFoundException(schemaName));
        ShardingSphereSchema schema = database.getSchema(schemaName);
        ShardingSpherePreconditions.checkState((boolean)schema.containsTable(tableName), () -> new TableNotFoundException(tableName));
        ShardingSphereTable table = schema.getTable(tableName);
        ShardingSphereTable newTable = new ShardingSphereTable(table.getName(), table.getAllColumns(), table.getAllIndexes(), table.getAllConstraints(), table.getType());
        newTable.putIndex(new ShardingSphereIndex(indexName, new LinkedList(), false));
        AlterSchemaMetaDataPOJO alterSchemaMetaDataPOJO = new AlterSchemaMetaDataPOJO(database.getName(), schemaName);
        alterSchemaMetaDataPOJO.getAlteredTables().add(newTable);
        metaDataManagerPersistService.alterSchemaMetaData(alterSchemaMetaDataPOJO);
    }

    @Override
    public Class<CreateIndexStatement> getType() {
        return CreateIndexStatement.class;
    }
}

