/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.listener;

import java.util.Map;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedDataSource;
import org.apache.shardingsphere.infra.rule.attribute.datasource.StaticDataSourceRuleAttribute;
import org.apache.shardingsphere.infra.state.datasource.qualified.QualifiedDataSourceState;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.listener.ContextManagerLifecycleListener;

public class ReadwriteSplittingContextManagerLifecycleListener
implements ContextManagerLifecycleListener {
    public void onInitialized(ContextManager contextManager) {
        if (contextManager.getComputeNodeInstanceContext().getModeConfiguration().isCluster()) {
            this.updateQualifiedDataSourceState(contextManager);
        }
    }

    public void onDestroyed(ContextManager contextManager) {
    }

    private void updateQualifiedDataSourceState(ContextManager contextManager) {
        Map qualifiedDataSourceStateMap = contextManager.getPersistServiceFacade().getQualifiedDataSourceStatePersistService().load();
        qualifiedDataSourceStateMap.forEach((key, value) -> this.updateQualifiedDataSourceState(contextManager.getMetaDataContexts().getMetaData(), new QualifiedDataSource(key), (QualifiedDataSourceState)value));
    }

    private void updateQualifiedDataSourceState(ShardingSphereMetaData metaData, QualifiedDataSource qualifiedDataSource, QualifiedDataSourceState state) {
        metaData.getAllDatabases().forEach(each -> {
            if (each.getName().equals(qualifiedDataSource.getDatabaseName())) {
                each.getRuleMetaData().getAttributes(StaticDataSourceRuleAttribute.class).forEach(attribute -> attribute.updateStatus(qualifiedDataSource, state.getState()));
            }
        });
    }
}

