/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.distsql.handler.converter;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.mask.config.MaskRuleConfiguration;
import org.apache.shardingsphere.mask.config.rule.MaskColumnRuleConfiguration;
import org.apache.shardingsphere.mask.config.rule.MaskTableRuleConfiguration;
import org.apache.shardingsphere.mask.distsql.segment.MaskColumnSegment;
import org.apache.shardingsphere.mask.distsql.segment.MaskRuleSegment;

public final class MaskRuleStatementConverter {
    public static MaskRuleConfiguration convert(Collection<MaskRuleSegment> ruleSegments) {
        LinkedList<MaskTableRuleConfiguration> tables = new LinkedList<MaskTableRuleConfiguration>();
        HashMap<String, AlgorithmConfiguration> algorithms = new HashMap<String, AlgorithmConfiguration>();
        for (MaskRuleSegment each : ruleSegments) {
            tables.add(MaskRuleStatementConverter.createMaskTableRuleConfiguration(each));
            algorithms.putAll(MaskRuleStatementConverter.createMaskAlgorithmConfigurations(each));
        }
        return new MaskRuleConfiguration(tables, algorithms);
    }

    private static MaskTableRuleConfiguration createMaskTableRuleConfiguration(MaskRuleSegment ruleSegment) {
        Collection columns = ruleSegment.getColumns().stream().map(each -> MaskRuleStatementConverter.createMaskColumnRuleConfiguration(ruleSegment.getTableName(), each)).collect(Collectors.toList());
        return new MaskTableRuleConfiguration(ruleSegment.getTableName(), columns);
    }

    private static MaskColumnRuleConfiguration createMaskColumnRuleConfiguration(String tableName, MaskColumnSegment columnSegment) {
        return new MaskColumnRuleConfiguration(columnSegment.getName(), MaskRuleStatementConverter.getAlgorithmName(tableName, columnSegment));
    }

    private static Map<String, AlgorithmConfiguration> createMaskAlgorithmConfigurations(MaskRuleSegment ruleSegment) {
        HashMap<String, AlgorithmConfiguration> result = new HashMap<String, AlgorithmConfiguration>(ruleSegment.getColumns().size(), 1.0f);
        for (MaskColumnSegment each : ruleSegment.getColumns()) {
            result.put(MaskRuleStatementConverter.getAlgorithmName(ruleSegment.getTableName(), each), new AlgorithmConfiguration(each.getAlgorithm().getName(), each.getAlgorithm().getProps()));
        }
        return result;
    }

    private static String getAlgorithmName(String tableName, MaskColumnSegment columnSegment) {
        return String.format("%s_%s_%s", tableName, columnSegment.getName(), columnSegment.getAlgorithm().getName()).toLowerCase();
    }

    @Generated
    private MaskRuleStatementConverter() {
    }
}

