/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.util;

import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Empty;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Message;
import com.google.protobuf.StringValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import lombok.Generated;

public final class ColumnValueConvertUtils {
    public static Message convertToProtobufMessage(Object object) {
        if (null == object) {
            return Empty.getDefaultInstance();
        }
        if (object instanceof Integer) {
            return Int32Value.of((int)((Integer)object));
        }
        if (object instanceof Short) {
            return Int32Value.of((int)((Short)object).intValue());
        }
        if (object instanceof Byte) {
            return Int32Value.of((int)((Byte)object).intValue());
        }
        if (object instanceof Long) {
            return Int64Value.of((long)((Long)object));
        }
        if (object instanceof BigInteger) {
            return StringValue.of((String)object.toString());
        }
        if (object instanceof Float) {
            return FloatValue.of((float)((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return DoubleValue.of((double)((Double)object));
        }
        if (object instanceof BigDecimal) {
            return StringValue.of((String)object.toString());
        }
        if (object instanceof String) {
            return StringValue.of((String)object.toString());
        }
        if (object instanceof Boolean) {
            return BoolValue.of((boolean)((Boolean)object));
        }
        if (object instanceof byte[]) {
            return BytesValue.of((ByteString)ByteString.copyFrom((byte[])((byte[])object)));
        }
        if (object instanceof Time) {
            Time time = (Time)object;
            LocalTime localTime = LocalTime.of(time.getHours(), time.getMinutes(), time.getSeconds(), new Timestamp(time.getTime()).getNanos());
            return Int64Value.of((long)localTime.toNanoOfDay());
        }
        if (object instanceof Date) {
            return Int64Value.of((long)((Date)object).toLocalDate().toEpochDay());
        }
        if (object instanceof java.util.Date) {
            return ColumnValueConvertUtils.converToProtobufTimestamp((java.util.Date)object);
        }
        if (object instanceof LocalDateTime) {
            return ColumnValueConvertUtils.converToProtobufTimestamp(Timestamp.valueOf((LocalDateTime)object));
        }
        if (object instanceof LocalDate) {
            return Int64Value.of((long)((LocalDate)object).toEpochDay());
        }
        if (object instanceof LocalTime) {
            return Int64Value.of((long)((LocalTime)object).toNanoOfDay());
        }
        if (object instanceof OffsetDateTime) {
            LocalDateTime localDateTime = ((OffsetDateTime)object).toLocalDateTime();
            return ColumnValueConvertUtils.converToProtobufTimestamp(Timestamp.valueOf(localDateTime));
        }
        if (object instanceof OffsetTime) {
            return Int64Value.of((long)((OffsetTime)object).toLocalTime().toNanoOfDay());
        }
        if (object instanceof ZonedDateTime) {
            return ColumnValueConvertUtils.converToProtobufTimestamp(Timestamp.valueOf(((ZonedDateTime)object).toLocalDateTime()));
        }
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            return com.google.protobuf.Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
        }
        if (object instanceof Clob) {
            Clob clob = (Clob)object;
            return StringValue.of((String)clob.getSubString(1L, (int)clob.length()));
        }
        if (object instanceof Blob) {
            Blob blob = (Blob)object;
            return BytesValue.of((ByteString)ByteString.copyFrom((byte[])blob.getBytes(1L, (int)blob.length())));
        }
        return StringValue.newBuilder().setValue(object.toString()).build();
    }

    private static com.google.protobuf.Timestamp converToProtobufTimestamp(java.util.Date timestamp) {
        if (timestamp instanceof Timestamp) {
            Timestamp value = (Timestamp)timestamp;
            return com.google.protobuf.Timestamp.newBuilder().setSeconds(value.getTime() / 1000L).setNanos(value.getNanos()).build();
        }
        long millis = timestamp.getTime();
        return com.google.protobuf.Timestamp.newBuilder().setSeconds(millis / 1000L).setNanos((int)(millis % 1000L * 1000000L)).build();
    }

    @Generated
    private ColumnValueConvertUtils() {
    }
}

