/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.queryable;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorConnectionContextAware;
import org.apache.shardingsphere.distsql.handler.engine.DistSQLConnectionContext;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.distsql.statement.ral.queryable.show.ShowDistVariableStatement;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationPropertyKey;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.syntax.UnsupportedVariableException;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPI;
import org.apache.shardingsphere.logging.logger.ShardingSphereLogger;
import org.apache.shardingsphere.logging.rule.LoggingRule;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.common.DistSQLVariable;

public final class ShowDistVariableExecutor
implements DistSQLQueryExecutor<ShowDistVariableStatement>,
DistSQLExecutorConnectionContextAware {
    private DistSQLConnectionContext connectionContext;

    public Collection<String> getColumnNames(ShowDistVariableStatement sqlStatement) {
        return Arrays.asList("variable_name", "variable_value");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowDistVariableStatement sqlStatement, ContextManager contextManager) {
        ShardingSphereMetaData metaData = contextManager.getMetaDataContexts().getMetaData();
        String variableName = sqlStatement.getName();
        if (this.isConfigurationKey(variableName)) {
            return Collections.singleton(new LocalDataQueryResultRow(new Object[]{variableName.toLowerCase(), this.getConfigurationValue(metaData, variableName)}));
        }
        if (this.isTemporaryConfigurationKey(variableName)) {
            return Collections.singleton(new LocalDataQueryResultRow(new Object[]{variableName.toLowerCase(), this.getTemporaryConfigurationValue(metaData, variableName)}));
        }
        return Collections.singleton(new LocalDataQueryResultRow(new Object[]{variableName.toLowerCase(), this.getConnectionSize(variableName)}));
    }

    private boolean isConfigurationKey(String variableName) {
        return ConfigurationPropertyKey.getKeyNames().contains(variableName);
    }

    private String getConfigurationValue(ShardingSphereMetaData metaData, String variableName) {
        return "sql_show".equalsIgnoreCase(variableName) || "sql_simple".equalsIgnoreCase(variableName) ? this.getLoggingPropsValue(metaData, variableName) : this.getStringResult(metaData.getProps().getValue((Enum)ConfigurationPropertyKey.valueOf((String)variableName)));
    }

    private String getLoggingPropsValue(ShardingSphereMetaData metaData, String variableName) {
        Optional sqlLogger = metaData.getGlobalRuleMetaData().findSingleRule(LoggingRule.class).flatMap(LoggingRule::getSQLLogger);
        if (sqlLogger.isPresent()) {
            Properties props = ((ShardingSphereLogger)sqlLogger.get()).getProps();
            switch (variableName) {
                case "sql_show": {
                    return props.getOrDefault((Object)"enable", metaData.getProps().getValue((Enum)ConfigurationPropertyKey.valueOf((String)variableName)).toString()).toString();
                }
                case "sql_simple": {
                    return props.getOrDefault((Object)"simple", metaData.getProps().getValue((Enum)ConfigurationPropertyKey.valueOf((String)variableName)).toString()).toString();
                }
            }
        }
        return this.getStringResult(metaData.getProps().getValue((Enum)ConfigurationPropertyKey.valueOf((String)variableName)));
    }

    private boolean isTemporaryConfigurationKey(String variableName) {
        return TemporaryConfigurationPropertyKey.getKeyNames().contains(variableName);
    }

    private String getTemporaryConfigurationValue(ShardingSphereMetaData metaData, String variableName) {
        return this.getStringResult(metaData.getTemporaryProps().getValue((Enum)TemporaryConfigurationPropertyKey.valueOf((String)variableName)).toString());
    }

    private String getConnectionSize(String variableName) {
        ShardingSpherePreconditions.checkState((DistSQLVariable.CACHED_CONNECTIONS == DistSQLVariable.getValueOf(variableName) ? 1 : 0) != 0, () -> new UnsupportedVariableException(variableName));
        return String.valueOf(this.connectionContext.getConnectionSize());
    }

    private String getStringResult(Object value) {
        if (null == value) {
            return "";
        }
        return value instanceof TypedSPI ? ((TypedSPI)value).getType().toString() : value.toString();
    }

    public Class<ShowDistVariableStatement> getType() {
        return ShowDistVariableStatement.class;
    }

    @Generated
    public void setConnectionContext(DistSQLConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }
}

