/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public class RequestMethodUtils {
    private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();

    public static List<String> getRequestMethodTypes(Method method) {
        if (method.isAnnotationPresent(GetMapping.class)) {
            return List.of("GET");
        }
        if (method.isAnnotationPresent(PostMapping.class)) {
            return List.of("POST");
        }
        if (method.isAnnotationPresent(PutMapping.class)) {
            return List.of("PUT");
        }
        if (method.isAnnotationPresent(DeleteMapping.class)) {
            return List.of("DELETE");
        }
        if (method.isAnnotationPresent(PatchMapping.class)) {
            return List.of("PATCH");
        }
        if (method.isAnnotationPresent(RequestMapping.class)) {
            RequestMapping rm = method.getAnnotation(RequestMapping.class);
            RequestMethod[] requestMethods = rm.method();
            if (requestMethods.length == 0) {
                return List.of("GET", "POST", "PUT", "DELETE", "PATCH", "OPTIONS", "HEAD");
            }
            return Arrays.stream(requestMethods).map(Enum::name).collect(Collectors.toList());
        }
        return List.of();
    }

    public static List<String> getParameterPositions(Method method) {
        ArrayList<String> positions = new ArrayList<String>();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            String position = "query";
            for (Annotation annotation : annotations) {
                if (annotation instanceof PathVariable) {
                    position = "path";
                    break;
                }
                if (annotation instanceof RequestParam) {
                    position = "query";
                    break;
                }
                if (annotation instanceof RequestBody) {
                    position = "body";
                    break;
                }
                if (annotation instanceof RequestHeader) {
                    position = "header";
                    break;
                }
                if (!(annotation instanceof CookieValue)) continue;
                position = "cookie";
                break;
            }
            positions.add(position);
        }
        return positions;
    }

    public static String[] getParameterNames(Method method) {
        Parameter[] parameters = method.getParameters();
        String[] namesFromDiscoverer = PARAMETER_NAME_DISCOVERER.getParameterNames(method);
        String[] result = new String[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            String nameFromAnnotation = RequestMethodUtils.getNameFromSpringAnnotation(parameters[i].getAnnotations());
            result[i] = Objects.nonNull(nameFromAnnotation) && !nameFromAnnotation.isEmpty() ? nameFromAnnotation : (Objects.nonNull(namesFromDiscoverer) && namesFromDiscoverer.length > i ? namesFromDiscoverer[i] : "arg" + i);
        }
        return result;
    }

    private static String getNameFromSpringAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation instanceof RequestParam) {
                RequestParam requestParam = (RequestParam)annotation;
                if (!requestParam.name().isEmpty()) {
                    return requestParam.name();
                }
                if (requestParam.value().isEmpty()) continue;
                return requestParam.value();
            }
            if (annotation instanceof PathVariable) {
                PathVariable pathVariable = (PathVariable)annotation;
                if (!pathVariable.name().isEmpty()) {
                    return pathVariable.name();
                }
                if (pathVariable.value().isEmpty()) continue;
                return pathVariable.value();
            }
            if (annotation instanceof RequestHeader) {
                RequestHeader requestHeader = (RequestHeader)annotation;
                if (!requestHeader.name().isEmpty()) {
                    return requestHeader.name();
                }
                if (requestHeader.value().isEmpty()) continue;
                return requestHeader.value();
            }
            if (!(annotation instanceof CookieValue)) continue;
            CookieValue cookieValue = (CookieValue)annotation;
            if (!cookieValue.name().isEmpty()) {
                return cookieValue.name();
            }
            if (cookieValue.value().isEmpty()) continue;
            return cookieValue.value();
        }
        return null;
    }
}

