/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Locale;
import java.util.Objects;
import org.apache.sis.pending.jdk.Record;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.internal.shared.ReferencingUtilities;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.internal.shared.Strings;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;

final class CRSPair
extends Record {
    final CoordinateReferenceSystem sourceCRS;
    final CoordinateReferenceSystem targetCRS;

    CRSPair(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) {
        this.sourceCRS = sourceCRS;
        this.targetCRS = targetCRS;
    }

    public int hashCode() {
        return Objects.hashCode(this.sourceCRS) * 31 + Objects.hashCode(this.targetCRS);
    }

    public boolean equals(Object object) {
        if (object instanceof CRSPair) {
            CRSPair that = (CRSPair)((Object)object);
            return Objects.equals(this.sourceCRS, that.sourceCRS) && Objects.equals(this.targetCRS, that.targetCRS);
        }
        return false;
    }

    static String label(IdentifiedObject object, Locale locale) {
        Object name;
        String label;
        block10: {
            String suffix;
            block9: {
                if (object == null) {
                    return null;
                }
                label = Classes.getShortName(ReferencingUtilities.getInterface(IdentifiedObject.class, object));
                suffix = "CRS";
                if (label.endsWith("CRS")) break block9;
                suffix = "CS";
                if (!label.endsWith("CS")) break block10;
            }
            IdentifiedObject cs = object;
            if (object instanceof CoordinateReferenceSystem) {
                cs = ((CoordinateReferenceSystem)object).getCoordinateSystem();
            }
            if (cs instanceof EllipsoidalCS) {
                StringBuilder sb = new StringBuilder(label);
                sb.setLength(label.length() - suffix.length());
                label = sb.append(((CoordinateSystem)cs).getDimension()).append('D').toString();
            }
        }
        if ((name = IdentifiedObjects.getDisplayName(object, locale)) != null) {
            int i;
            if (((String)name).length() >= i) {
                int c;
                for (i = 30; i > 15 && !Character.isSpaceChar(c = ((String)name).codePointBefore(i)); i -= Character.charCount(c)) {
                }
                name = CharSequences.trimWhitespaces((CharSequence)name, (int)0, (int)i).toString() + "\u2026";
            }
            label = Strings.bracket((String)label, (Object)name);
        }
        return label;
    }

    public String toString() {
        return CRSPair.label((IdentifiedObject)this.sourceCRS, null) + " \u27f6 " + CRSPair.label((IdentifiedObject)this.targetCRS, null);
    }
}

