/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Sort;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TraceScopeCondition;
import org.apache.skywalking.oap.server.core.query.type.ContentType;
import org.apache.skywalking.oap.server.core.query.type.Log;
import org.apache.skywalking.oap.server.core.query.type.Logs;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.MatchCNameBuilder;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.TimeRangeIndexNameGenerator;

public class LogQueryEsDAO
extends EsDAO
implements ILogQueryDAO {
    public LogQueryEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public boolean supportQueryLogsByKeywords() {
        return true;
    }

    public Logs queryLogs(String serviceId, String serviceInstanceId, String endpointId, TraceScopeCondition relatedTrace, Order queryOrder, int from, int limit, Duration duration, List<Tag> tags, List<String> keywordsOfContent, List<String> excludingKeywordsOfContent) throws IOException {
        long startSecondTB = 0L;
        long endSecondTB = 0L;
        if (Objects.nonNull(duration)) {
            startSecondTB = duration.getStartTimeBucketInSec();
            endSecondTB = duration.getEndTimeBucketInSec();
        }
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isMergedTable("log")) {
            query.must((QueryBuilder)Query.term((String)"record_table", (Object)"log"));
        }
        if (startSecondTB != 0L && endSecondTB != 0L) {
            query.must((QueryBuilder)Query.range((String)"time_bucket").gte((Object)startSecondTB).lte((Object)endSecondTB));
        }
        if (StringUtil.isNotEmpty((String)serviceId)) {
            query.must((QueryBuilder)Query.term((String)"service_id", (Object)serviceId));
        }
        if (StringUtil.isNotEmpty((String)serviceInstanceId)) {
            query.must((QueryBuilder)Query.term((String)"service_instance_id", (Object)serviceInstanceId));
        }
        if (StringUtil.isNotEmpty((String)endpointId)) {
            query.must((QueryBuilder)Query.term((String)"endpoint_id", (Object)endpointId));
        }
        if (Objects.nonNull(relatedTrace)) {
            if (StringUtil.isNotEmpty((String)relatedTrace.getTraceId())) {
                query.must((QueryBuilder)Query.term((String)"trace_id", (Object)relatedTrace.getTraceId()));
            }
            if (StringUtil.isNotEmpty((String)relatedTrace.getSegmentId())) {
                query.must((QueryBuilder)Query.term((String)"trace_segment_id", (Object)relatedTrace.getSegmentId()));
            }
            if (Objects.nonNull(relatedTrace.getSpanId())) {
                query.must((QueryBuilder)Query.term((String)"span_id", (Object)relatedTrace.getSpanId()));
            }
        }
        if (CollectionUtils.isNotEmpty(tags)) {
            tags.forEach(tag -> query.must((QueryBuilder)Query.term((String)"tags", (Object)tag.toString())));
        }
        if (CollectionUtils.isNotEmpty(keywordsOfContent)) {
            keywordsOfContent.forEach(content -> query.must((QueryBuilder)Query.matchPhrase((String)MatchCNameBuilder.INSTANCE.build("content"), (String)content)));
        }
        if (CollectionUtils.isNotEmpty(excludingKeywordsOfContent)) {
            excludingKeywordsOfContent.forEach(content -> query.mustNot((QueryBuilder)Query.matchPhrase((String)MatchCNameBuilder.INSTANCE.build("content"), (String)content)));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).sort("timestamp", Order.DES.equals((Object)queryOrder) ? Sort.Order.DESC : Sort.Order.ASC).size(Integer.valueOf(limit)).from(Integer.valueOf(from));
        SearchResponse response = this.searchDebuggable(new TimeRangeIndexNameGenerator(IndexController.LogicIndicesRegister.getPhysicalTableName("log"), startSecondTB, endSecondTB), search.build());
        Logs logs = new Logs();
        for (SearchHit searchHit : response.getHits().getHits()) {
            Log log = new Log();
            log.setServiceId((String)searchHit.getSource().get("service_id"));
            log.setServiceInstanceId((String)searchHit.getSource().get("service_instance_id"));
            log.setEndpointId((String)searchHit.getSource().get("endpoint_id"));
            if (log.getEndpointId() != null) {
                log.setEndpointName(IDManager.EndpointID.analysisId((String)log.getEndpointId()).getEndpointName());
            }
            log.setTraceId((String)searchHit.getSource().get("trace_id"));
            log.setTimestamp(Long.valueOf(((Number)searchHit.getSource().get("timestamp")).longValue()));
            log.setContentType(ContentType.instanceOf((int)((Number)searchHit.getSource().get("content_type")).intValue()));
            log.setContent((String)searchHit.getSource().get("content"));
            String dataBinaryBase64 = (String)searchHit.getSource().get("tags_raw_data");
            if (!Strings.isNullOrEmpty((String)dataBinaryBase64)) {
                this.parserDataBinary(dataBinaryBase64, log.getTags());
            }
            logs.getLogs().add(log);
        }
        return logs;
    }
}

