/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.generator;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.apache.skywalking.generator.Generator;

@JsonDeserialize(builder=Builder.class)
public final class IntGenerator
implements Generator<Object, Long> {
    private final boolean limitedDomain;
    private final Long min;
    private final Long max;
    private final Integer domainSize;
    private final ThreadLocalRandom random = ThreadLocalRandom.current();
    private final Set<Long> domain = new HashSet<Long>();

    public IntGenerator(Builder builder) {
        this.min = builder.min;
        this.max = builder.max;
        this.domainSize = builder.domainSize;
        this.limitedDomain = builder.domainSize != null && builder.domainSize > 0;
        this.reset();
    }

    @Override
    public Long next(Object ignored) {
        if (!this.limitedDomain) {
            return this.next0();
        }
        return (Long)this.domain.stream().skip(this.random.nextInt(this.domain.size())).findFirst().orElseThrow(() -> new RuntimeException("Should never happen"));
    }

    @Override
    public void reset() {
        if (this.limitedDomain) {
            this.domain.clear();
            while (this.domain.size() < this.domainSize) {
                this.domain.add(this.next0());
            }
        }
    }

    private long next0() {
        if (this.min != null && this.max != null) {
            return this.random.nextLong(this.max - this.min + 1L) + this.min;
        }
        if (this.min != null) {
            return Math.abs(this.random.nextLong()) + this.min;
        }
        return this.random.nextLong(this.max);
    }

    public String toString() {
        return String.valueOf(this.next((Object)null));
    }

    public static class Builder {
        private Long min;
        private Long max;
        private Integer domainSize;

        public IntGenerator build() {
            if (this.min != null && this.max != null) {
                Preconditions.checkArgument((this.min <= this.max ? 1 : 0) != 0, (Object)"min must be <= max");
                if (this.domainSize != null) {
                    Preconditions.checkArgument(((long)this.domainSize.intValue() <= this.max - this.min ? 1 : 0) != 0, (Object)"domain size must be <= max - min");
                }
            }
            return new IntGenerator(this);
        }

        @Generated
        public Builder() {
        }

        @Generated
        public Long getMin() {
            return this.min;
        }

        @Generated
        public Long getMax() {
            return this.max;
        }

        @Generated
        public Integer getDomainSize() {
            return this.domainSize;
        }

        @Generated
        public void setMin(Long min) {
            this.min = min;
        }

        @Generated
        public void setMax(Long max) {
            this.max = max;
        }

        @Generated
        public void setDomainSize(Integer domainSize) {
            this.domainSize = domainSize;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$min = this.getMin();
            Long other$min = other.getMin();
            if (this$min == null ? other$min != null : !((Object)this$min).equals(other$min)) {
                return false;
            }
            Long this$max = this.getMax();
            Long other$max = other.getMax();
            if (this$max == null ? other$max != null : !((Object)this$max).equals(other$max)) {
                return false;
            }
            Integer this$domainSize = this.getDomainSize();
            Integer other$domainSize = other.getDomainSize();
            return !(this$domainSize == null ? other$domainSize != null : !((Object)this$domainSize).equals(other$domainSize));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $min = this.getMin();
            result = result * 59 + ($min == null ? 43 : ((Object)$min).hashCode());
            Long $max = this.getMax();
            result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
            Integer $domainSize = this.getDomainSize();
            result = result * 59 + ($domainSize == null ? 43 : ((Object)$domainSize).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "IntGenerator.Builder(min=" + this.getMin() + ", max=" + this.getMax() + ", domainSize=" + this.getDomainSize() + ")";
        }
    }
}

