/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.time;

import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.jackrabbit.oak.commons.conditions.Validate;

public final class Stopwatch {
    private long startTime;
    private long accumulated;
    private boolean running;
    private final Supplier<Long> ticker;

    private Stopwatch(Supplier<Long> ticker) {
        this.ticker = ticker;
        this.accumulated = 0L;
        this.startTime = ticker.get();
        this.running = false;
    }

    public static Stopwatch createStarted() {
        return new Stopwatch(Stopwatch::tick).start();
    }

    public static Stopwatch createStarted(Supplier<Long> ticker) {
        return new Stopwatch(ticker).start();
    }

    public static Stopwatch createStarted(Clock clock) {
        return new Stopwatch(Stopwatch.clockAsLongSupplier(clock)).start();
    }

    public static Stopwatch createUnstarted(Supplier<Long> ticker) {
        return new Stopwatch(ticker);
    }

    public static Stopwatch createUnstarted() {
        return new Stopwatch(Stopwatch::tick);
    }

    public Stopwatch start() {
        Validate.checkState(!this.running, "Stopwatch already running.");
        this.startTime = this.ticker.get();
        this.running = true;
        return this;
    }

    public Stopwatch stop() {
        Validate.checkState(this.running, "Stopwatch not running.");
        this.accumulated += this.elapsedNanos();
        this.startTime = 0L;
        this.running = false;
        return this;
    }

    public Stopwatch reset() {
        this.accumulated = 0L;
        this.startTime = 0L;
        this.running = false;
        return this;
    }

    public boolean isRunning() {
        return this.running;
    }

    public long elapsed(TimeUnit timeunit) {
        return timeunit.convert(this.elapsedNanos(), TimeUnit.NANOSECONDS);
    }

    public Duration elapsed() {
        return Duration.ofNanos(this.elapsedNanos());
    }

    public String toString() {
        return Duration.ofNanos(this.elapsedNanos()).toString();
    }

    private long elapsedNanos() {
        long delta = this.running ? this.ticker.get() - this.startTime : 0L;
        return this.accumulated + delta;
    }

    private static long tick() {
        return System.nanoTime();
    }

    private static Supplier<Long> clockAsLongSupplier(Clock clock) {
        return () -> TimeUnit.MILLISECONDS.toNanos(clock.millis());
    }
}

