/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import java.io.File;
import java.io.IOException;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.jmx.IndexerMBean;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexInfoService;
import org.apache.jackrabbit.oak.plugins.index.WhiteboardIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.importer.AbortingIndexerLock;
import org.apache.jackrabbit.oak.plugins.index.importer.AsyncIndexerLock;
import org.apache.jackrabbit.oak.plugins.index.importer.ClusterNodeStoreLock;
import org.apache.jackrabbit.oak.plugins.index.importer.IndexImporter;
import org.apache.jackrabbit.oak.plugins.index.importer.IndexImporterProvider;
import org.apache.jackrabbit.oak.spi.state.Clusterable;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Tracker;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={})
public class IndexerMBeanImpl
extends AnnotatedStandardMBean
implements IndexerMBean {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private NodeStore nodeStore;
    @Reference
    private AsyncIndexInfoService asyncIndexInfoService;
    private WhiteboardIndexEditorProvider editorProvider = new WhiteboardIndexEditorProvider();
    private Registration mbeanReg;
    private Tracker<IndexImporterProvider> providerTracker;

    public IndexerMBeanImpl() {
        super(IndexerMBean.class);
    }

    @Override
    public boolean importIndex(String indexDirPath) throws IOException, CommitFailedException {
        return this.importIndex(indexDirPath, false);
    }

    @Override
    public boolean importIndex(String indexDirPath, boolean ignoreLocalLock) throws IOException, CommitFailedException {
        try {
            IndexImporter importer = new IndexImporter(this.nodeStore, new File(indexDirPath), this.editorProvider, this.createLock(ignoreLocalLock));
            this.providerTracker.getServices().forEach(importer::addImporterProvider);
            importer.importIndex();
        }
        catch (IOException | RuntimeException | CommitFailedException e) {
            this.log.warn("Error occurred while importing index from path [{}]", (Object)indexDirPath, (Object)e);
            throw e;
        }
        return true;
    }

    private AsyncIndexerLock createLock(boolean ignoreLocalLock) {
        if (this.nodeStore instanceof Clusterable) {
            return new ClusterNodeStoreLock(this.nodeStore);
        }
        if (!ignoreLocalLock) {
            return new AbortingIndexerLock(this.asyncIndexInfoService);
        }
        return AsyncIndexerLock.NOOP_LOCK;
    }

    @Activate
    private void activate(BundleContext context) {
        OsgiWhiteboard wb = new OsgiWhiteboard(context);
        this.editorProvider.start(wb);
        this.mbeanReg = WhiteboardUtils.registerMBean(wb, IndexerMBean.class, this, "Indexer", "Indexer operations related MBean");
        this.providerTracker = wb.track(IndexImporterProvider.class);
    }

    @Deactivate
    private void deactivate() {
        if (this.mbeanReg != null) {
            this.mbeanReg.unregister();
        }
        this.editorProvider.stop();
        if (this.providerTracker != null) {
            this.providerTracker.stop();
        }
    }
}

