/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.variant;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Generator;
import org.apache.spark.sql.catalyst.expressions.variant.VariantExplodeOuterGeneratorBuilder$;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import scala.Function2;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ExpressionDescription(usage="_FUNC_(expr) - It separates a variant object/array into multiple rows containing its fields/elements. Its result schema is `struct<pos int, key string, value variant>`. `pos` is the position of the field/element in its parent object/array, and `value` is the field/element value. `key` is the field name when exploding a variant object, or is NULL when exploding a variant array. It ignores any input that is not a variant array/object, including SQL NULL, variant null, and any other variant values.", examples="\n    Examples:\n      > SELECT * from _FUNC_(parse_json('[\"hello\", \"world\"]'));\n       0\tNULL\t\"hello\"\n       1\tNULL\t\"world\"\n      > SELECT * from _FUNC_(input => parse_json('{\"a\": true, \"b\": 3.14}'));\n       0\ta\ttrue\n       1\tb\t3.14\n  ", since="4.0.0", group="variant_funcs")
@ScalaSignature(bytes="\u0006\u0005i:Q\u0001B\u0003\t\u0002Q1QAF\u0003\t\u0002]AQ!I\u0001\u0005\u0002\tBQaI\u0001\u0005B\u0011\n1EV1sS\u0006tG/\u0012=qY>$WmT;uKJ<UM\\3sCR|'OQ;jY\u0012,'O\u0003\u0002\u0007\u000f\u00059a/\u0019:jC:$(B\u0001\u0005\n\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005)Y\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u00051i\u0011aA:rY*\u0011abD\u0001\u0006gB\f'o\u001b\u0006\u0003!E\ta!\u00199bG\",'\"\u0001\n\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005U\tQ\"A\u0003\u0003GY\u000b'/[1oi\u0016C\b\u000f\\8eK>+H/\u001a:HK:,'/\u0019;pe\n+\u0018\u000e\u001c3feN\u0019\u0011\u0001\u0007\u0010\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g!\t)r$\u0003\u0002!\u000b\t\u0011c+\u0019:jC:$X\t\u001f9m_\u0012,w)\u001a8fe\u0006$xN\u001d\"vS2$WM\u001d\"bg\u0016\fa\u0001P5oSRtD#\u0001\u000b\u0002\u000f%\u001cx*\u001e;feV\tQ\u0005\u0005\u0002\u001aM%\u0011qE\u0007\u0002\b\u0005>|G.Z1oQ)\t\u0011&\f\u00181cM\"dg\u000e\t\u0003U-j\u0011aB\u0005\u0003Y\u001d\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-I\u00010\u0003\r%xLR+O\u0007~CS\r\u001f9sS\u0001j\u0003%\u0013;!g\u0016\u0004\u0018M]1uKN\u0004\u0013\r\t<be&\fg\u000e\u001e\u0011pE*,7\r^\u0018beJ\f\u0017\u0010I5oi>\u0004S.\u001e7uSBdW\r\t:poN\u00043m\u001c8uC&t\u0017N\\4!SR\u001c\bEZ5fY\u0012\u001cx&\u001a7f[\u0016tGo\u001d\u0018!\u0013R\u001c\bE]3tk2$\be]2iK6\f\u0007%[:!AN$(/^2uyA|7\u000fI5oi2\u00023.Z=!gR\u0014\u0018N\\4-AY\fG.^3!m\u0006\u0014\u0018.\u00198u}\u0001t\u0003\u0005\u00199pg\u0002\u0004\u0013n\u001d\u0011uQ\u0016\u0004\u0003o\\:ji&|g\u000eI8gAQDW\r\t4jK2$w&\u001a7f[\u0016tG\u000fI5oA%$8\u000f\t9be\u0016tG\u000fI8cU\u0016\u001cGoL1se\u0006LH\u0006I1oI\u0002\u0002g/\u00197vK\u0002\u0004\u0013n\u001d\u0011uQ\u0016\u0004c-[3mI>*G.Z7f]R\u0004c/\u00197vK:\u0002\u0003m[3zA\u0002J7\u000f\t;iK\u00022\u0017.\u001a7eA9\fW.\u001a\u0011xQ\u0016t\u0007%\u001a=qY>$\u0017N\\4!C\u00022\u0018M]5b]R\u0004sN\u00196fGRd\u0003e\u001c:!SN\u0004c*\u0016'MA]DWM\u001c\u0011fqBdw\u000eZ5oO\u0002\n\u0007E^1sS\u0006tG\u000fI1se\u0006Lh\u0006I%uA%<gn\u001c:fg\u0002\ng.\u001f\u0011j]B,H\u000f\t;iCR\u0004\u0013n\u001d\u0011o_R\u0004\u0013\r\t<be&\fg\u000e\u001e\u0011beJ\f\u0017pL8cU\u0016\u001cG\u000f\f\u0011j]\u000edW\u000fZ5oO\u0002\u001a\u0016\u000b\u0014\u0011O+2cE\u0006\t<be&\fg\u000e\u001e\u0011ok2dG\u0006I1oI\u0002\ng.\u001f\u0011pi\",'\u000f\t<be&\fg\u000e\u001e\u0011wC2,Xm\u001d\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f\u0013AM\u0001\u0002V*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003#\u0006\t4s_6\u0004sLR+O\u0007~C\u0003/\u0019:tK~S7o\u001c8)Om\u0013\u0003.\u001a7m_\nb\u0003EI<pe2$'%X\u0014*SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003'\u0003(V\u00192K!\u0005[3mY>\u0014#\u0002\t\u0011!A\u0001\u0002\u0003%M\u0005O+2c\u0015BI<pe2$'E\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011+A\u0019\u0014x.\u001c\u0011`\rVs5i\u0018\u0015j]B,H\u000fI\u001f?AA\f'o]3`UN|g\u000eK\u0014|E\u0005\u0014#\b\t;sk\u0016d\u0003E\t2#u\u0001\u001ad&\r\u001b~O%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0019\nC&!(/^3\u000bA\u0001\u0002\u0003\u0005\t\u0011!c%\u0011\u0017b\r\u00182i)\u0001\u0003%A\u0003tS:\u001cW-I\u00016\u0003\u0015!d\u0006\r\u00181\u0003\u00159'o\\;qC\u0005A\u0014!\u0004<be&\fg\u000e^0gk:\u001c7\u000f\u000b\u0006\u0001S5r\u0003'M\u001a5m]\u0002")
public final class VariantExplodeOuterGeneratorBuilder {
    public static boolean isOuter() {
        return VariantExplodeOuterGeneratorBuilder$.MODULE$.isOuter();
    }

    public static Generator buildGenerator(String funcName, Seq<Expression> expressions) {
        return VariantExplodeOuterGeneratorBuilder$.MODULE$.buildGenerator(funcName, expressions);
    }

    public static Option<FunctionSignature> functionSignature() {
        return VariantExplodeOuterGeneratorBuilder$.MODULE$.functionSignature();
    }

    public static LogicalPlan build(String funcName, Seq<Expression> expressions) {
        return VariantExplodeOuterGeneratorBuilder$.MODULE$.build(funcName, (Seq)expressions);
    }

    public static boolean supportsLambda() {
        return VariantExplodeOuterGeneratorBuilder$.MODULE$.supportsLambda();
    }

    public static Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName, Function2<String, String, Object> resolver) {
        return VariantExplodeOuterGeneratorBuilder$.MODULE$.rearrange(expectedSignature, providedArguments, functionName, resolver);
    }
}

