% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mllib_classification.R
\name{spark.fmClassifier}
\alias{spark.fmClassifier}
\alias{spark.fmClassifier,SparkDataFrame,formula-method}
\alias{summary,FMClassificationModel-method}
\alias{predict,FMClassificationModel-method}
\alias{predict,FMClassificationModel,SparkDataFrame-method}
\alias{write.ml,FMClassificationModel,character-method}
\title{Factorization Machines Classification Model}
\usage{
spark.fmClassifier(data, formula, ...)

\S4method{spark.fmClassifier}{SparkDataFrame,formula}(
  data,
  formula,
  factorSize = 8,
  fitLinear = TRUE,
  regParam = 0,
  miniBatchFraction = 1,
  initStd = 0.01,
  maxIter = 100,
  stepSize = 1,
  tol = 1e-06,
  solver = c("adamW", "gd"),
  thresholds = NULL,
  seed = NULL,
  handleInvalid = c("error", "keep", "skip")
)

\S4method{summary}{FMClassificationModel}(object)

\S4method{predict}{FMClassificationModel}(object, newData)

\S4method{write.ml}{FMClassificationModel,character}(object, path, overwrite = FALSE)
}
\arguments{
\item{data}{a \code{SparkDataFrame} of observations and labels for model fitting.}

\item{formula}{a symbolic description of the model to be fitted. Currently only a few formula
operators are supported, including '~', '.', ':', '+', and '-'.}

\item{...}{additional arguments passed to the method.}

\item{factorSize}{dimensionality of the factors.}

\item{fitLinear}{whether to fit linear term.  # TODO Can we express this with formula?}

\item{regParam}{the regularization parameter.}

\item{miniBatchFraction}{the mini-batch fraction parameter.}

\item{initStd}{the standard deviation of initial coefficients.}

\item{maxIter}{maximum iteration number.}

\item{stepSize}{stepSize parameter.}

\item{tol}{convergence tolerance of iterations.}

\item{solver}{solver parameter, supported options: "gd" (minibatch gradient descent) or "adamW".}

\item{thresholds}{in binary classification, in range [0, 1]. If the estimated probability of
class label 1 is > threshold, then predict 1, else 0. A high threshold
encourages the model to predict 0 more often; a low threshold encourages the
model to predict 1 more often. Note: Setting this with threshold p is
equivalent to setting thresholds c(1-p, p).}

\item{seed}{seed parameter for weights initialization.}

\item{handleInvalid}{How to handle invalid data (unseen labels or NULL values) in features and
label column of string type.
Supported options: "skip" (filter out rows with invalid data),
                   "error" (throw an error), "keep" (put invalid data in
                   a special additional bucket, at index numLabels). Default
                   is "error".}

\item{object}{a FM Classification model fitted by \code{spark.fmClassifier}.}

\item{newData}{a SparkDataFrame for testing.}

\item{path}{The directory where the model is saved.}

\item{overwrite}{Overwrites or not if the output path already exists. Default is FALSE
which means throw exception if the output path exists.}
}
\value{
\code{spark.fmClassifier} returns a fitted Factorization Machines Classification Model.

\code{summary} returns summary information of the fitted model, which is a list.

\code{predict} returns the predicted values based on a FM Classification model.
}
\description{
\code{spark.fmClassifier} fits a factorization classification model against a SparkDataFrame.
Users can call \code{summary} to print a summary of the fitted model, \code{predict} to make
predictions on new data, and \code{write.ml}/\code{read.ml} to save/load fitted models.
Only categorical data is supported.
}
\note{
spark.fmClassifier since 3.1.0

summary(FMClassificationModel) since 3.1.0

predict(FMClassificationModel) since 3.1.0

write.ml(FMClassificationModel, character) since 3.1.0
}
\examples{
\dontrun{
df <- read.df("data/mllib/sample_binary_classification_data.txt", source = "libsvm")

# fit Factorization Machines Classification Model
model <- spark.fmClassifier(
           df, label ~ features,
           regParam = 0.01, maxIter = 10, fitLinear = TRUE
         )

# get the summary of the model
summary(model)

# make predictions
predictions <- predict(model, df)

# save and load the model
path <- "path/to/model"
write.ml(model, path)
savedModel <- read.ml(path)
summary(savedModel)
}
}
\seealso{
\link{read.ml}
}
