/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.repository.internal;

import java.io.File;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.repository.RepositoryManagerException;
import org.apache.maven.shared.transfer.repository.internal.Invoker;
import org.apache.maven.shared.transfer.repository.internal.MavenRepositoryManager;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;

class Maven31RepositoryManager
implements MavenRepositoryManager {
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession session;

    Maven31RepositoryManager(RepositorySystem repositorySystem, RepositorySystemSession session) {
        this.repositorySystem = repositorySystem;
        this.session = session;
    }

    @Override
    public String getPathForLocalArtifact(org.apache.maven.artifact.Artifact mavenArtifact) {
        Artifact aetherArtifact;
        try {
            aetherArtifact = (Artifact)Invoker.invoke(RepositoryUtils.class, "toArtifact", org.apache.maven.artifact.Artifact.class, (Object)mavenArtifact);
        }
        catch (RepositoryManagerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.session.getLocalRepositoryManager().getPathForLocalArtifact(aetherArtifact);
    }

    @Override
    public String getPathForLocalArtifact(ArtifactCoordinate coordinate) {
        Artifact aetherArtifact = this.toArtifact(coordinate);
        return this.session.getLocalRepositoryManager().getPathForLocalArtifact(aetherArtifact);
    }

    @Override
    public String getPathForLocalMetadata(ArtifactMetadata metadata) {
        DefaultMetadata aetherMetadata = new DefaultMetadata(metadata.getGroupId(), metadata.storedInGroupDirectory() ? null : metadata.getArtifactId(), metadata.storedInArtifactVersionDirectory() ? metadata.getBaseVersion() : null, "maven-metadata.xml", Metadata.Nature.RELEASE_OR_SNAPSHOT);
        return this.session.getLocalRepositoryManager().getPathForLocalMetadata((Metadata)aetherMetadata);
    }

    @Override
    public ProjectBuildingRequest setLocalRepositoryBasedir(ProjectBuildingRequest buildingRequest, File basedir) {
        RepositorySystemSession session;
        DefaultProjectBuildingRequest newRequest = new DefaultProjectBuildingRequest(buildingRequest);
        try {
            session = (RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
        }
        catch (RepositoryManagerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        DefaultRepositorySystemSession newSession = new DefaultRepositorySystemSession(session);
        newSession.setCache((RepositoryCache)new DefaultRepositoryCache());
        String repositoryType = this.resolveRepositoryType(session.getLocalRepository());
        LocalRepositoryManager localRepositoryManager = this.repositorySystem.newLocalRepositoryManager((RepositorySystemSession)newSession, new LocalRepository(basedir, repositoryType));
        newSession.setLocalRepositoryManager(localRepositoryManager);
        try {
            Invoker.invoke(newRequest, "setRepositorySession", RepositorySystemSession.class, (Object)newSession);
        }
        catch (RepositoryManagerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return newRequest;
    }

    @Override
    public File getLocalRepositoryBasedir() {
        return this.session.getLocalRepository().getBasedir();
    }

    protected String resolveRepositoryType(LocalRepository localRepository) {
        String repositoryType = "enhanced".equals(localRepository.getContentType()) ? "default" : localRepository.getContentType();
        return repositoryType;
    }

    protected Artifact toArtifact(ArtifactCoordinate coordinate) {
        if (coordinate == null) {
            return null;
        }
        DefaultArtifact result = new DefaultArtifact(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getClassifier(), coordinate.getExtension(), coordinate.getVersion());
        return result;
    }
}

