/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.AbstractSwaggerUiConfigProperties;
import org.springdoc.core.SpringDocConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Lazy(value=false)
@Configuration(proxyBeanMethods=false)
@ConfigurationProperties(prefix="springdoc.swagger-ui")
@ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={SpringDocConfiguration.class})
public class SwaggerUiConfigProperties
extends AbstractSwaggerUiConfigProperties {
    private boolean disableSwaggerDefaultUrl;
    private String version;
    private Csrf csrf = new Csrf();
    private SyntaxHighlight syntaxHighlight = new SyntaxHighlight();
    private boolean enabled = true;
    private boolean useRootPath;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isUseRootPath() {
        return this.useRootPath;
    }

    public void setUseRootPath(boolean useRootPath) {
        this.useRootPath = useRootPath;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isDisableSwaggerDefaultUrl() {
        return this.disableSwaggerDefaultUrl;
    }

    public void setDisableSwaggerDefaultUrl(boolean disableSwaggerDefaultUrl) {
        this.disableSwaggerDefaultUrl = disableSwaggerDefaultUrl;
    }

    public Csrf getCsrf() {
        return this.csrf;
    }

    public void setCsrf(Csrf csrf) {
        this.csrf = csrf;
    }

    public boolean isCsrfEnabled() {
        return this.csrf.isEnabled();
    }

    public SyntaxHighlight getSyntaxHighlight() {
        return this.syntaxHighlight;
    }

    public void setSyntaxHighlight(SyntaxHighlight syntaxHighlight) {
        this.syntaxHighlight = syntaxHighlight;
    }

    public Set<AbstractSwaggerUiConfigProperties.SwaggerUrl> cloneUrls() {
        return this.urls.stream().map(swaggerUrl -> new AbstractSwaggerUiConfigProperties.SwaggerUrl(swaggerUrl.getName(), swaggerUrl.getUrl(), swaggerUrl.getDisplayName())).collect(Collectors.toSet());
    }

    public static class SyntaxHighlight {
        private Boolean activated;
        private String theme;

        public Boolean getActivated() {
            return this.activated;
        }

        public void setActivated(Boolean activated) {
            this.activated = activated;
        }

        public String getTheme() {
            return this.theme;
        }

        public void setTheme(String theme) {
            this.theme = theme;
        }

        public boolean isPresent() {
            return this.activated != null || StringUtils.isNotEmpty((CharSequence)this.theme);
        }
    }

    public static class Csrf {
        private boolean enabled;
        private boolean useLocalStorage;
        private boolean useSessionStorage;
        private String cookieName = "XSRF-TOKEN";
        private String localStorageKey = "XSRF-TOKEN";
        private String sessionStorageKey = "XSRF-TOKEN";
        private String headerName = "X-XSRF-TOKEN";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isUseLocalStorage() {
            return this.useLocalStorage;
        }

        public boolean isUseSessionStorage() {
            return this.useSessionStorage;
        }

        public void setUseLocalStorage(boolean useLocalStorage) {
            this.useLocalStorage = useLocalStorage;
        }

        public void setUseSessionStorage(boolean useSessionStorage) {
            this.useSessionStorage = useSessionStorage;
        }

        public String getCookieName() {
            return this.cookieName;
        }

        public void setCookieName(String cookieName) {
            this.cookieName = cookieName;
        }

        public String getLocalStorageKey() {
            return this.localStorageKey;
        }

        public String getSessionStorageKey() {
            return this.sessionStorageKey;
        }

        public void setLocalStorageKey(String localStorageKey) {
            this.localStorageKey = localStorageKey;
        }

        public void setSessionStorageKey(String sessionStorageKey) {
            this.sessionStorageKey = sessionStorageKey;
        }

        public String getHeaderName() {
            return this.headerName;
        }

        public void setHeaderName(String headerName) {
            this.headerName = headerName;
        }
    }
}

