/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.aspect;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.core.annotation.ApiAccess;
import org.apache.streampark.console.core.annotation.PermissionAction;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.enums.PermissionType;
import org.apache.streampark.console.core.enums.UserType;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.ServiceHelper;
import org.apache.streampark.console.core.task.FlinkAppHttpWatcher;
import org.apache.streampark.console.system.entity.Member;
import org.apache.streampark.console.system.entity.User;
import org.apache.streampark.console.system.service.MemberService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class StreamParkAspect {
    private static final Logger log = LoggerFactory.getLogger(StreamParkAspect.class);
    @Autowired
    private FlinkAppHttpWatcher flinkAppHttpWatcher;
    @Autowired
    private ServiceHelper serviceHelper;
    @Autowired
    private MemberService memberService;
    @Autowired
    private ApplicationService applicationService;

    @Pointcut(value="execution(public org.apache.streampark.console.base.domain.RestResponse org.apache.streampark.console.*.controller.*.*(..))")
    public void apiAccess() {
    }

    @Around(value="apiAccess()")
    public RestResponse apiAccess(ProceedingJoinPoint joinPoint) throws Throwable {
        ApiAccess apiAccess;
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        log.debug("restResponse aspect, method:{}", (Object)methodSignature.getName());
        Boolean isApi = (Boolean)SecurityUtils.getSubject().getSession().getAttribute((Object)"is_api_token");
        if (Objects.nonNull(isApi) && isApi.booleanValue() && (Objects.isNull(apiAccess = methodSignature.getMethod().getAnnotation(ApiAccess.class)) || !apiAccess.value())) {
            throw new ApiAlertException("api accessToken authentication failed!");
        }
        return (RestResponse)joinPoint.proceed();
    }

    @Pointcut(value="@annotation(org.apache.streampark.console.core.annotation.AppUpdated)")
    public void appUpdated() {
    }

    @Around(value="appUpdated()")
    public Object appUpdated(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        log.debug("appUpdated aspect, method:{}", (Object)methodSignature.getName());
        Object target = joinPoint.proceed();
        this.flinkAppHttpWatcher.initialize();
        return target;
    }

    @Pointcut(value="@annotation(org.apache.streampark.console.core.annotation.PermissionAction)")
    public void permissionAction() {
    }

    @Around(value="permissionAction()")
    public RestResponse permissionAction(ProceedingJoinPoint joinPoint) throws Throwable {
        boolean isAdmin;
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        PermissionAction permissionAction = methodSignature.getMethod().getAnnotation(PermissionAction.class);
        User currentUser = this.serviceHelper.getLoginUser();
        ApiAlertException.throwIfNull(currentUser, "Permission denied, please login first.");
        boolean bl = isAdmin = currentUser.getUserType() == UserType.ADMIN;
        if (!isAdmin) {
            PermissionType permissionType = permissionAction.type();
            Long paramId = this.getParamId(joinPoint, methodSignature, permissionAction.id());
            switch (permissionType) {
                case USER: {
                    ApiAlertException.throwIfTrue(!currentUser.getUserId().equals(paramId), "Permission denied, only user himself can access this permission");
                    break;
                }
                case TEAM: {
                    Member member = this.memberService.findByUserName(paramId, currentUser.getUsername());
                    ApiAlertException.throwIfTrue(member == null, "Permission denied, only user belongs to this team can access this permission");
                    break;
                }
                case APP: {
                    Application app = (Application)this.applicationService.getById(paramId);
                    ApiAlertException.throwIfTrue(app == null, "Invalid operation, application is null");
                    Member member = this.memberService.findByUserName(app.getTeamId(), currentUser.getUsername());
                    ApiAlertException.throwIfTrue(member == null, "Permission denied, only user belongs to this team can access this permission");
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Permission type %s is not supported.", new Object[]{permissionType}));
                }
            }
        }
        return (RestResponse)joinPoint.proceed();
    }

    private Long getParamId(ProceedingJoinPoint joinPoint, MethodSignature methodSignature, String spELString) {
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression expression = parser.parseExpression(spELString);
        StandardEvaluationContext context = new StandardEvaluationContext();
        Object[] args = joinPoint.getArgs();
        DefaultParameterNameDiscoverer discoverer = new DefaultParameterNameDiscoverer();
        String[] parameterNames = discoverer.getParameterNames(methodSignature.getMethod());
        for (int i = 0; i < parameterNames.length; ++i) {
            context.setVariable(parameterNames[i], args[i]);
        }
        Object value = expression.getValue((EvaluationContext)context);
        if (value == null || StringUtils.isBlank((CharSequence)value.toString())) {
            return null;
        }
        try {
            return Long.parseLong(value.toString());
        }
        catch (NumberFormatException e) {
            throw new ApiAlertException("Wrong use of annotation on method " + methodSignature.getName(), e);
        }
    }
}

