/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.plugable;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class SerializationDelegate<T>
implements IOReadableWritable {
    private T instance;
    private final TypeSerializer<T> serializer;

    public SerializationDelegate(TypeSerializer<T> serializer) {
        this.serializer = serializer;
    }

    public void setInstance(T instance) {
        this.instance = instance;
    }

    public T getInstance() {
        return this.instance;
    }

    public void write(DataOutputView out) throws IOException {
        this.serializer.serialize(this.instance, out);
    }

    public void read(DataInputView in) throws IOException {
        throw new IllegalStateException("Deserialization method called on SerializationDelegate.");
    }
}

