/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import java.util.Arrays;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.DenseBlockDRB;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public class DenseBlockFP64
extends DenseBlockDRB {
    private static final long serialVersionUID = 8546723684649816489L;
    private double[] _data;

    public DenseBlockFP64(int[] dims) {
        super(dims);
        this.resetNoFill(this._rlen, this._odims);
    }

    @Override
    protected void allocateBlock(int bix, int length) {
        this._data = new double[length];
    }

    public DenseBlockFP64(int[] dims, double[] data) {
        super(dims);
        this._data = data;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isNumeric(Types.ValueType vt) {
        return Types.ValueType.FP64 == vt;
    }

    @Override
    public void reset(int rlen, int[] odims, double v) {
        int len = rlen * odims[0];
        if ((long)len > this.capacity()) {
            this._data = new double[len];
            if (v != 0.0) {
                Arrays.fill(this._data, v);
            }
        } else {
            Arrays.fill(this._data, 0, len, v);
        }
        this._rlen = rlen;
        this._odims = odims;
    }

    @Override
    public void resetNoFill(int rlen, int[] odims) {
        int len = rlen * odims[0];
        if ((long)len > this.capacity()) {
            this._data = new double[len];
        }
        this._rlen = rlen;
        this._odims = odims;
    }

    public static double estimateMemory(long nrows, long ncols) {
        if ((double)nrows * (double)ncols > 9.223372036854776E18) {
            return 9.223372036854776E18;
        }
        return DenseBlock.estimateMemory(nrows, ncols) + MemoryEstimates.doubleArrayCost(nrows * ncols);
    }

    @Override
    public long capacity() {
        return this._data != null ? (long)this._data.length : -1L;
    }

    @Override
    protected long computeNnz(int bix, int start, int length) {
        return UtilFunctions.computeNnz(this._data, start, length);
    }

    @Override
    public double[] values(int r) {
        return this._data;
    }

    @Override
    public double[] valuesAt(int bix) {
        return this._data;
    }

    @Override
    public int index(int r) {
        return 0;
    }

    @Override
    public int pos(int r) {
        return r * this._odims[0];
    }

    @Override
    public int pos(int r, int c) {
        return r * this._odims[0] + c;
    }

    @Override
    public void incr(int r, int c) {
        int n = this.pos(r, c);
        this._data[n] = this._data[n] + 1.0;
    }

    @Override
    public void incr(int r, int c, double delta) {
        int n = this.pos(r, c);
        this._data[n] = this._data[n] + delta;
    }

    @Override
    public void fillBlock(int bix, int fromIndex, int toIndex, double v) {
        Arrays.fill(this._data, fromIndex, toIndex, v);
    }

    @Override
    public void fillRow(int r, double v) {
        int start = this.pos(r);
        int end = start + this.getDim(1);
        Arrays.fill(this._data, start, end, v);
    }

    @Override
    protected void setInternal(int bix, int ix, double v) {
        this._data[ix] = v;
    }

    @Override
    public DenseBlock set(int r, int c, double v) {
        this._data[this.pos((int)r, (int)c)] = v;
        return this;
    }

    @Override
    public DenseBlock set(DenseBlock db) {
        System.arraycopy(db.valuesAt(0), 0, this._data, 0, this._rlen * this._odims[0]);
        return this;
    }

    @Override
    public DenseBlock set(int rl, int ru, int ol, int ou, DenseBlock db) {
        double[] a = db.valuesAt(0);
        if (ol == 0 && ou == this._odims[0]) {
            System.arraycopy(a, 0, this._data, rl * this._odims[0], (ru - rl) * this._odims[0]);
        } else {
            int len = ou - ol;
            int i = rl;
            int ix1 = 0;
            int ix2 = rl * this._odims[0] + ol;
            while (i < ru) {
                System.arraycopy(a, ix1, this._data, ix2, len);
                ++i;
                ix1 += len;
                ix2 += this._odims[0];
            }
        }
        return this;
    }

    @Override
    public DenseBlock set(int r, double[] v) {
        System.arraycopy(v, 0, this._data, this.pos(r), this._odims[0]);
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, double v) {
        this._data[this.pos((int[])ix)] = v;
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, long v) {
        this._data[this.pos((int[])ix)] = v;
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, String v) {
        this._data[this.pos((int[])ix)] = Double.parseDouble(v);
        return this;
    }

    @Override
    public double get(int r, int c) {
        return this._data[this.pos(r, c)];
    }

    @Override
    public double get(int[] ix) {
        return this._data[this.pos(ix)];
    }

    @Override
    public String getString(int[] ix) {
        return String.valueOf(this._data[this.pos(ix)]);
    }

    @Override
    public long getLong(int[] ix) {
        return UtilFunctions.toLong(this._data[this.pos(ix)]);
    }
}

