/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import java.util.BitSet;
import java.util.stream.IntStream;
import org.apache.sysds.common.Types;
import org.apache.sysds.common.Warnings;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.DenseBlockLDRB;
import org.apache.sysds.runtime.util.DataConverter;
import org.apache.sysds.runtime.util.UtilFunctions;

public class DenseBlockLBool
extends DenseBlockLDRB {
    private static final long serialVersionUID = 2604223782138590322L;
    private BitSet[] _blocks;

    public DenseBlockLBool(int[] dims) {
        super(dims);
        this.reset(this._rlen, this._odims, 0.0);
    }

    @Override
    protected void allocateBlocks(int numBlocks) {
        this._blocks = new BitSet[numBlocks];
    }

    @Override
    protected void allocateBlock(int bix, int length) {
        this._blocks[bix] = new BitSet(length);
    }

    @Override
    protected void setInternal(int bix, int ix, double v) {
        this._blocks[bix].set(ix, v != 0.0);
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isNumeric(Types.ValueType vt) {
        return Types.ValueType.BOOLEAN == vt;
    }

    @Override
    public boolean isContiguous() {
        return this._blocks.length == 1;
    }

    @Override
    public void reset(int rlen, int[] odims, double v) {
        boolean bv = v != 0.0;
        long dataLength = (long)rlen * (long)odims[0];
        int newBlockSize = Math.min(rlen, MAX_ALLOC / odims[0]);
        int numBlocks = UtilFunctions.toInt(Math.ceil((double)rlen / (double)newBlockSize));
        if (this._blen == newBlockSize && dataLength <= this.capacity()) {
            for (int i2 = 0; i2 < numBlocks; ++i2) {
                int toIndex = (int)Math.min((long)newBlockSize, dataLength - (long)(i2 * newBlockSize)) * this._odims[0];
                this._blocks[i2].set(0, toIndex, bv);
                this._blocks[i2].set(toIndex, this._blocks[i2].size(), false);
            }
        } else {
            int lastBlockSize = (newBlockSize == rlen ? newBlockSize : rlen % newBlockSize) * odims[0];
            this.allocateBlocks(numBlocks);
            IntStream.range(0, numBlocks).forEach(i -> {
                int length = i == numBlocks - 1 ? lastBlockSize : newBlockSize;
                this.allocateBlock(i, length);
                this._blocks[i].set(0, length, bv);
            });
        }
        this._blen = newBlockSize;
        this._rlen = rlen;
        this._odims = odims;
    }

    @Override
    public int numBlocks() {
        return this._blocks.length;
    }

    @Override
    public long capacity() {
        return this._blocks != null ? (long)(this._blocks.length - 1) * (long)this._blocks[0].size() + (long)this._blocks[this._blocks.length - 1].size() : -1L;
    }

    @Override
    protected long computeNnz(int bix, int start, int length) {
        if (start == 0 && length == this.blockSize(bix) * this._odims[0]) {
            return this._blocks[bix].cardinality();
        }
        BitSet mask = new BitSet(this._blocks[bix].size());
        mask.set(start, length + start);
        mask.and(this._blocks[bix]);
        return mask.cardinality();
    }

    @Override
    public double[] values(int r) {
        return this.valuesAt(this.index(r));
    }

    @Override
    public double[] valuesAt(int bix) {
        int length = this.blockSize(bix) * this._odims[0];
        Warnings.warnFullFP64Conversion(length);
        return DataConverter.toDouble(this._blocks[bix], length);
    }

    @Override
    public void incr(int r, int c) {
        this._blocks[this.index(r)].set(this.pos(r, c));
    }

    @Override
    public void incr(int r, int c, double delta) {
        if (delta != 0.0) {
            this._blocks[this.index(r)].set(this.pos(r, c));
        }
    }

    @Override
    public void fillBlock(int bix, int fromIndex, int toIndex, double v) {
        this._blocks[bix].set(fromIndex, toIndex, v != 0.0);
    }

    @Override
    public void fillRow(int r, double v) {
        int start = this.pos(r);
        int end = start + this.getDim(1);
        this._blocks[this.index(r)].set(start, end, v != 0.0);
    }

    @Override
    public DenseBlock set(String s) {
        boolean b = Boolean.parseBoolean(s);
        for (int i = 0; i < this.numBlocks() - 1; ++i) {
            this._blocks[i].set(0, this.blockSize() * this._odims[0], b);
        }
        this._blocks[this.numBlocks() - 1].set(0, this.blockSize(this.numBlocks() - 1) * this._odims[0], b);
        return this;
    }

    @Override
    public DenseBlock set(int r, int c, double v) {
        this._blocks[this.index(r)].set(this.pos(r, c), v != 0.0);
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, double v) {
        this._blocks[this.index(ix[0])].set(this.pos(ix), v != 0.0);
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, long v) {
        this._blocks[this.index(ix[0])].set(this.pos(ix), v != 0L);
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, String v) {
        this._blocks[this.index(ix[0])].set(this.pos(ix), Boolean.parseBoolean(v));
        return this;
    }

    @Override
    public double get(int r, int c) {
        return this._blocks[this.index(r)].get(this.pos(r, c)) ? 1.0 : 0.0;
    }

    @Override
    public double get(int[] ix) {
        return this._blocks[this.index(ix[0])].get(this.pos(ix)) ? 1.0 : 0.0;
    }

    @Override
    public String getString(int[] ix) {
        return String.valueOf(this._blocks[this.index(ix[0])].get(this.pos(ix)));
    }

    @Override
    public long getLong(int[] ix) {
        return this._blocks[this.index(ix[0])].get(this.pos(ix)) ? 1L : 0L;
    }
}

