/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.codegen.cplan;

import java.util.ArrayList;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.codegen.SpoofCompiler;
import org.apache.sysds.hops.codegen.SpoofFusedOp;
import org.apache.sysds.hops.codegen.cplan.CNode;
import org.apache.sysds.hops.codegen.cplan.CNodeTpl;
import org.apache.sysds.runtime.codegen.SpoofCellwise;
import org.apache.sysds.runtime.util.UtilFunctions;

public class CNodeCell
extends CNodeTpl {
    protected static final String JAVA_TEMPLATE = "package codegen;\nimport org.apache.sysds.runtime.codegen.LibSpoofPrimitives;\nimport org.apache.sysds.runtime.codegen.SpoofCellwise;\nimport org.apache.sysds.runtime.codegen.SpoofCellwise.AggOp;\nimport org.apache.sysds.runtime.codegen.SpoofCellwise.CellType;\nimport org.apache.sysds.runtime.codegen.SpoofOperator.SideInput;\nimport org.apache.commons.math3.util.FastMath;\n\npublic final class %TMP% extends SpoofCellwise {\n  public %TMP%() {\n    super(CellType.%TYPE%, %SPARSE_SAFE%, %SEQ%, %AGG_OP_NAME%);\n  }\n  protected double genexec(double a, SideInput[] b, double[] scalars, int m, int n, long grix, int rix, int cix) { \n%BODY_dense%    return %OUT%;\n  }\n}\n";
    private SpoofCellwise.CellType _type = null;
    private Types.AggOp _aggOp = null;
    private boolean _sparseSafe = false;
    private boolean _containsSeq = true;
    private boolean _requiresCastdtm = false;
    private boolean _multipleConsumers = false;

    public CNodeCell(ArrayList<CNode> inputs, CNode output) {
        super(inputs, output);
    }

    public void setMultipleConsumers(boolean flag) {
        this._multipleConsumers = flag;
    }

    public boolean hasMultipleConsumers() {
        return this._multipleConsumers;
    }

    public void setCellType(SpoofCellwise.CellType type) {
        this._type = type;
        this._hash = 0;
    }

    public SpoofCellwise.CellType getCellType() {
        return this._type;
    }

    public void setAggOp(Types.AggOp aggop) {
        this._aggOp = aggop;
        this._hash = 0;
    }

    public Types.AggOp getAggOp() {
        return this._aggOp;
    }

    public SpoofCellwise.AggOp getSpoofAggOp() {
        if (this._aggOp != null) {
            switch (this._aggOp) {
                case SUM: {
                    return SpoofCellwise.AggOp.SUM;
                }
                case SUM_SQ: {
                    return SpoofCellwise.AggOp.SUM_SQ;
                }
                case MIN: {
                    return SpoofCellwise.AggOp.MIN;
                }
                case MAX: {
                    return SpoofCellwise.AggOp.MAX;
                }
            }
            throw new RuntimeException("Unsupported cell type: " + this._type.toString());
        }
        return null;
    }

    public void setSparseSafe(boolean flag) {
        this._sparseSafe = flag;
    }

    public boolean isSparseSafe() {
        return this._sparseSafe;
    }

    public void setContainsSeq(boolean flag) {
        this._containsSeq = flag;
    }

    public boolean containsSeq() {
        return this._containsSeq;
    }

    public void setRequiresCastDtm(boolean flag) {
        this._requiresCastdtm = flag;
        this._hash = 0;
    }

    public boolean requiredCastDtm() {
        return this._requiresCastdtm;
    }

    @Override
    public void renameInputs() {
        this.rRenameDataNode(this._output, (CNode)this._inputs.get(0), "a");
        this.renameInputs(this._inputs, 1);
    }

    @Override
    public String codegen(boolean sparse, SpoofCompiler.GeneratorAPI _api) {
        this.api = _api;
        String tmp = this.getLanguageTemplate(this, this.api);
        String tmpDense = this._output.codegen(false, this.api);
        if (this.api == SpoofCompiler.GeneratorAPI.CUDA) {
            tmpDense = tmpDense.replace("a.vals(0)", "a");
        }
        this._output.resetGenerated();
        String varName = this.getVarname() == null ? this.createVarname() : this.getVarname();
        tmp = tmp.replace(this.api.isJava() ? "%TMP%" : "/*%TMP%*/SPOOF_OP_NAME", varName);
        tmp = tmpDense.contains("grix") ? tmp.replace("//%NEED_GRIX%", "\t\tuint32_t grix=_grix + rix;") : tmp.replace("//%NEED_GRIX%\n", "");
        tmp = tmp.replace("%BODY_dense%", tmpDense);
        tmp = this.api.isJava() || this._aggOp != Types.AggOp.SUM_SQ ? tmp.replaceAll("%OUT%", this._output.getVarname()) : tmp.replaceAll("%OUT%", this._output.getVarname() + " * " + this._output.getVarname());
        tmp = tmp.replaceAll("%TYPE%", this.getCellType().name());
        tmp = tmp.replace("%AGG_OP_NAME%", (CharSequence)(this._aggOp != null ? "AggOp." + this._aggOp.name() : "null"));
        tmp = tmp.replace("%SPARSE_SAFE%", String.valueOf(this.isSparseSafe()));
        tmp = tmp.replace("%SEQ%", String.valueOf(this.containsSeq()));
        if (this.api == SpoofCompiler.GeneratorAPI.CUDA) {
            String agg_op = "IdentityOp";
            String initial_value = "(T)1.0";
            if (this._aggOp != null) {
                switch (this._aggOp) {
                    case SUM: 
                    case SUM_SQ: {
                        agg_op = "SumOp";
                        initial_value = "(T)0.0";
                        break;
                    }
                    case MIN: {
                        agg_op = "MinOp";
                        initial_value = "MAX<T>()";
                        break;
                    }
                    case MAX: {
                        agg_op = "MaxOp";
                        initial_value = "-MAX<T>()";
                        break;
                    }
                    default: {
                        agg_op = "IdentityOp";
                        initial_value = "(T)0.0";
                    }
                }
            }
            tmp = tmp.replaceAll("%AGG_OP%", agg_op);
            tmp = tmp.replaceAll("%INITIAL_VALUE%", initial_value);
        }
        return tmp;
    }

    @Override
    public void setOutputDims() {
    }

    @Override
    public CNodeTpl clone() {
        CNodeCell tmp = new CNodeCell(this._inputs, this._output);
        tmp.setDataType(this.getDataType());
        tmp.setCellType(this.getCellType());
        tmp.setMultipleConsumers(this.hasMultipleConsumers());
        return tmp;
    }

    @Override
    public SpoofFusedOp.SpoofOutputDimsType getOutputDimType() {
        switch (this._type) {
            case NO_AGG: {
                return SpoofFusedOp.SpoofOutputDimsType.INPUT_DIMS;
            }
            case ROW_AGG: {
                return SpoofFusedOp.SpoofOutputDimsType.ROW_DIMS;
            }
            case COL_AGG: {
                return SpoofFusedOp.SpoofOutputDimsType.COLUMN_DIMS_COLS;
            }
            case FULL_AGG: {
                return SpoofFusedOp.SpoofOutputDimsType.SCALAR;
            }
        }
        throw new RuntimeException("Unsupported cell type: " + this._type.toString());
    }

    @Override
    public int hashCode() {
        if (this._hash == 0) {
            int h = super.hashCode();
            h = UtilFunctions.intHashCode(h, this._type.hashCode());
            h = UtilFunctions.intHashCode(h, this._aggOp != null ? this._aggOp.hashCode() : 0);
            h = UtilFunctions.intHashCode(h, Boolean.hashCode(this._sparseSafe));
            this._hash = h = UtilFunctions.intHashCode(h, Boolean.hashCode(this._requiresCastdtm));
        }
        return this._hash;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CNodeCell)) {
            return false;
        }
        CNodeCell that = (CNodeCell)o;
        return super.equals(that) && this._type == that._type && this._aggOp == that._aggOp && this._sparseSafe == that._sparseSafe && this._requiresCastdtm == that._requiresCastdtm && CNodeCell.equalInputReferences(this._output, that._output, (ArrayList<CNode>)this._inputs, (ArrayList<CNode>)that._inputs);
    }

    @Override
    public String getTemplateInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("SPOOF CELLWISE [type=");
        sb.append(this._type.name());
        sb.append(", aggOp=" + (this._aggOp != null ? this._aggOp.name() : "null"));
        sb.append(", sparseSafe=" + this._sparseSafe);
        sb.append(", castdtm=" + this._requiresCastdtm);
        sb.append(", mc=" + this._multipleConsumers);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean isSupported(SpoofCompiler.GeneratorAPI api) {
        return (api == SpoofCompiler.GeneratorAPI.CUDA || api == SpoofCompiler.GeneratorAPI.JAVA) && this._output.isSupported(api);
    }

    @Override
    public int compile(SpoofCompiler.GeneratorAPI api, String src) {
        if (api == SpoofCompiler.GeneratorAPI.CUDA) {
            return this.compile_nvrtc(SpoofCompiler.native_contexts.get((Object)api), this._genVar, src, this._type.getValue(), this._aggOp != null ? this._aggOp.ordinal() : 0, this._sparseSafe);
        }
        return -1;
    }

    private native int compile_nvrtc(long var1, String var3, String var4, int var5, int var6, boolean var7);
}

